<?php
/**
 * @package krystal
 */


/**
 * Krystal Header Style 1
 */
if ( ! function_exists( 'krystal_header_style_1' ) ) :
function krystal_header_style_1() {
    ?>
    <header id="home-inner" class="menu-wrapper style-1 elementor-menu-anchor">
        <a class="skip-link screen-reader-text" href="#maincontent"><?php esc_html_e( 'Skip to content', 'krystal' ); ?></a>
        <?php krystal_before_menu(); ?>
        <div class="navigation scroll-fix">
            <div class="container">                                                       
                <div class="row">
                    <div class="logo">
                        <?php 
                        // Display custom logo
                        if ( has_custom_logo() ) {
                            krystal_the_custom_logo();
                        }

                        // Display alternate logo
                        $alt_logo = esc_url( get_theme_mod( 'kr_alt_logo' ) );
                        if ( ! empty( $alt_logo ) ) {
                            ?>
                            <a id="logo-alt" class="logo-alt" href="<?php echo esc_url( home_url() ); ?>">
                                <img src="<?php echo $alt_logo; ?>" alt="logo">
                            </a>
                            <?php
                        }

                        // Display site title and tagline
                        if ( true === get_theme_mod( 'kr_display_site_title_tagline', true ) ) {
                            $site_name = get_bloginfo( 'name' );
                            $description = esc_html(get_bloginfo( 'description', 'display' ));

                            if ( ! empty( $site_name ) ) {
                                $header_tag = is_front_page() ? 'h1' : 'p';
                                ?>
                                <<?php echo esc_attr( $header_tag ); ?> class="site-title">
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( $site_name ); ?></a>
                                </<?php echo esc_attr( $header_tag ); ?>>
                                <?php
                                
                                if ( $description || is_customize_preview() ) {
                                    ?>
                                    <p class="site-description"><?php echo esc_html( $description ); ?></p>
                                    <?php
                                }
                            }
                        }
                        ?>
                    </div>

                    <?php krystal_woocommerce_show_cart(); ?>

                    <div class="top-menu navbar" id="top-menu-wrapper">
                        <nav class="krystal-main-menu navbar" id="krystal-main-menu-wrapper">
                            <div class="navbar-header">
                                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse-1" aria-expanded="false">
                                    <span class="sr-only"><?php esc_html_e( 'Toggle navigation', 'krystal' ); ?></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                            </div>
                            <div class="collapse navbar-collapse" id="navbar-collapse-1">
                                <?php
                                wp_nav_menu( array(
                                    'theme_location' => 'primary',
                                    'depth'          => 3,
                                    'container'      => 'ul',
                                    'menu_class'     => 'nav',
                                    'fallback_cb'    => 'wp_bootstrap_navwalker::fallback',
                                    'walker'         => new wp_bootstrap_navwalker(),
                                ) );
                                ?>
                                <a class="popup-close hidden-md hidden-lg" href="#"></a>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <?php
}
endif;


/**
 * Krystal Header Style 2
 */
if ( ! function_exists( 'krystal_header_style_2' ) ) :
function krystal_header_style_2() {
    ?>
    <header id="home-inner" class="menu-wrapper style-2 elementor-menu-anchor">
        <a class="skip-link screen-reader-text" href="#maincontent"><?php esc_html_e( 'Skip to content', 'krystal' ); ?></a>
        <?php krystal_before_menu(); ?>
        <div class="navigation scroll-fix">
            <div class="container">                                                       
                <div class="row">
                    <div class="logo">
                        <?php 
                        // Display custom logo
                        if ( has_custom_logo() ) {
                            krystal_the_custom_logo();
                        }

                        // Display alternate logo
                        $alt_logo = esc_url( get_theme_mod( 'kr_alt_logo' ) );
                        if ( ! empty( $alt_logo ) ) {
                            ?>
                            <a id="logo-alt" class="logo-alt" href="<?php echo esc_url( home_url() ); ?>">
                                <img src="<?php echo $alt_logo; ?>" alt="logo">
                            </a>
                            <?php
                        }

                        // Display site title and tagline
                        if ( true === get_theme_mod( 'kr_display_site_title_tagline', true ) ) {
                            $site_name = get_bloginfo( 'name' );
                            $description = esc_html(get_bloginfo( 'description', 'display' ));

                            if ( ! empty( $site_name ) ) {
                                $header_tag = is_front_page() ? 'h1' : 'p';
                                ?>
                                <<?php echo esc_attr( $header_tag ); ?> class="site-title">
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( $site_name ); ?></a>
                                </<?php echo esc_attr( $header_tag ); ?>>
                                <?php
                                
                                if ( $description || is_customize_preview() ) {
                                    ?>
                                    <p class="site-description"><?php echo esc_html( $description ); ?></p>
                                    <?php
                                }
                            }
                        }
                        ?>
                    </div>

                    <?php krystal_woocommerce_show_cart(); ?>

                    <div class="top-menu navbar" id="top-menu-wrapper">
                        <nav class="krystal-main-menu navbar" id="krystal-main-menu-wrapper">
                            <div class="navbar-header">
                                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse-1" aria-expanded="false">
                                    <span class="sr-only"><?php esc_html_e( 'Toggle navigation', 'krystal' ); ?></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                            </div>
                            <div class="collapse navbar-collapse" id="navbar-collapse-1">
                                <?php
                                wp_nav_menu( array(
                                    'theme_location' => 'primary',
                                    'depth'          => 3,
                                    'container'      => 'ul',
                                    'menu_class'     => 'nav',
                                    'fallback_cb'    => 'wp_bootstrap_navwalker::fallback',
                                    'walker'         => new wp_bootstrap_navwalker(),
                                ) );
                                ?>
                                <a class="popup-close hidden-md hidden-lg" href="#"></a>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <?php
}
endif;


if ( ! function_exists( 'krystal_action_header_hook' ) ) :
function krystal_action_header_hook() {
    // Get the header style option once
    $header_style = esc_html( get_theme_mod( 'kr_header_styles', 'style1' ) );

    // Conditionally add the appropriate header style function to the hook
    $header_function = ( 'style1' === $header_style ) ? 'krystal_header_style_1' : 'krystal_header_style_2';
    add_action( 'krystal_action_header', $header_function );
}
endif;
add_action( 'wp', 'krystal_action_header_hook' );




/**
 * Krystal Footer
 */

if ( ! function_exists( 'krystal_footer_copyrights' ) ) :
function krystal_footer_copyrights() {
    $copyright_text = esc_html( get_theme_mod( 'kr_copyright_text' ) );
    $footer_enabled = get_theme_mod( 'kr_footer_enable_footer_links', false );

    ?>
    <div class="row">
        <div class="copyrights">
            <p>
                <?php
                // Display custom copyright text or default text
                if ( ! empty( $copyright_text ) ) {
                    echo $copyright_text;

                    // Show theme credit if enabled
                    if ( get_theme_mod( 'kr_en_footer_credits', true ) ) {
                        echo ' | ' . esc_html__( 'Theme by ', 'krystal' ) . '<a href="' . esc_url( KRYSTAL_THEME_AUTH ) . '" target="_blank">' . esc_html__( 'Spiracle Themes', 'krystal' ) . '</a>';
                    }

                } else {
                    // Default copyright information
                    echo date_i18n( _x( 'Y', 'copyright date format', 'krystal' ) ) . ' <a href="' . esc_url( home_url( '/' ) ) . '">' . get_bloginfo( 'name' ) . '</a>';
                    echo ' | ' . esc_html__( 'Theme by ', 'krystal' ) . '<a href="' . esc_url( KRYSTAL_THEME_AUTH ) . '" target="_blank">' . esc_html__( 'Spiracle Themes', 'krystal' ) . '</a>';
                }

                // Display footer links if enabled
                if ( $footer_enabled ) :
                    $footer_links = [
                        'kr_footer_link_1_text' => 'kr_footer_link_1_url',
                        'kr_footer_link_2_text' => 'kr_footer_link_2_url',
                        'kr_footer_link_3_text' => 'kr_footer_link_3_url',
                    ];
                    $link_html = '';
                    foreach ( $footer_links as $text_option => $url_option ) {
                        $text = get_theme_mod( $text_option );
                        $url = get_theme_mod( $url_option );
                        if ( ! empty( $text ) && ! empty( $url ) ) {
                            $link_html .= '<span>|</span><a href="' . esc_url( $url ) . '">' . esc_html( $text ) . '</a>';
                        }
                    }
                    if ( $link_html ) {
                        echo '<span class="copyrights-links">' . $link_html . '</span>';
                    }
                endif;
                ?>
            </p>
        </div>
    </div>
    <?php
}
endif;


if ( ! function_exists( 'krystal_action_footer_hook' ) ) :
function krystal_action_footer_hook() {
    // Directly add the footer action without unnecessary conditionals
    add_action( 'krystal_action_footer', 'krystal_footer_copyrights' );
}
endif;
add_action( 'wp', 'krystal_action_footer_hook' );




/**
 * Krystal Page Title
 */

if ( ! function_exists( 'krystal_get_page_title' ) ) :
function krystal_get_page_title($blogtitle = false, $archivetitle = false, $searchtitle = false, $pagenotfoundtitle = false) {
    if ( ! is_front_page() ) {
        $bg_type = esc_html( get_theme_mod( 'kr_page_bg_radio', 'color' ) );
        $bg_color = sanitize_hex_color( get_theme_mod( 'kr_page_bg_color', '#1e73be' ) );
        $bg_image = esc_url( get_theme_mod( 'kr_page_bg_image', get_template_directory_uri() . '/img/start-bg.jpg' ) );
        $parallax = get_theme_mod( 'kr_page_bg_parallax', true );

        $bg_style = '';
        if ( $bg_type === 'color' ) {
            $bg_style = "background: $bg_color;";
        } elseif ( $bg_type === 'image' ) {
            $featured_img_url = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_ID(), 'full' ) : $bg_image;
            $bg_style = $parallax ? "data-parallax='scroll' data-image-src='$featured_img_url'" : "background: url('$featured_img_url') no-repeat center center / cover;";
        } else {
            $bg_style = "background: #555555;";
        }

        ?>
        <div class="page-title" style="<?php echo $bg_style; ?>">
            <div class="content-section img-overlay">
                <div class="container">
                    <div class="row text-center">
                        <div class="col-md-12">
                            <div class="section-title page-title">
                                <?php
                                    if ( $blogtitle ) {
                                        ?><h1 class="main-title"><?php single_post_title(); ?></h1><?php
                                    } elseif ( $archivetitle ) {
                                        ?><h1 class="main-title"><?php the_archive_title(); ?></h1><?php
                                    } elseif ( $searchtitle ) {
                                        ?><h1 class="main-title"><?php esc_html_e( 'SEARCH RESULTS', 'krystal' ); ?></h1><?php
                                    } elseif ( $pagenotfoundtitle ) {
                                        ?><h1 class="main-title"><?php esc_html_e( 'PAGE NOT FOUND', 'krystal' ); ?></h1><?php
                                    } else {
                                        ?><h1 class="main-title"><?php the_title(); ?></h1><?php
                                    }
                                ?>
                                <div class="breadcrumb-wrapper">
                                    <?php 
                                    if ( get_theme_mod( 'krystal_enable_page_breadcrumbs', true ) ) :
                                        $breadcrumb_from = esc_html( get_theme_mod( 'kr_page_breadcrumb_select_radio', 'default' ) );
                                        if ( function_exists( 'yoast_breadcrumb' ) && $breadcrumb_from === 'yoast' ) :
                                            yoast_breadcrumb( '<p id="breadcrumbs">', '</p>' );
                                        elseif ( function_exists( 'bcn_display' ) && $breadcrumb_from === 'navxt' ) :
                                            bcn_display();
                                        else :
                                            require get_template_directory() . '/inc/breadcrumbs.php';
                                            breadcrumb_trail( [ 'container' => 'div', 'show_browse' => false ] );
                                        endif;
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
        </div> <!-- End page-title -->
        <?php
    }
}
endif;



/**
 * Preloading Fonts
 */
function krystal_enqueue_fonts_file() {
    wp_enqueue_style('preload-webfont-fa-regular',get_template_directory_uri() . '/webfonts/fa-regular-400.woff2', array(), null);
    wp_enqueue_style('preload-webfont-fa-brands',get_template_directory_uri() . '/webfonts/fa-brands-400.woff2', array(), null);
    wp_enqueue_style('preload-webfont-fa-solid',get_template_directory_uri() . '/webfonts/fa-solid-900.woff2', array(), null);
    wp_enqueue_style('preload-poppins-google-font', 'https://fonts.googleapis.com/css?family=Poppins:300,400,700,900&display=swap', array(), null);
}
add_action('wp_enqueue_scripts', 'krystal_enqueue_fonts_file');


function krystal_style_loader_tag_filter($html, $handle) {
    if ($handle === 'preload-webfont-fa-regular') {
        $html_wrap = str_replace("rel='stylesheet'","rel='preload' as='font' type='font/woff2' crossorigin='anonymous'", $html);
        return str_replace("type='text/css' media='all'","", $html_wrap);
    }
    if ($handle === 'preload-webfont-fa-brands') {
        $html_wrap = str_replace("rel='stylesheet'","rel='preload' as='font' type='font/woff2' crossorigin='anonymous'", $html);
        return str_replace("type='text/css' media='all'","", $html_wrap);
    }
    if ($handle === 'preload-webfont-fa-solid') {
        $html_wrap = str_replace("rel='stylesheet'","rel='preload' as='font' type='font/woff2' crossorigin='anonymous'", $html);
        return str_replace("type='text/css' media='all'","", $html_wrap);
    }
    if ($handle === 'preload-poppins-google-font') {
        $html_wrap = str_replace("rel='stylesheet'","rel='preload' as='style' crossorigin='anonymous'", $html);
        return str_replace("type='text/css' media='all'","", $html_wrap);
    }
    return $html;
}
add_filter('style_loader_tag', 'krystal_style_loader_tag_filter', 10, 2);


/**
 * Function for Minimizing dynamic CSS
 */
function krystal_minimize_css($css){
    $css = preg_replace('/\/\*((?!\*\/).)*\*\//', '', $css);
    $css = preg_replace('/\s{2,}/', ' ', $css);
    $css = preg_replace('/\s*([:;{}])\s*/', '$1', $css);
    $css = preg_replace('/;}/', '}', $css);
    return $css;
}


/**
 * Add Class to body
 */

function krystal_body_class_blocks( $classes ) {
	if ( is_singular() && has_blocks() ) {
		$classes[] = 'has-blocks';
	}
	return $classes;
}
add_filter( 'body_class', 'krystal_body_class_blocks' );


/**
 * Remove class from woo pages
 */

function krystal_remove_blocks_cart ($wp_classes) {
    if ( krystal_is_woocommerce_activated() ) :
        if ( is_page( 'cart' ) || is_cart() || is_page( 'checkout' ) || is_checkout() || is_page( 'my-account' ) || is_account_page() ) :
            unset( $wp_classes[ array_search( "has-blocks", $wp_classes ) ] );
        endif;
    endif;
    return $wp_classes;
}
add_filter( 'body_class', 'krystal_remove_blocks_cart' );


/** 
* Disable Plugin Redirect
*/
function krystal_prevent_plugins_redirect() {
    delete_transient( 'elementor_activation_redirect' );
}
add_action('admin_init', 'krystal_prevent_plugins_redirect');