<?php

/**
 * Function to return the array of starter content for the theme.
 *
 * Passes it through the `krystal_starter_content` filter before returning.
 *
 *
 * @return array A filtered array of args for the starter_content.
 */
function krystal_get_starter_content() {

	// Define and register starter content to showcase the theme on new sites.
	$starter_content = array(

		// Specify the core-defined pages to create and add custom thumbnails to some of them.
		'posts'     => array(
			'front' => array(
				'post_type'    => 'page',
				'post_title'   => esc_html__( 'Home', 'krystal' ),
				'post_content' => '
					<!-- wp:cover {"minHeight":700,"customGradient":"linear-gradient(135deg,rgb(179,68,202) 0%,rgb(59,108,239) 100%)"} -->
					<div class="wp-block-cover has-background-dim has-background-gradient" style="background:linear-gradient(135deg,rgb(179,68,202) 0%,rgb(59,108,239) 100%);min-height:700px"><div class="wp-block-cover__inner-container"><!-- wp:spacer {"height":60} -->
					<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"50px"}},"className":"margin-bottom-30"} -->
					<h2 class="has-text-align-center margin-bottom-30" style="font-size:50px"><strong>KRYSTAL WORDPRESS THEME</strong></h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center"} -->
					<p class="has-text-align-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. </p>
					<!-- /wp:paragraph -->

					<!-- wp:spacer {"height":60} -->
					<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:buttons {"contentJustification":"center"} -->
					<div class="wp-block-buttons is-content-justification-center"><!-- wp:button {"backgroundColor":"black","textColor":"white"} -->
					<div class="wp-block-button"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background">Learn More -&gt;</a></div>
					<!-- /wp:button --></div>
					<!-- /wp:buttons -->

					<!-- wp:paragraph {"align":"center"} -->
					<p class="has-text-align-center"></p>
					<!-- /wp:paragraph --></div></div>
					<!-- /wp:cover -->

					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:columns {"verticalAlignment":"top"} -->
					<div class="wp-block-columns are-vertically-aligned-top"><!-- wp:column {"verticalAlignment":"top"} -->
					<div class="wp-block-column is-vertically-aligned-top"><!-- wp:image {"align":"center","id":1069,"sizeSlug":"full","linkDestination":"none"} -->
					<div class="wp-block-image"><figure class="aligncenter size-full"><img src="' . esc_url( get_stylesheet_directory_uri() ) . '/img/icon1.png" alt="' . esc_attr__( 'Icon 1', 'krystal' ) . '" class="wp-image-1069"/></figure></div>
					<!-- /wp:image -->

					<!-- wp:heading {"textAlign":"center","textColor":"black","className":"margin-bottom-20","fontSize":"medium"} -->
					<h2 class="has-text-align-center margin-bottom-20 has-black-color has-text-color has-medium-font-size"><meta charset="utf-8">Web Design</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center"} -->
					<p class="has-text-align-center">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam vel dignissim odio. Aenean lacus nunc, semper eu ligula eu, efficitur dictum ligula</p>
					<!-- /wp:paragraph --></div>
					<!-- /wp:column -->

					<!-- wp:column {"verticalAlignment":"top"} -->
					<div class="wp-block-column is-vertically-aligned-top"><!-- wp:image {"align":"center","id":1070,"sizeSlug":"full","linkDestination":"none"} -->
					<div class="wp-block-image"><figure class="aligncenter size-full"><img src="' . esc_url( get_stylesheet_directory_uri() ) . '/img/icon2.png" alt="' . esc_attr__( 'Icon 2', 'krystal' ) . '" class="wp-image-1070"/></figure></div>
					<!-- /wp:image -->

					<!-- wp:heading {"textAlign":"center","textColor":"black","className":"margin-bottom-20","fontSize":"medium"} -->
					<h2 class="has-text-align-center margin-bottom-20 has-black-color has-text-color has-medium-font-size"><meta charset="utf-8">WordPress Development</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center"} -->
					<p class="has-text-align-center"><meta charset="utf-8">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam vel dignissim odio. Aenean lacus nunc, semper eu ligula eu, efficitur dictum ligula</p>
					<!-- /wp:paragraph --></div>
					<!-- /wp:column -->

					<!-- wp:column {"verticalAlignment":"top"} -->
					<div class="wp-block-column is-vertically-aligned-top"><!-- wp:image {"align":"center","id":1071,"sizeSlug":"full","linkDestination":"none"} -->
					<div class="wp-block-image"><figure class="aligncenter size-full"><img src="' . esc_url( get_stylesheet_directory_uri() ) . '/img/icon3.png" alt="' . esc_attr__( 'Icon 3', 'krystal' ) . '" class="wp-image-1071"/></figure></div>
					<!-- /wp:image -->

					<!-- wp:heading {"textAlign":"center","textColor":"black","className":"margin-bottom-20","fontSize":"medium"} -->
					<h2 class="has-text-align-center margin-bottom-20 has-black-color has-text-color has-medium-font-size">SEO Services</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center"} -->
					<p class="has-text-align-center"><meta charset="utf-8">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam vel dignissim odio. Aenean lacus nunc, semper eu ligula eu, efficitur dictum ligula</p>
					<!-- /wp:paragraph --></div>
					<!-- /wp:column --></div>
					<!-- /wp:columns -->

					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:cover {"url":"' . esc_url( get_stylesheet_directory_uri() ) . '/img/img-1.jpg","id":1091,"minHeight":500} -->
					<div class="wp-block-cover has-background-dim" style="min-height:500px"><img class="wp-block-cover__image-background wp-image-1091" alt="" src="' . esc_url( get_stylesheet_directory_uri() ) . '/img/img-1.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:columns -->
					<div class="wp-block-columns"><!-- wp:column {"width":"100%"} -->
					<div class="wp-block-column" style="flex-basis:100%"><!-- wp:heading {"textAlign":"center","className":"margin-bottom-20"} -->
					<h2 class="has-text-align-center margin-bottom-20">About Us</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"className":"margin-bottom-30"} -->
					<p class="margin-bottom-30">Morbi commodo nibh a congue lacinia. Phasellus mauris augue, hendrerit eu semper vel, molestie eu tellus. Cras varius risus dui, ac consectetur orci sollicitudin quis. Fusce mattis quam eget tempor porttitor. Proin et mi at arcu auctor posuere. Etiam tempus est ut tellus pharetra, quis fermentum justo vulputate. Duis tortor metus, tempus sit amet nisi at, euismod interdum sem. Etiam tincidunt massa metus, quis egestas metus finibus nec. Aenean in lacinia nibh, sed mattis lectus. Cras sollicitudin accumsan rutrum. Integer ut tincidunt augue, posuere suscipit tellus. Maecenas vestibulum justo ac tellus imperdiet dapibus. Pellentesque ultrices tincidunt pulvinar&nbsp;cursus sodales, elit odio finibus metus, sit amet fermentum</p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons {"contentJustification":"center"} -->
					<div class="wp-block-buttons is-content-justification-center"><!-- wp:button -->
					<div class="wp-block-button"><a class="wp-block-button__link">Read More</a></div>
					<!-- /wp:button --></div>
					<!-- /wp:buttons --></div>
					<!-- /wp:column --></div>
					<!-- /wp:columns --></div></div>
					<!-- /wp:cover -->

					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:columns -->
					<div class="wp-block-columns"><!-- wp:column -->
					<div class="wp-block-column"><!-- wp:image {"id":1097,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="' . esc_url( get_stylesheet_directory_uri() ) . '/img/img-2.jpg" alt="' . esc_attr__( 'Image 2', 'krystal' ) . '" class="wp-image-1097"/></figure>
					<!-- /wp:image --></div>
					<!-- /wp:column -->

					<!-- wp:column {"verticalAlignment":"center"} -->
					<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"textColor":"black","className":"margin-bottom-30"} -->
					<h2 class="margin-bottom-30 has-black-color has-text-color">Why Choose Krystal</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"className":"margin-bottom-30"} -->
					<p class="margin-bottom-30">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque aliquam tristique orci quis auctor. Maecenas quis urna ac orci semper ullamcorper at sit amet mauris. Donec volutpat ornare dolor, ac venenatis nisi bibendum ac. Aliquam scelerisque urna nunc, suscipit semper tellus bibendum eget. Nulla ullamcorper metus placerat erat malesuada varius. Nulla viverra, lacus vitae tincidunt mollis, tellus libero faucibus massa,</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"className":"margin-bottom-50"} -->
					<p class="margin-bottom-50">Duis tristique odio quis magna blandit, a interdum velit mollis. Aliquam et consequat tortor. Fusce volutpat, libero nec facilisis venenatis, elit turpis blandit tortor, vel imperdiet justo risus porta dui. Nulla efficitur libero in diam commodo pulvinar. Phasellus ac odio id arcu vulputate mollis vel facilisis arcu.</p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons"><!-- wp:button -->
					<div class="wp-block-button"><a class="wp-block-button__link">LEARN MORE</a></div>
					<!-- /wp:button --></div>
					<!-- /wp:buttons --></div>
					<!-- /wp:column --></div>
					<!-- /wp:columns -->

					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:cover {"customOverlayColor":"#dddddd","minHeight":200} -->
					<div class="wp-block-cover has-background-dim" style="background-color:#dddddd;min-height:200px"><div class="wp-block-cover__inner-container"><!-- wp:columns -->
					<div class="wp-block-columns"><!-- wp:column {"verticalAlignment":"center","width":"66.66%"} -->
					<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:66.66%"><!-- wp:spacer {"height":50} -->
					<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:heading {"textColor":"black"} -->
					<h2 class="has-black-color has-text-color">Want to know more about theme</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"textColor":"black"} -->
					<p class="has-black-color has-text-color">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque pellentesque ut augue sed luctus.</p>
					<!-- /wp:paragraph --></div>
					<!-- /wp:column -->

					<!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
					<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:buttons {"contentJustification":"right"} -->
					<div class="wp-block-buttons is-content-justification-right"><!-- wp:button -->
					<div class="wp-block-button"><a class="wp-block-button__link">KNOW MORE</a></div>
					<!-- /wp:button --></div>
					<!-- /wp:buttons --></div>
					<!-- /wp:column --></div>
					<!-- /wp:columns --></div></div>
					<!-- /wp:cover -->

					<!-- wp:paragraph -->
					<p></p>
					<!-- /wp:paragraph -->
				',
			),
			'about' => array(
				'post_type'    => 'page',
				'post_title'   => esc_html__( 'About', 'krystal' ),
				'post_content' => '
					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:columns -->
					<div class="wp-block-columns"><!-- wp:column -->
					<div class="wp-block-column"><!-- wp:heading {"className":"margin-bottom-30"} -->
					<h2 class="margin-bottom-30">Who We Are</h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph -->
					<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sagittis a urna id cursus. Donec maximus diam risus, vel bibendum velit vulputate vitae. Morbi ut velit vitae diam malesuada consequat. Vestibulum facilisis metus in ultrices vehicula. Aenean mattis nulla nec diam facilisis, eget lobortis lorem tempus. In facilisis non quam lacinia euismod. Integer sed laoreet augue. Sed odio nisl, venenatis convallis elementum non, imperdiet sed enim. Nulla eget neque vitae lorem imperdiet sagittis ut id est. Maecenas metus massa, volutpat eu vestibulum in, consectetur nec tortor. Donec nec nunc interdum, convallis lacus in, tincidunt augue.</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph -->
					<p>Pellentesque dictum ante sit amet eros dapibus tempus. Sed vitae quam eu mi imperdiet facilisis. Duis molestie imperdiet sem in suscipit. Aenean sed est at augue vulputate consectetur vel in augue. Aliquam erat volutpat. In hac habitasse platea dictumst. Fusce pellentesque diam non accumsan rhoncus. Integer luctus, leo in placerat porttitor, elit sapien tincidunt erat, in sollicitudin nunc tellus at felis. Curabitur facilisis ullamcorper libero vel pretium. Donec maximus odio a sollicitudin placerat. Curabitur tempor tellus eget venenatis sodales. Phasellus ac ipsum vitae justo ornare tincidunt vitae sed urna. Aliquam erat volutpat.</p>
					<!-- /wp:paragraph --></div>
					<!-- /wp:column -->

					<!-- wp:column -->
					<div class="wp-block-column"><!-- wp:image {"id":1097,"sizeSlug":"full","linkDestination":"none"} -->
					<figure class="wp-block-image size-full"><img src="' . esc_url( get_stylesheet_directory_uri() ) . '/img/img-2.jpg" alt="' . esc_attr__( 'Icon 2', 'krystal' ) . '" class="wp-image-1097"/></figure>
					<!-- /wp:image --></div>
					<!-- /wp:column --></div>
					<!-- /wp:columns -->

					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->
				',
			),
			'blog',
			'contact' => array(
				'post_type'    => 'page',
				'post_title'   => esc_html__( 'Contact', 'krystal' ),
				'post_content' => '
					<!-- wp:spacer -->
					<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->

					<!-- wp:paragraph -->
					<p>This is a page with some basic contact information, such as an address and phone number. You might also try a plugin to add a contact form.</p>
					<!-- /wp:paragraph -->

					<!-- wp:spacer {"height":150} -->
					<div style="height:150px" aria-hidden="true" class="wp-block-spacer"></div>
					<!-- /wp:spacer -->
				',
			),
		),

		// Default to a static front page and assign the front and posts pages.
		'options'   => array(
			'show_on_front'  => 'page',
			'page_on_front'  => '{{front}}',
			'page_for_posts' => '{{blog}}',
			'blogdescription' => esc_html__( 'WordPress theme for Page builders', 'krystal' ),
			'blogname' => 'Krystal',
		),

		'theme_mods'  => array(
			'kr_home_disable_section'  => true,			
		),

		'widgets' => array(
			'footer-column1' => array(
				'text_world' => array(
			       	'text',
			        array(
			        	'title'  => esc_html__( 'About Us', 'krystal' ),
			        	'text'  => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras urna sem, imperdiet in leo et, fermentum luctus ipsum. Integer ut orci justo. Curabitur posuere rutrum condimentum. In porttitor ligula vel bibendum dictum',
			        )
			    ),
			),
			'footer-column2' => array(
				'text_world' => array(
			       	'text',
			        array(
			        	'title'  => esc_html__( 'Quick Links', 'krystal' ),
			        	'text'  => '<ul>
										<li><a href="#">' . esc_html__( 'Home', 'krystal' ) . '</a></li>
										<li><a href="#">' . esc_html__( 'About', 'krystal' ) . '</a></li>
										<li><a href="#">' . esc_html__( 'Services', 'krystal' ) . '</a></li>
										<li><a href="#">' . esc_html__( 'Blog', 'krystal' ) . '</a></li>
										<li><a href="#">' . esc_html__( 'Contact', 'krystal' ) . '</a></li>									
									</ul>',
			        )
			    ),
			),
			'footer-column3' => array(
				'calendar'
			),
			'footer-column4' => array(
				'text_world' => array(
			       	'text',
			        array(
			        	'title'  => esc_html__( 'Contact Us', 'krystal' ),
			        	'text'  => '<i class="fas fa-map-marker"></i>
									123 Lorem Ipsum Street <br/>
									CA, USA, 12335 <br/><br/>
									<i class="fas fa-envelope"></i>
									mail@spiraclethemes.com <br/><br/>
									<i class="fas fa-phone-alt"></i>
									123-456-7890 <br/><br/>
									<br/><br/>
									<a href="#" target="_blank"><i class="fab fa-facebook-f"></i></a> &nbsp; &nbsp;
									<a href="#" target="_blank"><i class="fab fa-twitter"></i></a> &nbsp; &nbsp;
									<a href="#" target="_blank"><i class="fab fa-instagram"></i></a> &nbsp; &nbsp;
									<a href="#" target="_blank"><i class="fab fa-google-plus-g"></i></a> &nbsp; &nbsp;
									<a href="#" target="_blank"><i class="fab fa-linkedin-in"></i></a> &nbsp; &nbsp;
						',
			        )
			    ),
			),
		),
		
		// Set up nav menus for each of the two areas registered in the theme.
		'nav_menus' => array(
			// Assign a menu to the "primary" location.
			'primary' => array(
				'name'  => esc_html__( 'Primary', 'krystal' ),
				'items' => array(
					'link_home', // Note that the core "home" page is actually a link in case a static front page is not used.
					'page_about',
					'page_blog',
					'page_contact',
				),
			),			
		),
	);

	/**
	 * Filters the array of starter content.
	 *
	 *
	 * @param array $starter_content Array of starter content.
	 */
	return apply_filters( 'krystal_starter_content', $starter_content );
}
