<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_sticky_header_settings_register' ) ) :
function krystal_customizer_sticky_header_settings_register( $wp_customize ) {
 	
	//Sticky Header Settings
    $wp_customize->add_section(
        'krystal_sticky_header_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Sticky Header Settings', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_sticky_header_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_sticky_header_settings', 
        array(
            'label'       => esc_html__( 'Sticky Header Settings', 'krystal' ),
            'section'     => 'krystal_sticky_header_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_sticky_header_settings',
        ) 
    ));

    //enable sticky menu
    $wp_customize->add_setting(
        'kr_sticky_menu',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_sticky_menu', 
        array(
            'settings'      => 'kr_sticky_menu',
            'section'       => 'krystal_sticky_header_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Sticky Header Feature:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to enable a sticky header feature for the site', 'krystal' ),            
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_sticky_header_logo', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_sticky_header_logo', 
        array(
            'label'       => esc_html__( 'Sticky Header Logo', 'krystal' ),
            'section'     => 'krystal_sticky_header_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_sticky_header_logo',
            'active_callback' => 'krystal_sticky_header_enable',
        ) 
    ));

    // Mobile logo
    $wp_customize->add_setting(
        'kr_alt_logo',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'krystal_sanitize_image'
        )
    );

    $wp_customize->add_control(
      new WP_Customize_Image_Control(
          $wp_customize,
          'kr_alt_logo',
          array(
              'settings'      => 'kr_alt_logo',
              'section'       => 'krystal_sticky_header_settings',
              'label'         => esc_html__( 'Logo for Sticky Header', 'krystal' ),
              'description'   => esc_html__( 'Upload logo for Sticky Header. Recommended height is 45px', 'krystal' ),
              'active_callback' => 'krystal_sticky_header_enable',
          )
      )
    );
    
}
endif;

add_action( 'customize_register', 'krystal_customizer_sticky_header_settings_register' );