<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_scrolldown_settings_register' ) ) :
function krystal_customizer_scrolldown_settings_register( $wp_customize ) {
 	
	// Scroll Down Settings //
    $wp_customize->add_section(
        'krystal_scrolldown_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Scroll Down Settings', 'krystal' )
        )
    );  

    // Info label
    $wp_customize->add_setting( 
        'kr_label_scroll_down_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_scroll_down_settings', 
        array(
            'label'       => esc_html__( 'Scroll Down Settings', 'krystal' ),
            'section'     => 'krystal_scrolldown_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_scroll_down_settings',
        ) 
    ));

    $wp_customize->add_setting(
        'kr_home_scroll_down',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_home_scroll_down', 
        array(
            'settings'      => 'kr_home_scroll_down',
            'section'       => 'krystal_scrolldown_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Home scroll Feature:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to enable a scroll down feature for the Home section', 'krystal' ),           
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_scroll_down_button_url', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_scroll_down_button_url', 
        array(
            'label'       => esc_html__( 'Scroll Down Button URL', 'krystal' ),
            'section'     => 'krystal_scrolldown_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_scroll_down_button_url',
            'active_callback'    => 'krystal_scroll_down_enable',
        ) 
    ));


    // Scroll Button url //
    $wp_customize->add_setting(
        'kr_scroll_button_url',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_url'
        )
    );

    $wp_customize->add_control(
        'kr_scroll_button_url',
        array(
            'settings'      => 'kr_scroll_button_url',
            'section'       => 'krystal_scrolldown_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Scroll Button URL', 'krystal' ),
            'description'   => esc_html__( 'Scroll Button URL for the home section', 'krystal' ),
            'active_callback'    => 'krystal_scroll_down_enable',
        )
    );

}
endif;

add_action( 'customize_register', 'krystal_customizer_scrolldown_settings_register' );