<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_preloader_settings_register' ) ) :
function krystal_customizer_preloader_settings_register( $wp_customize ) {

	// Preloader Settings
    $wp_customize->add_section(
        'krystal_preloader_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Preloader Settings', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_preloader_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_preloader_settings', 
        array(
            'label'       => esc_html__( 'Preloader Settings', 'krystal' ),
            'section'     => 'krystal_preloader_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_preloader_settings',
        ) 
    ));

    // Preloader Enable radio button 
    $wp_customize->add_setting(
        'kr_preloader_display',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_preloader_display', 
        array(
            'settings'      => 'kr_preloader_display',
            'section'       => 'krystal_preloader_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Preloader for site:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to show a preloader before a site opens', 'krystal' ),            
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_preloader_image_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_preloader_image_settings', 
        array(
            'label'       => esc_html__( 'Preloader Image Settings', 'krystal' ),
            'section'     => 'krystal_preloader_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_preloader_image_settings',
            'active_callback' => 'krystal_preloader_enable',
        ) 
    ));

    // Image for preloader 
    $wp_customize->add_setting(
        'kr_preloader_image',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'krystal_sanitize_image'
        )
    );

    $wp_customize->add_control(
      new WP_Customize_Image_Control(
          $wp_customize,
          'kr_preloader_image',
          array(
              'settings'      => 'kr_preloader_image',
              'section'       => 'krystal_preloader_settings',
              'label'         => esc_html__( 'Preloader Image', 'krystal' ),
              'description'   => esc_html__( 'Upload image for preloader', 'krystal' ),
              'active_callback' => 'krystal_preloader_enable',
          )
      )
    );  
	
}
endif;

add_action( 'customize_register', 'krystal_customizer_preloader_settings_register' );