<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_page_settings_register' ) ) :
function krystal_customizer_page_settings_register( $wp_customize ) {

	// Page settings
    $wp_customize->add_section(
        'krystal_page_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Page Settings', 'krystal' )
        )
    );

     // Info label
     $wp_customize->add_setting( 
        'kr_label_page_title_hide_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_title_hide_settings', 
        array(
            'label'       => esc_html__( 'Hide Page Title', 'krystal' ),
            'section'     => 'krystal_page_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_title_hide_settings',
        ) 
    ));

    // Hide page title section
    $wp_customize->add_setting(
        'kr_page_title_section_hide',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_page_title_section_hide', 
        array(
            'settings'      => 'kr_page_title_section_hide',
            'section'       => 'krystal_page_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Hide Page Title Section:', 'krystal' ),
            'description'   => '',           
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_page_breadcrumb_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_breadcrumb_settings', 
        array(
            'label'       => esc_html__( 'Breadcrumb Settings', 'krystal' ),
            'section'     => 'krystal_page_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_breadcrumb_settings',
            'active_callback' => 'krystal_page_title_disable',
        ) 
    ));

    // Add an option to enable the breadcrumbs
	$wp_customize->add_setting( 
		'krystal_enable_page_breadcrumbs', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'krystal_sanitize_checkbox_selection',
		) 
	);

	$wp_customize->add_control( 
		new Krystal_Toggle_Control( $wp_customize, 'krystal_enable_page_breadcrumbs', 
		array(
		    'label'       => esc_html__( 'Show Breadcrumbs', 'krystal' ),
		    'section'     => 'krystal_page_settings',
		    'type'        => 'toggle',
		    'settings'    => 'krystal_enable_page_breadcrumbs',
		    'active_callback' => 'krystal_page_title_disable',
		) 
	));


	// Choose the breadcrumb type
	$wp_customize->add_setting(
        'kr_page_breadcrumb_select_radio',
        array(
            'type' => 'theme_mod',
            'default'           => 'default',
            'sanitize_callback' => 'krystal_sanitize_radio_breadcrumb_selection'
        )
    );

    $wp_customize->add_control(
        'kr_page_breadcrumb_select_radio',
        array(
            'settings'      => 'kr_page_breadcrumb_select_radio',
            'section'       => 'krystal_page_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Choose Breadcrumb Type:', 'krystal' ),
            'choices' => array(
                            'default' => esc_html__('Default','krystal'),
                            'navxt' => esc_html__('NavXT','krystal'),
                            'yoast' => esc_html__('Yoast','krystal'),
                            ),
            'active_callback' => 'krystal_breadcrumb_enable',
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_page_title_bg_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_title_bg_settings', 
        array(
            'label'       => esc_html__( 'Page Title Background', 'krystal' ),
            'section'     => 'krystal_page_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_title_bg_settings',
            'active_callback' => 'krystal_page_title_disable',
        ) 
    ));

    // Background selection
    $wp_customize->add_setting(
        'kr_page_bg_radio',
        array(
            'type' => 'theme_mod',
            'default'           => 'color',
            'sanitize_callback' => 'krystal_sanitize_radio_pagebg_selection'
        )
    );

    $wp_customize->add_control(
        'kr_page_bg_radio',
        array(
            'settings'      => 'kr_page_bg_radio',
            'section'       => 'krystal_page_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Choose Page Title Background Color or Background Image:', 'krystal' ),
            'description'   => esc_html__('This setting will change the background of the page title area.', 'krystal'),
            'choices' => array(
                            'color' => esc_html__('Background Color','krystal'),
                            'image' => esc_html__('Background Image','krystal'),
                            ),
            'active_callback' => 'krystal_page_title_disable',
        )
    );

    // Background color
    $wp_customize->add_setting(
        'kr_page_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#1e73be',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'kr_page_bg_color',
            array(
                'label'      => esc_html__( 'Select Background Color', 'krystal' ),
                'description'   => esc_html__('This setting will add background color to the page title area if Background Color was selected above.', 'krystal'),
                'section'    => 'krystal_page_settings',
                'settings'   => 'kr_page_bg_color',
                'active_callback' => 'krystal_page_title_color_enable',
            )
        )
    );

    // Background Image
    $wp_customize->add_setting(
        'kr_page_bg_image',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'krystal_sanitize_image'
        )
    );

    $wp_customize->add_control(
      new WP_Customize_Image_Control(
          $wp_customize,
          'kr_page_bg_image',
          array(
              'settings'      => 'kr_page_bg_image',
              'section'       => 'krystal_page_settings',
              'label'         => esc_html__( 'Select Background Image for Page', 'krystal' ),
              'description'   => esc_html__('This setting will add background image to the page title area if Background Image was selected above.', 'krystal'),
              'active_callback' => 'krystal_page_title_image_enable',
          )
      )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_page_title_parallax_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_title_parallax_settings', 
        array(
            'label'       => esc_html__( 'Parallax Settings', 'krystal' ),
            'section'     => 'krystal_page_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_title_parallax_settings',
            'active_callback' => 'krystal_page_title_disable',
        ) 
    ));

    // Parallax Scroll for background image 
    $wp_customize->add_setting(
        'kr_page_bg_parallax',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_page_bg_parallax', 
        array(
            'settings'      => 'kr_page_bg_parallax',
            'section'       => 'krystal_page_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Parallax Scroll:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to show a parallax scroll feature for the Page Background image', 'krystal' ), 
            'active_callback' => 'krystal_page_title_disable',          
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_page_title_dark_overlay', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_title_dark_overlay', 
        array(
            'label'       => esc_html__( 'Dark Overlay Settings', 'krystal' ),
            'section'     => 'krystal_page_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_title_dark_overlay',
            'active_callback' => 'krystal_page_title_disable',
        ) 
    ));

    // Enable Dark Overlay
    $wp_customize->add_setting(
        'kr_page_dark_overlay',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_page_dark_overlay', 
        array(
            'settings'      => 'kr_page_dark_overlay',
            'section'       => 'krystal_page_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Dark Overlay:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to show a dark overlay over page header background', 'krystal' ), 
            'active_callback' => 'krystal_page_title_disable',          
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_page_title_spacing', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_title_spacing', 
        array(
            'label'       => esc_html__( 'Page Title Spacing', 'krystal' ),
            'section'     => 'krystal_page_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_title_spacing',
            'active_callback' => 'krystal_page_title_disable',
        ) 
    ));

    // page title height from top //
    $wp_customize->add_setting(
        'kr_pagetitle_hft',
        array(
            'type' => 'theme_mod',
            'default'           => '125',
            'sanitize_callback' => 'absint'
        )
    );

    $wp_customize->add_control(
        'kr_pagetitle_hft',
        array(
            'settings'      => 'kr_pagetitle_hft',
            'section'       => 'krystal_page_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Page Title Height from Top(px)', 'krystal' ),
            'description'   => esc_html__( 'This will add top padding to the page title. Do not write px or em', 'krystal' ),
            'active_callback' => 'krystal_page_title_disable',
        )
    );

    // page title height from bottom //
    $wp_customize->add_setting(
        'kr_pagetitle_hfb',
        array(
            'type' => 'theme_mod',
            'default'           => '125',
            'sanitize_callback' => 'absint'
        )
    );

    $wp_customize->add_control(
        'kr_pagetitle_hfb',
        array(
            'settings'      => 'kr_pagetitle_hfb',
            'section'       => 'krystal_page_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Page Title Height from Bottom(px)', 'krystal' ),
            'description'   => esc_html__( 'This will add bottom padding to the page title. Do not write px or em', 'krystal' ),
            'active_callback' => 'krystal_page_title_disable',
        )
    );

}
endif;

add_action( 'customize_register', 'krystal_customizer_page_settings_register' );