<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_minify_settings_register' ) ) :
function krystal_customizer_minify_settings_register( $wp_customize ) {
 	
	// Minify Settings
    $wp_customize->add_section(
        'krystal_minify_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Minify Styles & Scripts', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_minify_styles_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_minify_styles_settings', 
        array(
            'label'       => esc_html__( 'Minify CSS Styles Settings', 'krystal' ),
            'section'     => 'krystal_minify_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_minify_styles_settings',
        ) 
    ));

    // Enable minify styles 
    $wp_customize->add_setting(
        'kr_enable_minify_styles',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_enable_minify_styles', 
        array(
            'settings'      => 'kr_enable_minify_styles',
            'section'       => 'krystal_minify_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Minify all CSS styles:', 'krystal' ),
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_minify_scripts_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_minify_scripts_settings', 
        array(
            'label'       => esc_html__( 'Minify JS Scripts Settings', 'krystal' ),
            'section'     => 'krystal_minify_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_minify_scripts_settings',
        ) 
    ));

    // Enable minify scripts 
    $wp_customize->add_setting(
        'kr_enable_minify_scripts',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_enable_minify_scripts', 
        array(
            'settings'      => 'kr_enable_minify_scripts',
            'section'       => 'krystal_minify_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Minify all JS scripts:', 'krystal' ),
        )
    ));

}
endif;

add_action( 'customize_register', 'krystal_customizer_minify_settings_register' );