<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_header_styles_settings_register' ) ) :
function krystal_customizer_header_styles_settings_register( $wp_customize ) {
 	
 	//Header Styles
    $wp_customize->add_section(
        'kr_header_styles_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Header Styles', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_header_styles', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_header_styles', 
        array(
            'label'       => esc_html__( 'Header Styles', 'krystal' ),
            'section'     => 'kr_header_styles_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_header_styles',
        ) 
    ));
    
    $wp_customize->add_setting(
        'kr_header_styles',
        array(
            'type' => 'theme_mod',
            'default'           => 'style1',
            'sanitize_callback' => 'krystal_sanitize_header_style_radio_selection'
        )
    );

    $wp_customize->add_control(
        'kr_header_styles',
        array(
            'settings'      => 'kr_header_styles',
            'section'       => 'kr_header_styles_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Choose Header Style:', 'krystal' ),
            'description'   => '',
            'choices' => array(
                            'style1' => esc_html__('Header Style1 - This will show full background image as header with menu over the image', 'krystal'),
                            'style2' => esc_html__('Header Style2 - This header style will show background image below menu', 'krystal'),
                            ),
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_header_styles_menu_color_info', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Info_Control( $wp_customize, 'kr_header_styles_menu_color_info', 
        array(
            'label'       => esc_html__( 'Note: Go to Color Settings to change the the menu color (Top Menu Color). ', 'krystal' ),
            'section'     => 'kr_header_styles_settings',
            'type'        => 'info',
            'settings'    => 'kr_header_styles_menu_color_info',
            'active_callback' => '',
        ) 
    ));

}
endif;

add_action( 'customize_register', 'krystal_customizer_header_styles_settings_register' );