<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_general_settings_register' ) ) :
function krystal_customizer_general_settings_register( $wp_customize ) {
 
 	// General Settings
    $wp_customize->add_section(
        'krystal_general_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'General Settings', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_background_section', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_background_section', 
        array(
            'label'       => esc_html__( 'Choose whether to disable the home background section or not', 'krystal' ),
            'section'     => 'krystal_general_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_background_section',
        ) 
    ));

    // Enable/disable section
    $wp_customize->add_setting(
        'kr_home_disable_section',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_home_disable_section', 
        array(
            'settings'      => 'kr_home_disable_section',
            'section'       => 'krystal_general_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Disable Home Background Image Section:', 'krystal' ),
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_background_selection_section', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_background_selection_section', 
        array(
            'label'       => esc_html__( 'Home Background Selection', 'krystal' ),
            'section'     => 'krystal_general_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_background_selection_section',
            'active_callback'    => 'krystal_home_bg_enable',
        ) 
    ));

    // Background selection
    $wp_customize->add_setting(
        'kr_home_bg_radio',
        array(
            'type' => 'theme_mod',
            'default'           => 'image',
            'sanitize_callback' => 'krystal_sanitize_radio_pagebg_selection'
        )
    );

    $wp_customize->add_control(
        'kr_home_bg_radio',
        array(
            'settings'      => 'kr_home_bg_radio',
            'section'       => 'krystal_general_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Choose Home Background Color or Background Image:', 'krystal' ),
            'description'   => esc_html__('This setting will change the Home background area.', 'krystal'),
            'choices' => array(
                            'color' => esc_html__('Background Color','krystal'),
                            'image' => esc_html__('Background Image','krystal'),
                            ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );

    // Background color
    $wp_customize->add_setting(
        'kr_home_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#1e73be',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_home_bg_color',
        array(
        'label'      => esc_html__( 'Select Background Color', 'krystal' ),
        'description'   => esc_html__('This setting will add background color if Background Color was selected above.', 'krystal'),
        'section'    => 'krystal_general_settings',
        'settings'   => 'kr_home_bg_color',
        'active_callback'  => 'krystal_home_bg_color_enable',

        ) )
    );

    // Home Background Image 
    $wp_customize->add_setting(
        'kr_theme_home_bg',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'krystal_sanitize_image'
        )
    );

    $wp_customize->add_control(
      new WP_Customize_Image_Control(
          $wp_customize,
          'kr_theme_home_bg',
          array(
              'settings'      => 'kr_theme_home_bg',
              'section'       => 'krystal_general_settings',
              'label'         => esc_html__( 'Home Background Image', 'krystal' ),
              'description'   => esc_html__( 'This setting will add background image if Background Image was selected above.', 'krystal' ),
              'active_callback'  => 'krystal_home_bg_image_enable',
          )
      )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_background_content_section', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_background_content_section', 
        array(
            'label'       => esc_html__( 'Home Background Content', 'krystal' ),
            'section'     => 'krystal_general_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_background_content_section',
            'active_callback'    => 'krystal_home_bg_enable',
        ) 
    ));

    // Home Section Heading text 
    $wp_customize->add_setting(
        'kr_home_heading_text',
        array(            
            'default'           => esc_html__('ENTER YOUR HEADING HERE','krystal'),
            'sanitize_callback' => 'krystal_sanitize_textarea',
            'transport' => 'postMessage',
        )
    );

    $wp_customize->add_control(
        'kr_home_heading_text',
        array(
            'settings'      => 'kr_home_heading_text',
            'section'       => 'krystal_general_settings',
            'type'          => 'textarea',
            'label'         => esc_html__( 'Heading Text', 'krystal' ),
            'description'   => esc_html__( 'heading for the home section', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'kr_home_heading_text', array(
        'selector'            => '.slide-bg-section h1',   
        'settings'            => 'kr_home_heading_text',     
        'render_callback'     => 'krystal_home_heading_text_render_callback',
        'fallback_refresh'    => false, 
    ));

    // Home Section SubHeading text
    $wp_customize->add_setting(
        'kr_home_subheading_text',
        array(            
            'default'           => esc_html__('ENTER YOUR SUBHEADING HERE','krystal'),
            'sanitize_callback' => 'krystal_sanitize_textarea',
            'transport' => 'postMessage',
        )
    );

    $wp_customize->add_control(
        'kr_home_subheading_text',
        array(
            'settings'      => 'kr_home_subheading_text',
            'section'       => 'krystal_general_settings',
            'type'          => 'textarea',
            'label'         => esc_html__( 'SubHeading Text', 'krystal' ),
            'description'   => esc_html__( 'Subheading for the home section', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'kr_home_subheading_text', array(
        'selector'            => '.slide-bg-section p',   
        'settings'            => 'kr_home_subheading_text',     
        'render_callback'     => 'krystal_home_subheading_text_render_callback',
        'fallback_refresh'    => false, 
    ));

    // Home Section Button text 
    $wp_customize->add_setting(
        'kr_home_button_text',
        array( 
            'type' => 'theme_mod',           
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_html',
            
        )
    );

    $wp_customize->add_control(
        'kr_home_button_text',
        array(
            'settings'      => 'kr_home_button_text',
            'section'       => 'krystal_general_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Button Text', 'krystal' ),
            'description'   => esc_html__( 'Button text for the home section', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );  


    // Home Section Button url 
    $wp_customize->add_setting(
        'kr_home_button_url',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_url'
        )
    );

    $wp_customize->add_control(
        'kr_home_button_url',
        array(
            'settings'      => 'kr_home_button_url',
            'section'       => 'krystal_general_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Button URL', 'krystal' ),
            'description'   => esc_html__( 'Button URL for the home section, you can paste youtube or vimeo video url also', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );


    // Home Section Button2 text
    $wp_customize->add_setting(
        'kr_home_button2_text',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_html'
        )
    );

    $wp_customize->add_control(
        'kr_home_button2_text',
        array(
            'settings'      => 'kr_home_button2_text',
            'section'       => 'krystal_general_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Button 2 Text', 'krystal' ),
            'description'   => esc_html__( 'Button 2 text for the home section', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );


    // Home Section Button2 url 
    $wp_customize->add_setting(
        'kr_home_button2_url',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_url'
        )
    );

    $wp_customize->add_control(
        'kr_home_button2_url',
        array(
            'settings'      => 'kr_home_button2_url',
            'section'       => 'krystal_general_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Button 2 URL', 'krystal' ),
            'description'   => esc_html__( 'Button 2 URL for the home section, you can paste youtube or vimeo video url also', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );

    // text position
    $wp_customize->add_setting(
        'kr_home_text_position',
        array(
            'type' => 'theme_mod',
            'default'           => 'center',
            'sanitize_callback' => 'krystal_sanitize_home_text_position_radio_selection'
        )
    );

    $wp_customize->add_control(
        'kr_home_text_position',
        array(
            'settings'      => 'kr_home_text_position',
            'section'       => 'krystal_general_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Select Text Position:', 'krystal' ),
            'description'   => '',
            'choices' => array(
                            'left' =>esc_html__( 'Left', 'krystal' ),
                            'center' =>esc_html__( 'Center', 'krystal' ),
                            'right' => esc_html__( 'Right', 'krystal' ),                            
                            ),
            'active_callback'    => 'krystal_home_bg_enable',
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_background_parallax_scroll', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_background_parallax_scroll', 
        array(
            'label'       => esc_html__( 'Parallax Scroll', 'krystal' ),
            'section'     => 'krystal_general_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_background_parallax_scroll',
            'active_callback'    => 'krystal_home_bg_enable',
        ) 
    ));

    // Parallax Scroll for background image 
    $wp_customize->add_setting(
        'kr_home_parallax',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_home_parallax', 
        array(
            'settings'      => 'kr_home_parallax',
            'section'       => 'krystal_general_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Parallax Scroll:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to show a parallax scroll feature for the Home Background image', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',         
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_background_dark_overlay', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_background_dark_overlay', 
        array(
            'label'       => esc_html__( 'Dark Overlay', 'krystal' ),
            'section'     => 'krystal_general_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_background_dark_overlay',
            'active_callback'    => 'krystal_home_bg_enable',
        ) 
    ));

    // Enable Dark Overlay
    $wp_customize->add_setting(
        'kr_home_dark_overlay',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_home_dark_overlay', 
        array(
            'settings'      => 'kr_home_dark_overlay',
            'section'       => 'krystal_general_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Dark Overlay:', 'krystal' ),
            'description'   => esc_html__( 'Choose whether to show a dark overlay over background image', 'krystal' ),
            'active_callback'    => 'krystal_home_bg_enable',           
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_background_blog_hp', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_background_blog_hp', 
        array(
            'label'       => esc_html__( 'Blog Homepage', 'krystal' ),
            'section'     => 'krystal_general_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_background_blog_hp',
        ) 
    ));

    // Blog Homepage
    $wp_customize->add_setting(
        'kr_blog_homepage',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_blog_homepage', 
        array(
            'settings'      => 'kr_blog_homepage',
            'section'       => 'krystal_general_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Use this for Blog Homepage:', 'krystal' ),
            'description'   => esc_html__( 'Check this if you are having a Blog as front page', 'krystal' ),           
        )
    ));

}
endif;

add_action( 'customize_register', 'krystal_customizer_general_settings_register' );