<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_form_settings_register' ) ) :
function krystal_customizer_form_settings_register( $wp_customize ) {
 
 	//Form Settings
    $wp_customize->add_section(
        'krystal_form_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Form Settings', 'krystal' )
        )
    ); 

    // Info label
    $wp_customize->add_setting( 
        'kr_label_form_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_form_settings', 
        array(
            'label'       => esc_html__( 'Form Settings', 'krystal' ),
            'section'     => 'krystal_form_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_form_settings',
        ) 
    ));

    // Form Elements Style
    $wp_customize->add_setting(
        'kr_form_elem_settings_style',
        array(
            'type' => 'theme_mod',
            'default'           => 'default',
            'sanitize_callback' => 'krystal_sanitize_form_elem_radio_selection'
        )
    );

    $wp_customize->add_control(
        'kr_form_elem_settings_style',
        array(
            'settings'      => 'kr_form_elem_settings_style',
            'section'       => 'krystal_form_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Select Form Elements Style:', 'krystal' ),
            'description'   => '',
            'choices' => array(
                            'default' => esc_html__( 'Default Style', 'krystal' ),
                            'bg' =>esc_html__( 'Solid Background Style', 'krystal' ),
                            ),
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_form_elem_bg_color_info', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Info_Control( $wp_customize, 'kr_form_elem_bg_color_info', 
        array(
            'label'       => esc_html__( 'Note: Go to Color Settings to change the the Form color. ', 'krystal' ),
            'section'     => 'krystal_form_settings',
            'type'        => 'info',
            'settings'    => 'kr_form_elem_bg_color_info',
            'active_callback' => '',
        ) 
    ));

    // Info label
    $wp_customize->add_setting( 
        'kr_label_form_full_width_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_form_full_width_settings', 
        array(
            'label'       => esc_html__( 'Full Width Form', 'krystal' ),
            'section'     => 'krystal_form_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_form_full_width_settings',
        ) 
    ));

    // Form width
    $wp_customize->add_setting(
        'kr_form_width_setting',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_form_width_setting', 
        array(
            'settings'      => 'kr_form_width_setting',
            'section'       => 'krystal_form_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Full Width Form', 'krystal' ),
            'description'   => '',           
        )
    ));
 
}
endif;

add_action( 'customize_register', 'krystal_customizer_form_settings_register' );