<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_footer_settings_register' ) ) :
function krystal_customizer_footer_settings_register( $wp_customize ) {
 	
	//Footer Settings
    $wp_customize->add_section(
        'krystal_footer_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Footer Settings', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_footer_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_footer_settings', 
        array(
            'label'       => esc_html__( 'Footer Settings', 'krystal' ),
            'section'     => 'krystal_footer_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_footer_settings',
        ) 
    ));

    // Copyright text
    $wp_customize->add_setting(
        'kr_copyright_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__('Copyrights krystal. All Rights Reserved','krystal'),
            'sanitize_callback' => 'krystal_sanitize_textarea'
        )
    );

    $wp_customize->add_control(
        'kr_copyright_text',
        array(
            'settings'      => 'kr_copyright_text',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textarea',
            'label'         => esc_html__( 'Footer copyright text', 'krystal' ),
            'description'   => esc_html__( 'Copyright text to be displayed in the footer. No HTML allowed', 'krystal' )
        )
    );


     // Info label
    $wp_customize->add_setting( 
        'kr_label_footer_add_links_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_footer_add_links_settings', 
        array(
            'label'       => esc_html__( 'Footer Copyright Links Settings', 'krystal' ),
            'section'     => 'krystal_footer_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_footer_add_links_settings',
        ) 
    ));

    // Form width
    $wp_customize->add_setting(
        'kr_footer_enable_footer_links',
        array(
            'type' => 'theme_mod',
            'default'           => false,
            'sanitize_callback' => 'krystal_sanitize_checkbox_selection'
        )
    );

    $wp_customize->add_control(
        new Krystal_Toggle_Control( $wp_customize, 'kr_footer_enable_footer_links', 
        array(
            'settings'      => 'kr_footer_enable_footer_links',
            'section'       => 'krystal_footer_settings',
            'type'          => 'toggle',
            'label'         => esc_html__( 'Enable Footer Links', 'krystal' ),
            'description'   => '',           
        )
    ));

    // Link 1 Text
    $wp_customize->add_setting(
        'kr_footer_link_1_text',
        array( 
            'type' => 'theme_mod',           
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_html',
            
        )
    );

    $wp_customize->add_control(
        'kr_footer_link_1_text',
        array(
            'settings'      => 'kr_footer_link_1_text',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textbox',
            'description'   => esc_html__( 'Link 1 Text', 'krystal' ),
            'active_callback'    => 'krystal_footer_copyrights_links_enable',
        )
    );  

    // Link 1 URL
    $wp_customize->add_setting(
        'kr_footer_link_1_url',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_url'
        )
    );

    $wp_customize->add_control(
        'kr_footer_link_1_url',
        array(
            'settings'      => 'kr_footer_link_1_url',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textbox',
            'description'   => esc_html__( 'Link 1 URL', 'krystal' ),
            'active_callback'    => 'krystal_footer_copyrights_links_enable',
        )
    );

    // Link 2 Text
    $wp_customize->add_setting(
        'kr_footer_link_2_text',
        array( 
            'type' => 'theme_mod',           
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_html',
            
        )
    );

    $wp_customize->add_control(
        'kr_footer_link_2_text',
        array(
            'settings'      => 'kr_footer_link_2_text',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textbox',
            'description'   => esc_html__( 'Link 2 Text', 'krystal' ),
            'active_callback'    => 'krystal_footer_copyrights_links_enable',
        )
    );  

    // Link 2 URL
    $wp_customize->add_setting(
        'kr_footer_link_2_url',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_url'
        )
    );

    $wp_customize->add_control(
        'kr_footer_link_2_url',
        array(
            'settings'      => 'kr_footer_link_2_url',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textbox',
            'description'   => esc_html__( 'Link 2 URL', 'krystal' ),
            'active_callback'    => 'krystal_footer_copyrights_links_enable',
        )
    );

    // Link 3 Text
    $wp_customize->add_setting(
        'kr_footer_link_3_text',
        array( 
            'type' => 'theme_mod',           
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_html',
            
        )
    );

    $wp_customize->add_control(
        'kr_footer_link_3_text',
        array(
            'settings'      => 'kr_footer_link_3_text',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textbox',
            'description'   => esc_html__( 'Link 3 Text', 'krystal' ),
            'active_callback'    => 'krystal_footer_copyrights_links_enable',
        )
    );  

    // Link 3 URL
    $wp_customize->add_setting(
        'kr_footer_link_3_url',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'krystal_sanitize_url'
        )
    );

    $wp_customize->add_control(
        'kr_footer_link_3_url',
        array(
            'settings'      => 'kr_footer_link_3_url',
            'section'       => 'krystal_footer_settings',
            'type'          => 'textbox',
            'description'   => esc_html__( 'Link 3 URL', 'krystal' ),
            'active_callback'    => 'krystal_footer_copyrights_links_enable',
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_footer_widgets_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_footer_widgets_settings', 
        array(
            'label'       => esc_html__( 'Footer Widgets', 'krystal' ),
            'section'     => 'krystal_footer_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_footer_widgets_settings',
        ) 
    ));

    // Footer widgets
    $wp_customize->add_setting(
        'kr_footer_widgets',
        array(
            'type' => 'theme_mod',
            'default'           => '4',
            'sanitize_callback' => 'krystal_sanitize_footer_widgets_radio_selection'
        )
    );

    $wp_customize->add_control(
        'kr_footer_widgets',
        array(
            'settings'      => 'kr_footer_widgets',
            'section'       => 'krystal_footer_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Number of Footer Widgets:', 'krystal' ),
            'description'   => '',
            'choices' => array(
                            '1' => esc_html__( '1', 'krystal' ),
                            '2' =>esc_html__( '2', 'krystal' ),
                            '3' => esc_html__( '3', 'krystal' ),
                            '4' =>esc_html__( '4', 'krystal' ),
                            ),
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_footer_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_footer_color_settings', 
        array(
            'label'       => esc_html__( 'Footer Color Settings', 'krystal' ),
            'section'     => 'krystal_footer_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_footer_color_settings',
        ) 
    ));   

    // Footer background color
    $wp_customize->add_setting(
        'kr_footer_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_footer_bg_color',
        array(
        'label'      => esc_html__( 'Footer Background Color', 'krystal' ),
        'section'    => 'krystal_footer_settings',
        'settings'   => 'kr_footer_bg_color',
        ) )
    );    
   

    // Footer Content Color
    $wp_customize->add_setting(
        'kr_footer_content_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#ffffff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_footer_content_color',
        array(
        'label'      => esc_html__( 'Footer Content Color', 'krystal' ),
        'section'    => 'krystal_footer_settings',
        'settings'   => 'kr_footer_content_color',
        ) )
    );  

    // Footer links Color
    $wp_customize->add_setting(
        'kr_footer_links_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#b3b3b3',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_footer_links_color',
        array(
        'label'      => esc_html__( 'Footer Links Color', 'krystal' ),
        'section'    => 'krystal_footer_settings',
        'settings'   => 'kr_footer_links_color',
        ) )
    );	

}
endif;

add_action( 'customize_register', 'krystal_customizer_footer_settings_register' );