<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_color_settings_register' ) ) :
function krystal_customizer_color_settings_register( $wp_customize ) {
 	
 	// Color Settings 
    $wp_customize->add_section(
        'krystal_color_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Color Settings', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_color_settings', 
        array(
            'label'       => esc_html__( 'Color Settings', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_color_settings',
        ) 
    ));        

    
    // Link Color
    $wp_customize->add_setting(
        'kr_link_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#444444',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_link_color',
        array(
        'label'      => esc_html__( 'Links Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_link_color',
        ) )
    );

    // Link Hover Color
    $wp_customize->add_setting(
        'kr_link_hover_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_link_hover_color',
        array(
        'label'      => esc_html__( 'Links Hover Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_link_hover_color',
        ) )
    );

    // Heading Color
    $wp_customize->add_setting(
        'kr_heading_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#444444',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_heading_color',
        array(
        'label'      => esc_html__( 'Headings Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_heading_color',
        ) )
    );

    // Heading Hover Color
    $wp_customize->add_setting(
        'kr_heading_hover_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_heading_hover_color',
        array(
        'label'      => esc_html__( 'Heading Hover Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_heading_hover_color',
        ) )
    );


    // Buttons Color
    $wp_customize->add_setting(
        'kr_button_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#444444',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_button_color',
        array(
        'label'      => esc_html__( 'Buttons Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_button_color',
        ) )
    );

    // Buttons Hover Color
    $wp_customize->add_setting(
        'kr_button_hover_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_button_hover_color',
        array(
        'label'      => esc_html__( 'Buttons Hover Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_button_hover_color',
        ) )
    );    


    // Transparent Buttons Hover Color
    $wp_customize->add_setting(
        'kr_trans_button_hover_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_trans_button_hover_color',
        array(
        'label'      => esc_html__( 'Transparent Buttons Hover Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_trans_button_hover_color',
        ) )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_menu_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_menu_color_settings', 
        array(
            'label'       => esc_html__( 'Top Menu', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_menu_color_settings',
        ) 
    )); 

    // Top menu color
    $wp_customize->add_setting(
        'kr_top_menu_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#ffffff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_top_menu_color',
        array(
        'label'      => esc_html__( 'Top Menu Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_top_menu_color',
        ) )
    );

    // Top menu button background color
    $wp_customize->add_setting(
        'kr_top_menu_button_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#5b9dd9',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_top_menu_button_color',
        array(
        'label'      => esc_html__( 'Top Menu Button Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_top_menu_button_color',
        ) )
    );

    // Top menu button text color
    $wp_customize->add_setting(
        'kr_top_menu_button_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#fff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_top_menu_button_text_color',
        array(
        'label'      => esc_html__( 'Top Menu Button Text Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_top_menu_button_text_color',
        ) )
    );

    // Menu dropdown color
    $wp_customize->add_setting(
        'kr_top_menu_dd_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#dd3333',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_top_menu_dd_color',
        array(
        'label'      => esc_html__( 'Menu Dropdown Background Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_top_menu_dd_color',
        ) )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_home_bg_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_home_bg_color_settings', 
        array(
            'label'       => esc_html__( 'Home Background Section', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_home_bg_color_settings',
        ) 
    )); 

    // Home Background Image text color
    $wp_customize->add_setting(
        'kr_home_bg_image_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#ffffff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_home_bg_image_text_color',
        array(
        'label'      => esc_html__( 'Home Background Image Text Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_home_bg_image_text_color',
        ) )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_page_bg_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_page_bg_color_settings', 
        array(
            'label'       => esc_html__( 'Page Background Section', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_page_bg_color_settings',
        ) 
    )); 

    // Page Background Image text color
    $wp_customize->add_setting(
        'kr_page_bg_image_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#ffffff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_page_bg_image_text_color',
        array(
        'label'      => esc_html__( 'Page Background Image Text Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_page_bg_image_text_color',
        ) )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_cf_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_cf_color_settings', 
        array(
            'label'       => esc_html__( 'Contact Form', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_cf_color_settings',
        ) 
    )); 

    // Contact form label color
    $wp_customize->add_setting(
        'kr_cf_label_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#555555',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_cf_label_color',
        array(
        'label'      => esc_html__( 'Contact Form Label Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_cf_label_color',
        ) )
    );

    // Contact form text color
    $wp_customize->add_setting(
        'kr_cf_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#555555',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_cf_text_color',
        array(
        'label'      => esc_html__( 'Contact Form Text Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_cf_text_color',
        ) )
    );

    // Contact form elements bg color
    $wp_customize->add_setting(
        'kr_cf_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#555',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_cf_bg_color',
        array(
        'label'      => esc_html__( 'Contact Form Elements Background Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_cf_bg_color',
        ) )
    );

    // Contact form elements border color
    $wp_customize->add_setting(
        'kr_cf_border_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#fff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_cf_border_color',
        array(
        'label'      => esc_html__( 'Contact Form Border Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_cf_border_color',
        ) )
    );

    // Contact form button color
    $wp_customize->add_setting(
        'kr_cf_button_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#555555',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_cf_button_color',
        array(
        'label'      => esc_html__( 'Contact Form Button Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_cf_button_color',
        ) )
    );

    // Contact form button hover color
    $wp_customize->add_setting(
        'kr_cf_button_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#555555',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_cf_button_bg_color',
        array(
        'label'      => esc_html__( 'Contact Form Button Hover Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_cf_button_bg_color',
        ) )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_sticky_header_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_sticky_header_color_settings', 
        array(
            'label'       => esc_html__( 'Sticky Header', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_sticky_header_color_settings',
        ) 
    )); 

    // Top menu button background color
    $wp_customize->add_setting(
        'kr_sticky_top_menu_button_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#5b9dd9',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_sticky_top_menu_button_color',
        array(
        'label'      => esc_html__( 'Top Menu Button Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_sticky_top_menu_button_color',
        ) )
    );

    // Top menu button text color
    $wp_customize->add_setting(
        'kr_sticky_top_menu_button_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#fff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_sticky_top_menu_button_text_color',
        array(
        'label'      => esc_html__( 'Top Menu Button Text Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_sticky_top_menu_button_text_color',
        ) )
    );


    // Info label
    $wp_customize->add_setting( 
        'kr_label_mobile_menu_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_mobile_menu_color_settings', 
        array(
            'label'       => esc_html__( 'Mobile Menu', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_mobile_menu_color_settings',
        ) 
    )); 

    // Top menu button background color
    $wp_customize->add_setting(
        'kr_mobile_menu_top_menu_button_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#5b9dd9',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_mobile_menu_top_menu_button_color',
        array(
        'label'      => esc_html__( 'Top Menu Button Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_mobile_menu_top_menu_button_color',
        ) )
    );

    // Top menu button text color
    $wp_customize->add_setting(
        'kr_mobile_menu_top_menu_button_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#fff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_mobile_menu_top_menu_button_text_color',
        array(
        'label'      => esc_html__( 'Top Menu Button Text Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_mobile_menu_top_menu_button_text_color',
        ) )
    );


     // Info label
     $wp_customize->add_setting( 
        'kr_label_breadcrumb_color_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_breadcrumb_color_settings', 
        array(
            'label'       => esc_html__( 'Breadcrumbs', 'krystal' ),
            'section'     => 'krystal_color_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_breadcrumb_color_settings',
        ) 
    )); 

    // Breadcrumb color
    $wp_customize->add_setting(
        'kr_breadcrumb_text_color',
        array(
            'type' => 'theme_mod',
            'default'           => '#fff',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
        $wp_customize,
        'kr_breadcrumb_text_color',
        array(
        'label'      => esc_html__( 'Breadcrumb Color', 'krystal' ),
        'section'    => 'krystal_color_settings',
        'settings'   => 'kr_breadcrumb_text_color',
        ) )
    );
 	
}
endif;

add_action( 'customize_register', 'krystal_customizer_color_settings_register' );