<?php
/**
 * Theme Customizer Controls
 *
 * @package krystal
 */


if ( ! function_exists( 'krystal_customizer_blog_settings_register' ) ) :
function krystal_customizer_blog_settings_register( $wp_customize ) {
 	
 	//Blog Settings
    $wp_customize->add_section(
        'krystal_blog_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'theme_supports'=> '',
            'title'         => esc_html__( 'Blog Settings', 'krystal' )
        )
    );

    // Info label
    $wp_customize->add_setting( 
        'kr_label_blog_settings', 
        array(
            'sanitize_callback' => 'krystal_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Title_Info_Control( $wp_customize, 'kr_label_blog_settings', 
        array(
            'label'       => esc_html__( 'Blog Settings', 'krystal' ),
            'section'     => 'krystal_blog_settings',
            'type'        => 'title',
            'settings'    => 'kr_label_blog_settings',
        ) 
    ));   

    // Blog Sidebar
    $wp_customize->add_setting(
        'kr_blog_sidebar',
        array(
            'type' => 'theme_mod',
            'default'           => 'right',
            'sanitize_callback' => 'krystal_sanitize_blog_sidebar_radio_selection'
        )
    );

    $wp_customize->add_control(
        'kr_blog_sidebar',
        array(
            'settings'      => 'kr_blog_sidebar',
            'section'       => 'krystal_blog_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Select sidebar position:', 'krystal' ),
            'description'   => '',
            'choices' => array(
                            'right' => esc_html__( 'Right', 'krystal' ),
                            'left' =>esc_html__( 'Left', 'krystal' ),
                            ),
        )
    );


}
endif;

add_action( 'customize_register', 'krystal_customizer_blog_settings_register' );