<?php
/**
 * Krystal Theme Customizer
 *
 * @package krystal
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

if ( ! function_exists( 'krystal_customize_register' ) ) :
function krystal_customize_register( $wp_customize ) {

    require( get_template_directory() . '/inc/customizer/custom-controls/control-custom-content.php' ); 
    // Add custom controls.
    require get_parent_theme_file_path( 'inc/customizer/custom-controls/info/class-info-control.php' );
    require get_parent_theme_file_path( 'inc/customizer/custom-controls/info/class-title-info-control.php' );
    require get_parent_theme_file_path( 'inc/customizer/custom-controls/toggle-button/class-login-designer-toggle-control.php' );
    require get_parent_theme_file_path( 'inc/customizer/custom-controls/radio-images/class-radio-image-control.php' );

    // Register the custom control type.
    $wp_customize->register_control_type( 'Krystal_Toggle_Control' ); 


    // Display Site Title and Tagline
    $wp_customize->add_setting( 
        'kr_display_site_title_tagline', 
        array(
            'default'           => true,
            'type'              => 'theme_mod',
            'sanitize_callback' => 'krystal_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control( 
        new Krystal_Toggle_Control( $wp_customize, 'kr_display_site_title_tagline', 
        array(
            'label'       => esc_html__( 'Display Site Title and Tagline', 'krystal' ),
            'section'     => 'title_tagline',
            'type'        => 'toggle',
            'settings'    => 'kr_display_site_title_tagline',
        ) 
    ));      
   
}
endif;

add_action( 'customize_register', 'krystal_customize_register' );



//general settings
get_template_part( 'inc/customizer/options/section-general' );

//header settings
get_template_part( 'inc/customizer/options/section-header' );

//sticky header settings
get_template_part( 'inc/customizer/options/section-sticky-header' );

//scroll down settings
get_template_part( 'inc/customizer/options/section-scrolldown' );

//page settings
get_template_part( 'inc/customizer/options/section-page' );

//color settings
get_template_part( 'inc/customizer/options/section-color' );

//blog settings
get_template_part( 'inc/customizer/options/section-blog' );

//form settings
get_template_part( 'inc/customizer/options/section-form' );

//footer settings
get_template_part( 'inc/customizer/options/section-footer' );

//minify settings
get_template_part( 'inc/customizer/options/section-minify' );

//preloader settings
get_template_part( 'inc/customizer/options/section-preloader' );

//customizer helper
get_template_part( 'inc/customizer/customizer-helpers' );

//data sanitization
get_template_part( 'inc/customizer/data-sanitization' );


/**
 * Enqueue the customizer stylesheet.
 */
if ( ! function_exists( 'krystal_enqueue_customizer_stylesheets' ) ) :
function krystal_enqueue_customizer_stylesheets() {
    wp_register_style( 'krystal-customizer', get_template_directory_uri() . '/inc/customizer/assets/customizer.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'krystal-customizer' );
}
endif;

add_action( 'customize_controls_print_styles', 'krystal_enqueue_customizer_stylesheets' );
