<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 * 
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package krystal
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php 
        if (function_exists('wp_body_open')) :
            wp_body_open();
        else :
            do_action('wp_body_open');
        endif;
    ?>

    <?php if ( true === get_theme_mod( 'kr_preloader_display', true ) ) : ?>
        <!-- Begin Preloader -->
        <div class="loader-wrapper">
            <div id="pre-loader"></div>
        </div>
        <!-- End Preloader -->
    <?php endif; ?>

    <!-- Header Styles -->
    <?php
        /**
         * Hook - krystal_action_header.
         *
         * @hooked krystal_header_style_1 - 10
         * @hooked krystal_header_style_2 - 10
         */
        do_action( 'krystal_action_header' );
    ?>
    
    <?php if ( is_front_page() ) : 
        $slide_option = esc_html(get_theme_mod( 'kr_slide_option1_radio' ));
        $home_bg_radio = esc_html(get_theme_mod( 'kr_home_bg_radio', 'image' ));
        $header_style = esc_attr(get_theme_mod( 'kr_header_styles', 'style1' ));
        $home_heading_text = esc_html(get_theme_mod( 'kr_home_heading_text' ));
        $home_subheading_text = esc_html(get_theme_mod( 'kr_home_subheading_text', get_bloginfo( 'description', 'display' ) ));
        $button_text = esc_html(get_theme_mod( 'kr_home_button_text' ));
        $button_url = esc_url(get_theme_mod( 'kr_home_button_url' ));
        $button2_text = esc_html(get_theme_mod( 'kr_home_button2_text' ));
        $button2_url = esc_url(get_theme_mod( 'kr_home_button2_url' ));
        $home_bg_color = sanitize_hex_color(get_theme_mod( 'kr_home_bg_color' ));
        $home_bg = esc_url(get_theme_mod( 'kr_theme_home_bg', get_template_directory_uri() . '/img/start-bg.jpg' ));
    ?>

        <?php if ( 'slider' !== $slide_option && 'video' !== $slide_option ) : 
            if ( 'color' === $home_bg_radio ) : ?>
                <div id="home" class="elementor-menu-anchor"></div>
                <section class="home-color-section" style="background: <?php echo $home_bg_color; ?> ">
            <?php else : ?>
                <div id="home" class="elementor-menu-anchor"></div>
                <section id="parallax-bg" class="<?php echo $header_style; ?>">
                    <?php if ( true === get_theme_mod( 'kr_home_parallax', true ) ) : ?>
                        <div id="slider-inner" class="home-bg-item" data-parallax="scroll" data-image-src="<?php echo $home_bg; ?>">
                            <div class="inner-overlay">
                    <?php else : ?>
                        <div id="slider-inner" class="home-bg-item" style="background:url('<?php echo $home_bg; ?>') no-repeat;">
                            <div class="inner-overlay">
                    <?php endif; ?>
            <?php endif; ?>

            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="slide-bg-section">
                            <div class="slide-bg-text">
                                <h2 class="wow fadeInDown <?php echo esc_attr(get_theme_mod( 'kr_home_text_position', 'center' )); ?>" data-wow-duration="2s" data-wow-delay="1s">
                                    <?php echo !empty($home_heading_text) ? $home_heading_text : bloginfo( 'name' ); ?>
                                </h2>
                                <p class="wow fadeInUp <?php echo esc_attr(get_theme_mod( 'kr_home_text_position', 'center' )); ?>" data-wow-duration="2s" data-wow-delay="1s">
                                    <?php echo $home_subheading_text; ?>
                                </p>

                                <div class="slide-buttons <?php echo esc_attr(get_theme_mod( 'kr_home_text_position', 'center' )); ?>">    
                                    <?php 
                                        if ( !empty( $button_text ) ) :
                                            $btn_class = ( false !== strpos( $button_url, 'youtube' ) || false !== strpos( $button_url, 'vimeo' ) ) ? 'video-popup-link' : '';
                                            ?>
                                            <div class="read-more first">
                                                <a class="btn <?php echo $btn_class; ?>" href="<?php echo $button_url; ?>">
                                                    <?php echo $button_text; ?> <i class="fas fa-angle-double-right"></i>
                                                </a>
                                            </div>  
                                    <?php endif; ?>

                                    <?php 
                                        if ( !empty( $button2_text ) ) :
                                            $btn_class2 = ( false !== strpos( $button2_url, 'youtube' ) || false !== strpos( $button2_url, 'vimeo' ) ) ? 'video-popup-link' : '';
                                            ?>
                                            <div class="read-more second">
                                                <a class="btn <?php echo $btn_class2; ?>" href="<?php echo $button2_url; ?>">
                                                    <?php echo $button2_text; ?> <i class="fas fa-angle-double-right"></i>
                                                </a>
                                            </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <?php if ( true === get_theme_mod( 'kr_home_scroll_down', true ) ) : ?>
                            <div class="scroll-down">
                                <a data-scroll href="<?php echo esc_url(get_theme_mod( 'kr_scroll_button_url' )); ?>">
                                    <span class="mouse"><span></span></span>                                                                
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <?php echo ( 'color' === $home_bg_radio ) ? '</div></section>' : '</div></div></section>'; ?>
        <?php endif; ?>
    <?php endif; ?>