<?php
/**
 * Krystal: Dynamic CSS Stylesheet
 * 
 */

function krystal_dynamic_css_stylesheet() {    
 
    $link_color= sanitize_hex_color(get_theme_mod( 'kr_link_color','#444444' ));
    $link_hover_color= sanitize_hex_color(get_theme_mod( 'kr_link_hover_color','#000000' ));
    $heading_color= sanitize_hex_color(get_theme_mod( 'kr_heading_color','#444444' ));
    $heading_hover_color= sanitize_hex_color(get_theme_mod( 'kr_heading_hover_color','#000000' ));
    $trans_button_hover_color= sanitize_hex_color(get_theme_mod( 'kr_trans_button_hover_color','#000000'));
    $button_color= sanitize_hex_color(get_theme_mod( 'kr_button_color','#444444' ));
    $button_hover_color= sanitize_hex_color(get_theme_mod( 'kr_button_hover_color','#444444' ));
    $port_image_hover_color= sanitize_hex_color(get_theme_mod( 'kr_port_image_hover_color','#444444' ));
    $footer_bg_color= sanitize_hex_color(get_theme_mod( 'kr_footer_bg_color','#000000' ));
    $footer_content_color= sanitize_hex_color(get_theme_mod( 'kr_footer_content_color','#ffffff' ));
    $footer_links_color= sanitize_hex_color(get_theme_mod( 'kr_footer_links_color','#b3b3b3' ));
    $top_menu_color= sanitize_hex_color(get_theme_mod( 'kr_top_menu_color','#ffffff' ));
    $top_menu_button_color= sanitize_hex_color(get_theme_mod( 'kr_top_menu_button_color','#5b9dd9' ));
    $top_menu_button_text_color= sanitize_hex_color(get_theme_mod( 'kr_top_menu_button_text_color','#fff' ));
    $top_menu_dd_color= sanitize_hex_color(get_theme_mod( 'kr_top_menu_dd_color','#dd3333' ));
    $home_bg_image_text_color= sanitize_hex_color(get_theme_mod( 'kr_home_bg_image_text_color','#ffffff' ));
    $page_bg_image_text_color= sanitize_hex_color(get_theme_mod( 'kr_page_bg_image_text_color','#ffffff' ));
    $sticky_top_menu_button_color= sanitize_hex_color(get_theme_mod( 'kr_sticky_top_menu_button_color','#5b9dd9' ));
    $sticky_top_menu_button_text_color= sanitize_hex_color(get_theme_mod( 'kr_sticky_top_menu_button_text_color','#ffffff' ));
    $mobile_menu_top_menu_button_color= sanitize_hex_color(get_theme_mod( 'kr_mobile_menu_top_menu_button_color','#5b9dd9' ));
    $mobile_menu_top_menu_button_text_color= sanitize_hex_color(get_theme_mod( 'kr_mobile_menu_top_menu_button_text_color','#ffffff' ));
    $pagetitle_hft= absint(get_theme_mod( 'kr_pagetitle_hft','150' ));
    $pagetitle_hfb= absint(get_theme_mod( 'kr_pagetitle_hfb','125' ));
    $preloader_image=esc_url(get_theme_mod( 'kr_preloader_image' ));
    //contact form color
    $cf_label_color= sanitize_hex_color(get_theme_mod( 'kr_cf_label_color','#555555'));
    $cf_text_color= sanitize_hex_color(get_theme_mod( 'kr_cf_text_color','#555555'));
    $cf_bg_color= sanitize_hex_color(get_theme_mod( 'kr_cf_bg_color','#555'));
    $cf_border_color= sanitize_hex_color(get_theme_mod( 'kr_cf_border_color','#fff'));
    $cf_button_color= sanitize_hex_color(get_theme_mod( 'kr_cf_button_color','#555555'));          
    $cf_button_bg_color= sanitize_hex_color(get_theme_mod( 'kr_cf_button_bg_color','#555555'));
    $breadcrumbs_color= sanitize_hex_color(get_theme_mod( 'kr_breadcrumb_text_color','#fff' ));
    

    $css = '        

        .wp-block-cover.alignwide,
        .wp-block-columns.alignwide,
        .wc-block-grid__products,
        .wp-block-cover-image .wp-block-cover__inner-container, 
        .wp-block-cover .wp-block-cover__inner-container {
             padding: 0 15px;
        }

        footer h4.widget-title {
            margin-bottom: 20px !important;
        }

        a {        
            color: ' . $link_color . '; 
            vertical-align: top;
        }

        a:hover {
            color: ' . $link_hover_color . '; 
            
        }  

        h1,h2,h3,h4,h5,h6 {        
            color: ' . $heading_color . '; 
        }

        h1:hover,
        h2:hover,
        h3:hover,
        h4:hover,
        h5:hover,
        h6:hover {
            color: ' . $heading_hover_color . ';    
        }

        button.trans:hover, 
        button.trans:focus, 
        button.trans:active {
            background: ' . $trans_button_hover_color . ' !important;    
            color: #fff !important;    
        }  

        #commentform input[type=submit]:hover,
        #commentform input[type=submit]:focus {
            background: ' . $trans_button_hover_color . ' !important;
            border: 1px solid ' . $trans_button_hover_color . ' !important;
            color: #fff !important;
            transition: all 0.3s ease-in-out; 
        }

        a.trans:hover,
        a.trans:focus {
            background: ' . $trans_button_hover_color . ' !important;
            border: 1px solid ' . $trans_button_hover_color . ' !important;
            color: #fff !important;
            transition: all 0.3s ease-in-out;
        }

        .slide-bg-section .read-more a:hover,
        .slide-bg-section .read-more a:focus,
        .slider-buttons a:hover,
        .slider-buttons a:focus {
            background: ' . $trans_button_hover_color . ' !important;
            border: 1px solid ' . $trans_button_hover_color . ' !important;
            color: #fff !important;
            transition: all 0.3s ease-in-out;
        }

        .btn-default {
            background: ' . $button_color . ' !important;
            border: 1px solid ' . $button_color . ' !important;
        }

        .btn-default:hover,
        .btn-default:focus {
            background: ' . $button_hover_color . ' !important;
        }

        .slider-buttons a .btn-default {
            background:none !important;
        }

        .pagination .nav-links .current {
            background: ' . $link_color . ' !important;
        }

        .isotope #filter li.selected a, 
        .isotope #filter li a:hover {
            color: ' . $link_color . ' !important;
        }

        [class^=\'imghvr-fold\']:after, 
        [class^=\'imghvr-fold\']:before, 
        [class*=\' imghvr-fold\']:after, 
        [class*=\' imghvr-fold\']:before {
            background-color: ' . $port_image_hover_color . ' !important;
        }

        [class^=\'imghvr-\'] figcaption, [class*=\' imghvr-\'] figcaption {    
            background-color: ' . $port_image_hover_color . ' !important;
        }

        footer#footer {        
            background: ' . $footer_bg_color . ';
            color: ' . $footer_content_color . ';
        }

        footer h4 {
            color: ' . $footer_content_color . ';   
        }

        footer#footer a,
        footer#footer a:hover {
            color: ' . $footer_links_color . ';      
        }

        .section-title.page-title {
            padding-top: ' . $pagetitle_hft . 'px;
            padding-bottom: ' . $pagetitle_hfb . 'px;
        }

        header.style-2 #krystal-main-menu-wrapper .nav>li>a,
        header.style-2 .site-title a, 
        header.style-2 .site-title a:hover, 
        header.style-2 .site-title a:focus, 
        header.style-2 .site-title a:visited,
        header.style-2 p.site-description,
        header.style-2 .navbar-toggle {
            color: ' . $top_menu_color . ';      
        }

        header.menu-wrapper.fixed nav ul li a,
        header.menu-wrapper.style-2.fixed nav ul li a {
            color: #555;
        }

        #krystal-main-menu-wrapper li.menu-button > a {
            background-color: ' . $top_menu_button_color . ';
            color: ' . $top_menu_button_text_color . ' !important;        
        }

        #krystal-main-menu-wrapper li.menu-button > a:active:not(#krystal-main-menu-wrapper li.menu-button a),
        #krystal-main-menu-wrapper li.menu-button > a:hover:not(#krystal-main-menu-wrapper li.menu-button a) {
            background-color: ' . $top_menu_button_color . ';
            color: ' . $top_menu_button_text_color . ' !important;
        }

        header.menu-wrapper.fixed nav ul li.menu-button a, 
        header.menu-wrapper.style-2.fixed nav ul li.menu-button a {
            color: ' . $top_menu_button_text_color . ' !important;   
            background: ' . $top_menu_button_color . ';
        }

        .slide-bg-section h2,
        .slide-bg-section,
        .slide-bg-section .read-more a {
            color: ' . $home_bg_image_text_color . ' !important;         
        }

        .slide-bg-section .read-more a,
        .scroll-down .mouse {
            border: 1px solid ' . $home_bg_image_text_color . ' !important;         
        }

        .scroll-down .mouse > *{
            background: ' . $home_bg_image_text_color . ' !important;         
        }

        .section-title h1 {
            color: ' . $page_bg_image_text_color . ';            
        }

        .page-title span,
        .page-title span a,
        .page-title #breadcrumbs,
        .page-title #breadcrumbs a {
            color: ' . $breadcrumbs_color . ';
        }
    
        .page-title .breadcrumbs li:after {
            content: ">";
            display: inline-block;
            color: ' . $breadcrumbs_color . ';
        }

        form.wpcf7-form input,
        form.wpcf7-form textarea,
        form.wpcf7-form radio,
        form.wpcf7-form checkbox,
        form.wpcf7-form select {
            background: transparent;
            border: none;
            border-bottom: 1px solid ' . $cf_text_color .';
            color: ' . $cf_text_color .';
        }  

        form.wpcf7-form select {
            padding-left: 20px;
            margin-top: 20px;
        }

        form.wpcf7-form input::placeholder,
        form.wpcf7-form textarea::placeholder {
            color: ' . $cf_text_color .';   
        }

        form.wpcf7-form input[type="submit"] {
            color: ' . $cf_button_color .';
            background: none;
            border: 1px solid ' . $cf_button_color . ' !important;
        }

        form.wpcf7-form input[type="submit"]:hover,
        form.wpcf7-form input[type="submit"]:focus {
            background: ' . $cf_button_bg_color . ' !important;
            color: #fff;
            border: 1px solid ' . $cf_button_bg_color . ' !important;
        }

        form.wpcf7-form label {
            color: ' . $cf_label_color . ';               
        }

        header.style-1.fixed #krystal-main-menu-wrapper li.menu-button > a,
        header.style-2.fixed #krystal-main-menu-wrapper li.menu-button > a  {
            color: ' . $sticky_top_menu_button_text_color .' !important;
            background: ' . $sticky_top_menu_button_color .' !important;
        }

        .elementor-editor-active header.style-1.menu-wrapper.fixed, 
        .elementor-editor-active header.style-2.menu-wrapper.fixed {
            display: none;
        }

        @media (min-width: 992px) {
            .dropdown-menu > li:hover, 
            .dropdown-menu .dropdown-menu > li:hover {
                background: ' . $top_menu_dd_color . ' !important;
                border-top-left-radius: 4px;
                border-top-right-radius: 4px;
            }

            .dropdown-menu > .active > a:hover, 
            .dropdown-menu > .active > a:focus {
                background: ' . $top_menu_dd_color . ' !important;   
            }
        }

        @media (max-width: 767px) {
            #krystal-main-menu-wrapper li.menu-button > a,
            header.style-1 #krystal-main-menu-wrapper li.menu-button > a,
            header.style-2 #krystal-main-menu-wrapper li.menu-button > a {
                color: ' . $mobile_menu_top_menu_button_text_color .' !important;
                background: ' . $mobile_menu_top_menu_button_color .' !important;
            }
        }

        @media (max-width: 767px) {
            .has-blocks h1:not(h1.site-title):not(.blog h1):not(.single h1):not(.archive h1):not(.wp-block-cover__inner-container h1), 
            .has-blocks h2:not(.blog h2):not(.single h2):not(.archive h2):not(.wp-block-cover__inner-container h2), 
            .has-blocks h3:not(.blog h3):not(.single h3):not(.archive h3):not(.wp-block-cover__inner-container h3), 
            .has-blocks h4:not(.blog h4):not(.single h4):not(.archive h4):not(.wp-block-cover__inner-container h4), 
            .has-blocks h5:not(.blog h5):not(.single h5):not(.archive h5):not(.wp-block-cover__inner-container h5), 
            .has-blocks h6:not(.blog h6):not(.single h6):not(.archive h6):not(.wp-block-cover__inner-container h6),
            .has-blocks p:not(blockquote p):not(.container p),
            .has-blocks blockquote,
            .has-blocks .wp-block-columns,
            .has-blocks table,
            .has-blocks dl,
            .has-blocks ul:not(ul.md-cart-menu),
            .has-blocks ol,
            .has-blocks address,
            .has-blocks pre,
            .has-blocks .wp-block-cover.alignwide,
            .has-blocks .wp-block-columns.alignwide,
            .has-blocks .wc-block-grid__products,
            .has-blocks .wp-block-cover-image .wp-block-cover__inner-container, 
            .has-blocks .wp-block-cover .wp-block-cover__inner-container {
                padding-left: 15px;
                padding-right: 15px;
            }

            .has-blocks figure.alignleft > p {
                padding-left: 15px;
                padding-right: 15px;
            }
        }

        @media (min-width: 768px) {
            .has-blocks h1:not(h1.site-title):not(.blog h1):not(.single h1):not(.archive h1):not(.wp-block-cover__inner-container h1), 
            .has-blocks h2:not(.blog h2):not(.single h2):not(.archive h2):not(.wp-block-cover__inner-container h2), 
            .has-blocks h3:not(.blog h3):not(.single h3):not(.archive h3):not(.wp-block-cover__inner-container h3), 
            .has-blocks h4:not(.blog h4):not(.single h4):not(.archive h4):not(.wp-block-cover__inner-container h4), 
            .has-blocks h5:not(.blog h5):not(.single h5):not(.archive h5):not(.wp-block-cover__inner-container h5), 
            .has-blocks h6:not(.blog h6):not(.single h6):not(.archive h6):not(.wp-block-cover__inner-container h6),
            .has-blocks p:not(blockquote p):not(.container p),
            .has-blocks blockquote,
            .has-blocks .wp-block-columns,
            .has-blocks table,
            .has-blocks dl,
            .has-blocks ul:not(ul.md-cart-menu),
            .has-blocks ol,
            .has-blocks address,
            .has-blocks pre,
            .has-blocks .wp-block-cover.alignwide,
            .has-blocks .wp-block-columns.alignwide,
            .has-blocks .wc-block-grid__products,
            .has-blocks .wp-block-cover-image .wp-block-cover__inner-container, 
            .has-blocks .wp-block-cover .wp-block-cover__inner-container {
                max-width: 750px;
                margin: 0 auto;
            }

            .has-blocks figure.alignleft > p {
                width: 750px;
            }
        }

        @media (min-width: 992px) {
            .has-blocks h1:not(h1.site-title):not(.blog h1):not(.single h1):not(.archive h1):not(.wp-block-cover__inner-container h1), 
            .has-blocks h2:not(.blog h2):not(.single h2):not(.archive h2):not(.wp-block-cover__inner-container h2), 
            .has-blocks h3:not(.blog h3):not(.single h3):not(.archive h3):not(.wp-block-cover__inner-container h3), 
            .has-blocks h4:not(.blog h4):not(.single h4):not(.archive h4):not(.wp-block-cover__inner-container h4), 
            .has-blocks h5:not(.blog h5):not(.single h5):not(.archive h5):not(.wp-block-cover__inner-container h5), 
            .has-blocks h6:not(.blog h6):not(.single h6):not(.archive h6):not(.wp-block-cover__inner-container h6),
            .has-blocks p:not(blockquote p):not(.container p),
            .has-blocks blockquote,
            .has-blocks .wp-block-columns,
            .has-blocks table,
            .has-blocks dl,
            .has-blocks ul:not(ul.md-cart-menu),
            .has-blocks ol,
            .has-blocks address,
            .has-blocks pre,
            .has-blocks .wp-block-cover.alignwide,
            .has-blocks .wp-block-columns.alignwide,
            .has-blocks .wc-block-grid__products,
            .has-blocks .wp-block-cover-image .wp-block-cover__inner-container, 
            .has-blocks .wp-block-cover .wp-block-cover__inner-container {
                max-width: 970px;
                margin: 0 auto;
            }

            .has-blocks figure.alignleft > p {
                width: 970px;
            }
        }

        @media (min-width: 1200px) {
            .has-blocks h1:not(h1.site-title):not(.blog h1):not(.single h1):not(.archive h1):not(.wp-block-cover__inner-container h1), 
            .has-blocks h2:not(.blog h2):not(.single h2):not(.archive h2):not(.wp-block-cover__inner-container h2), 
            .has-blocks h3:not(.blog h3):not(.single h3):not(.archive h3):not(.wp-block-cover__inner-container h3), 
            .has-blocks h4:not(.blog h4):not(.single h4):not(.archive h4):not(.wp-block-cover__inner-container h4), 
            .has-blocks h5:not(.blog h5):not(.single h5):not(.archive h5):not(.wp-block-cover__inner-container h5), 
            .has-blocks h6:not(.blog h6):not(.single h6):not(.archive h6):not(.wp-block-cover__inner-container h6),
            .has-blocks p:not(blockquote p):not(.container p),
            .has-blocks blockquote,
            .has-blocks .wp-block-columns,
            .has-blocks table,
            .has-blocks dl,
            .has-blocks ul:not(ul.md-cart-menu),
            .has-blocks ol,
            .has-blocks address,
            .has-blocks pre,
            .has-blocks .wp-block-cover.alignwide,
            .has-blocks .wp-block-columns.alignwide,
            .has-blocks .wc-block-grid__products,
            .has-blocks .wp-block-cover-image .wp-block-cover__inner-container, 
            .has-blocks .wp-block-cover .wp-block-cover__inner-container {
                max-width: 1170px;
                margin: 0 auto;
            }

            .has-blocks figure.alignleft > p {
                width: 1170px;
            }
        }

    ';

    //preloader image is not empty
    if("" != esc_url(get_theme_mod( 'kr_preloader_image' ))) {
        $css .='     
            #pre-loader {
                height: 100px;
                width: 100px;
                background: url(' . $preloader_image . ') no-repeat !important;
            }
        ';  
    }
    else{
        $css .='     
            .loader-wrapper {
                top: 0;
                bottom: 0;
                left: 0;
                right: 0;
            }

            #pre-loader {
                height: 30px;
                width: 30px;
                display: inline-block;
                background: transparent;
                border-radius: 50%;
                border-width: 4px;
                border-style: solid;
                border-color: #d0d0d0 #d0d0d0 #000 #d0d0d0;
                -webkit-animation: 1s linear 0s normal none infinite running spinner_preloader;
                -moz-animation: 1s linear 0s normal none infinite running spinner_preloader;
                animation: 1s linear 0s normal none infinite running spinner_preloader;
            }
        ';
    }

    //if sticky header disabled
    if(false===get_theme_mod( 'kr_sticky_menu',true)) {
        $css .='        
             header.menu-wrapper.fixed { 
                display:none !important;
            }           
        ';  
    }

    //if dark overlay disabled
    if(false===get_theme_mod( 'kr_home_dark_overlay',true)) {
        $css .='        
             #parallax-bg #slider-inner:before {            
                background: none !important;    
                opacity: 0.8;            
            }           
        ';  
    }

    // if home background section disabled
    if(true===get_theme_mod( 'kr_home_disable_section',false)) {
        $css .='        
            #parallax-bg,
            .home-color-section {            
                display: none;            
            } 

            .page .page-content-area {
                margin: 0;
            }      

            .woocommerce .page-content-area,
            .woocommerce-page .page-content-area {
                margin: 70px 0;
            }          

            .elementor-editor-active header.menu-wrapper {
                z-index: 0;
            }

            .elementor-editor-active header.menu-wrapper.fixed {
                display: none;
            }

            .home .page-content-area {
                margin: 0;
            }
        ';  
    }

    // if page title dark overlay enabled
    if(true===get_theme_mod( 'kr_page_dark_overlay',false)) {
        $css .='        
             .page-title .img-overlay {
                background: rgba(0,0,0,.5);
                color: #fff;
            }          
        ';  
    }

    // if homepage set to blog
    if(true===get_theme_mod( 'kr_blog_homepage',false)) {
        $css .='        
             #parallax-bg #slider-inner {
               height: 70vh;
            }

            section.home-color-section {
                height: 70vh;
            }

            .slide-bg-section {
                height: calc(70vh - 5px);
            } 

            body {
                background: #fbfbfb;
            }

            article {
                margin: 70px 0;
                background: #fff;
                padding: 1px 30px;            
                box-shadow: 0px 0px 3px 0px #c5c5c5;
                -moz-box-shadow: 0px 0px 3px 0px #c5c5c5;
                -webkit-box-shadow: 0px 0px 3px 0px #c5c5c5;
            }

            article .blog-wrapper {
                margin: 0;
                padding-top: 30px;
                padding-right: 0;
            }

            .widget-area .widget {
                margin: 5px 0;
                background: #fff;
                padding: 20px 20px;            
                box-shadow: 0px 0px 3px 0px #c5c5c5;
                -moz-box-shadow: 0px 0px 3px 0px #c5c5c5;
                -webkit-box-shadow: 0px 0px 3px 0px #c5c5c5;
            }

            aside h4.widget-title {
                font-size: 15px;
            }

            .widget li a {
                color: #555;
            }

            .widget-area {
                margin:70px 0;
            }

            body.page {
                background: #fff;
            }

            .page-content-area article {
                box-shadow: none;
                -moz-box-shadow: none;
                -webkit-box-shadow: none;
            }
        ';  
    }

    // if form elements has bg style
    if('bg'===esc_html(get_theme_mod('kr_form_elem_settings_style','default'))) {
        $css .='        
            form.wpcf7-form input,
            form.wpcf7-form textarea,
            form.wpcf7-form radio,
            form.wpcf7-form checkbox,
            form.wpcf7-form select {
                background: ' . $cf_bg_color .';
                border: 1px solid ' . $cf_border_color .' !important;
                border-radius: 4px;
            }  

            form.wpcf7 input[type="submit"] {
                color: ' . $cf_text_color .';
                background: none;
                border: 1px solid ' . $cf_bg_color . ' !important;
                border-radius: 45px;
            }
        ';
    }
    else{
        $css .='        
            form.wpcf7-form input,
            form.wpcf7-form textarea,
            form.wpcf7-form radio,
            form.wpcf7-form checkbox,
            form.wpcf7-form select {
                background: transparent;
                border-bottom: 1px solid ' . $cf_bg_color .' !important;
                border-radius: 0;
            }

            form.wpcf7 input[type="submit"] {
                border-radius: 45px;
            }
        ';
    }

    // if form width set to full width
    if(true===get_theme_mod('kr_form_width_setting',false)) {
        $css .='        
            form.wpcf7-form {
                width: 100%;
                margin: auto;
            }
        ';
    }

    // if page title disabled & header is style-1
    if(true===get_theme_mod( 'kr_page_title_section_hide',false) && "style1" === esc_html(get_theme_mod( 'kr_header_styles','style1'))) {
        $css .='        
            .page #primary,
            .archive #primary,
            .blog #primary,
            .single #primary,
            .search #primary,
            .error404 #primary {
                margin-top: 100px;
            }

            .home #primary {
                margin-top: 0;
            }
        ';   
    }


    // if header is style-1
    if("style1" === esc_html(get_theme_mod( 'kr_header_styles','style1'))) { 
        $css .='
            
            header.style-1.fixed #krystal-main-menu-wrapper .nav>li>a:not(#krystal-main-menu-wrapper li.menu-button > a),
            header.style-1.fixed .site-title > a, 
            header.style-1.fixed .site-title > a:hover, 
            header.style-1.fixed .site-title > a:focus, 
            header.style-1.fixed .site-title > a:visited,
            header.style-1.fixed p.site-description,
            header.style-1.fixed #search-box .search input,
            header.style-1.fixed #search-box .search input::placeholder,
            header.style-1.fixed .topbar-text, 
            header.style-1.fixed .topbar-text a, 
            header.style-1.fixed .topbar-text a:hover, 
            header.style-1.fixed span#call-us, header.style-1.fixed span#call-us a, 
            header.style-1.fixed span#call-us a:hover, header.style-1.fixed #menu-social li i,
            header.style-1.fixed .navbar-toggle {
                color: #555 !important;      
            }

            header.style-1.fixed .menu-search:before, 
            header.style-1.fixed .menu-search:after, 
            header.style-1.fixed .menu-search-x:before, 
            header.style-1.fixed .menu-search-x:after {
                border: 1px solid #555;
            }

            header.style-1.fixed.menu-wrapper li.menu-cart-inner .fas,
            header.style-1.fixed.menu-wrapper .res-cart-menu .fas {
                color: #555;    
            }

            header.style-1.fixed #search-box .search input {
                border-bottom: 1px solid #555 !important;
            }

            header.style-1.fixed #krystal-main-menu-wrapper .navbar-toggle .icon-bar {
                background: #555;    
            }

            header.style-1 .site-title > a, 
            header.style-1 .site-title > a:hover, 
            header.style-1 .site-title > a:focus, 
            header.style-1 .site-title > a:visited,
            header.style-1 p.site-description,
            header.style-1 .topbar-text, 
            header.style-1 .topbar-text a, 
            header.style-1 .topbar-text a:hover, 
            header.style-1 span#call-us, header.style-1 span#call-us a, 
            header.style-1 span#call-us a:hover, header.style-1 #menu-social li i,
            header.style-1 #search-box .search input,
            header.style-1 #search-box .search input::placeholder,
            header.style-1 .navbar-toggle {
                color: ' . $top_menu_color .' !important;
            }

            header.style-1 #krystal-main-menu-wrapper .navbar-toggle .icon-bar {
                background: ' . $top_menu_color .';    
            }

            header.style-1 .menu-search:before, 
            header.style-1 .menu-search:after, 
            header.style-1 .menu-search-x:before, 
            header.style-1 .menu-search-x:after {
                border: 1px solid ' . $top_menu_color .';
            }

            header.style-1.menu-wrapper li.menu-cart-inner .fas,
            header.style-1.menu-wrapper .res-cart-menu .fas {
                color: ' . $top_menu_color .';    
            }

            header.style-1 #search-box .search input {
                border-bottom: 1px solid ' . $top_menu_color .' !important;
            }

            @media only screen and (min-width: 768px) {
                header.style-1 #krystal-main-menu-wrapper .nav>li>a:not(#krystal-main-menu-wrapper li.menu-button > a) {
                    color: ' . $top_menu_color .' !important;     
                }
            }

            @media only screen and (max-width: 767px) {
                header.style-1 #krystal-main-menu-wrapper .nav>li>a:not(#krystal-main-menu-wrapper li.menu-button > a) {
                    color: #555 !important;
                }
            }
        ';
    }


    // For Skip links: Transparent header //
    if("style1" === esc_html(get_theme_mod( 'kr_header_styles','style1'))) { 
        if(true===get_theme_mod( 'kr_page_title_section_hide',false)) {
            $css .=' 

                .blog .skiptarget,
                .single .skiptarget {
                    position: absolute;
                    top: 150px;
                }

                .page .skiptarget {
                    position: absolute;
                    top: 100px;
                }
            ';
            
        }
        else{
            if(false===get_theme_mod( 'kr_sticky_menu',true)) {
                $css .='        
                    .blog .skiptarget,
                    .single .skiptarget {
                        position: absolute;
                        top: 350px;
                    }

                    .page .skiptarget {
                        position: absolute;
                        top: 330px;
                    }
                ';
            }
            else{
                $css .='        
                    .blog .skiptarget,
                    .single .skiptarget {
                        position: absolute;
                        top: 300px;
                    }

                    .page .skiptarget {
                        position: absolute;
                        top: 260px;
                    }

                    .archive .skiptarget,
                    .error404 .skiptarget,
                    .search .skiptarget {
                        position: absolute;
                        top: 270px;
                    }
                ';
            }
        }
    }


    // For Skip links: Default header //
    if("style2" === esc_html(get_theme_mod( 'kr_header_styles','style1'))) { 
        if(true===get_theme_mod( 'kr_page_title_section_hide',false)) {
            
            $css .=' 

                .blog .skiptarget,
                .single .skiptarget {
                    position: absolute;
                    top: 150px;
                }

                .page .skiptarget {
                    position: absolute;
                    top: 100px;
                }
            ';
            
        }
        else{
            if(false===get_theme_mod( 'kr_sticky_menu',true)) {
                $css .='        
                    .blog .skiptarget,
                    .single .skiptarget {
                        position: absolute;
                        top: 425px;
                    }

                    .page .skiptarget {
                        position: absolute;
                        top: 420px;
                    }
                ';
            }
            else{
                $css .='        
                    .blog .skiptarget,
                    .single .skiptarget {
                        position: absolute;
                        top: 300px;
                    }

                    .page .skiptarget {
                        position: absolute;
                        top: 260px;
                    }

                    .archive .skiptarget,
                    .error404 .skiptarget,
                    .search .skiptarget {
                        position: absolute;
                        top: 295px;
                    }
                ';
            }
        }
    }

    // For HomePage Skip links: Transparent header //
    if("style1" === esc_html(get_theme_mod( 'kr_header_styles','style1'))) { 
        if(true===get_theme_mod( 'kr_home_disable_section',false)) {
            
            $css .='        
                .home .skiptarget {
                    position: absolute;
                    top: 50px;
                }
            ';
            
        }
        else{
            if(false===get_theme_mod( 'kr_sticky_menu',true)) {
                $css .='        
                    .home .skiptarget {
                        position: absolute;
                        top: 105vh;
                    }
                ';
            }
            else{
                $css .='        
                    .home .skiptarget {
                        position: absolute;
                        top: 100vh;
                    }
                ';
            }
        }
    }

    // For HomePage Skip links: Normal header //
    if("style2" === esc_html(get_theme_mod( 'kr_header_styles','style1'))) { 
        if(true===get_theme_mod( 'kr_home_disable_section',false)) {
            
            $css .='        
                .home .skiptarget {
                    position: absolute;
                    top: 100px;
                }
            ';
        }
        else{
            if(false===get_theme_mod( 'kr_sticky_menu',true)) {
                $css .='        
                    .home .skiptarget {
                        position: absolute;
                        top: 115vh;
                    }
                ';
            }
            else{
                $css .='        
                    .home .skiptarget {
                        position: absolute;
                        top: 95vh;
                    }
                ';
            }
        }
    }

    //if active footer columns
    if(is_active_sidebar('footer-column1') || is_active_sidebar('footer-column2') || is_active_sidebar('footer-column3') || is_active_sidebar('footer-column4')){
        $css .='        
            footer#footer {
                padding-top: 50px;
            }
        ';
    }

    /*  Sticky logo spacing */
    if ( "" != esc_url(get_theme_mod( 'kr_alt_logo' )))  {
        $css .='
            header.fixed h1.site-title {
                margin-top: 0;
            }
        ';
    }
    else {
        $css .='
            header.fixed h1.site-title {
                margin-top: 0;
            }

            header.fixed p.site-description {
                margin: 0;
            }
        ';
    }

    /*  if user logged in */
    if (is_admin_bar_showing() && !is_customize_preview())  {
        $css .='
            header.style-1 {
                margin-top: 30px;
            }

            header.fixed.style-2 {
                margin-top: 30px;
            }
        ';
    }


    // breadcrumb enable
    if( true === get_theme_mod( 'krystal_enable_page_breadcrumbs',true)) {
        $css .='

            .page-title h1 {
                padding-bottom: 0;
            }

            .page-title #breadcrumbs {
                margin-top: 10px;
                margin-bottom: 30px;
            }

            .page-title span {
                display: inline-block;
                margin-top: 5px;
                margin-bottom: 15px;
            }

            .page-title .breadcrumbs li {
                display: inline-block;
                padding: 0 3px;
            }

            .page-title .breadcrumbs li:after {
                content: ">";
                display: inline-block;
            }

            .page-title .breadcrumbs li:last-child::after {
                display: none;
            }

            .page-title .breadcrumbs li a {
                padding-left: 10px;
                vertical-align: inherit;
            }

            .page-title .breadcrumb-wrapper span a {
                vertical-align: inherit;
            }

            .page-title h1 {
                padding-bottom: 0;
            }

            .page-title span {
                display: inline-block;
                margin-top: 5px;
                margin-bottom: 15px;
            }
        ';
    }

    return apply_filters( 'krystal_dynamic_css_stylesheet', krystal_minimize_css($css));
}
