<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package krystal
 */

get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">
		<?php 
			if (false === get_theme_mod('kr_page_title_section_hide', false)) {
				krystal_get_page_title(false, true, false, false); 
			}
		?>
		<div class="skiptarget">
			<div id="maincontent"></div>
		</div>
		<div class="content-inner">
			<div id="blog-section">
				<div class="container">
					<div class="row">
						<?php 
						$sidebar_position = esc_html(get_theme_mod('kr_blog_sidebar', 'right'));
						$content_classes = $sidebar_position === 'right' ? 'col-md-9' : 'col-md-9 col-md-offset-1';
						$sidebar_classes = $sidebar_position === 'right' ? 'col-md-3' : 'col-md-3';

						// Content Column
						?>
						<div class="<?php echo esc_attr($content_classes); ?>">
							<?php
								if (have_posts()) {
									while (have_posts()) {
										the_post();
										get_template_part('template-parts/content', get_post_format());
									}

									// Pagination
									echo '<nav class="pagination">';
									the_posts_pagination();
									echo '</nav>';
								}
							?>
						</div>

						<!-- Sidebar Column -->
						<div class="<?php echo esc_attr($sidebar_classes); ?>">
							<?php get_sidebar('sidebar-1'); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</main>
</div>

<?php get_footer(); ?>
