<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package krystal
 */

get_header(); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">
		<?php 
			if (!get_theme_mod('kr_page_title_section_hide', false)) {
				krystal_get_page_title(false, false, false, true);
			}
		?>
		<div class="skiptarget">
			<div id="maincontent"></div>
		</div>
		<div class="content-page">
			<div class="content-inner">
				<div class="container">
					<div class="row">
						<?php 
						$sidebar_position = esc_html(get_theme_mod('kr_blog_sidebar','right'));
						$content_classes = $sidebar_position === 'right' ? 'col-md-8' : 'col-md-8 col-md-offset-1';
						$sidebar_classes = $sidebar_position === 'right' ? 'col-md-3 col-md-offset-1' : 'col-md-3';

						if ($sidebar_position === 'right') : ?>
							<div class="<?php echo esc_attr($content_classes); ?>">
								<?php krystal_display_404_content(); ?>
							</div>
							<div class="<?php echo esc_attr($sidebar_classes); ?>">
								<?php get_sidebar('sidebar-1'); ?>
							</div>
						<?php else : ?>
							<div class="<?php echo esc_attr($sidebar_classes); ?>">
								<?php get_sidebar('sidebar-1'); ?>
							</div>
							<div class="<?php echo esc_attr($content_classes); ?>">
								<?php krystal_display_404_content(); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</main>
</div>

<?php get_footer(); ?>

<?php
/**
 * Display the 404 content block.
 */
function krystal_display_404_content() { ?>
	<div class="page-content-area">
		<h1 class="page-error"><?php esc_html_e('Oops! That page can&rsquo;t be found.', 'krystal'); ?></h1>
		<p><?php esc_html_e('It looks like nothing was found at this location. Maybe try one of the links on right or a search?', 'krystal'); ?></p>
		<?php get_search_form(); ?>
	</div>
<?php }
