<?php
/**
 * The template for displaying the header.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php wp_head(); ?>
</head>
<body <?php do_action( 'kripa_body_schema_init' ); ?> <?php body_class(); ?>>
	<?php do_action( 'wp_body_open' ); ?>
    <div class="kripa-body-padding-content">
    	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'kripa' ); ?></a>
			<?php
			do_action( 'kripa_top_bar' );
		
			do_action( 'kripa_before_header' );

			do_action( 'kripa_header' );

			do_action( 'kripa_after_header' );
			?>
		<div id="page">
            <div id="content" class="site-content">
                <?php
                // kripa_inside_container hook.
                do_action( 'kripa_inside_container' );
