<?php
/**
 * loop.php - Posts/Pages (the guts of the template)
 *
 * Fsk141 Framework
 * Unbloated template for simpletons
 *
 * License GPLv3 (license.txt)
 */
?>

<!-- START #content -->
	<div id="content">
		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

	<!-- START .post -->
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( is_page() ) {
	} else { ?>
		<!-- START .title -->
		<header class="title">
			<?php if (get_the_title() == "") { ?>
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>">Post From <?php the_time('F jS, Y') ?></a></h2>
			<?php }else {?>	
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
			<?php } ?>

		<!-- STOP .title -->
		</header>

		<!-- START .date_author -->
		<div class="date_author">
			<?php the_time('F jS, Y') ?> by <?php the_author_posts_link() ?>
			<?php edit_post_link(); ?>

		<!-- STOP .date_author -->
		</div>
	<?php } ?>
		<!-- START .text_chunk -->
		<div class="text_chunk">
			<?php the_content(); ?>

		<!-- STOP .text_chunk -->
		</div>

		<!-- START .pagelinks -->
		<?php wp_link_pages('before=<div id="pagelinks">&after=</div>'); ?>
		<!-- STOP .pagelinks -->

		<!-- START .category -->
			<?php if ( is_home() ) { ?>
				<div class="category">
			<?php
				echo "Posted in: "; the_category( ', ' ); echo " | ";
				the_tags('Tags: ', ', ', ' | ');
				echo " "; comments_popup_link( 'Leave a comment', '1 comment', '% comments', 'comments' ); ?>
				<hr>

		<!-- STOP .category -->
		</div>

		<!-- Post comment link/Page comments -->
		<?php } elseif ( is_singular() ) { ?>

		<!-- START .comment -->
		<div class="comment">
			<?php comments_template(); ?>

		<!-- STOP .comment -->
		</div>

		<?php } ?>

	<!-- STOP .post -->
	</article>


		<?php endwhile; else: ?>

		<!-- FAIL -->
			<p>Sorry, no posts matched your criteria.</p>

		<?php endif; ?>

<!-- STOP #content -->
	</div>

<!-- START #contentnav -->
<nav id="contentnav">

	<?php if ( is_home() ) { ?>

		<div class="contentnav-prev"><?php next_posts_link( '&larr; Older posts'  ); ?></div>
		<div class="contentnav-next"><?php previous_posts_link( 'Newer posts &rarr;' ); ?></div>

	<?php } elseif ( is_single() and ! is_page() ) { ?>

		<div class="contentnav-prev"><?php previous_post_link(); ?></div>
		<div class="contentnav-next"><?php next_post_link(); ?></div>

	<?php } ?>
		
<!-- #contentnav -->
</nav>
