<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Kouprey
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function kouprey_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	if ( 'none_sidebar' == get_theme_mod('kouprey_general_layout') ) {
		$classes[] = 'none-sidebar';
	} elseif ( 'left_sidebar' == get_theme_mod('kouprey_general_layout') ) {
		$classes[] = 'left-sidebar';
	} else {
		$classes[] = 'right-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'kouprey_body_classes' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function kouprey_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'kouprey_pingback_header' );


/**
 * exclude sticky posts from homepage
 */
function kouprey_remove_posts_from_home_page( $query ) {

	// sure we're were we want to be.
	if ( is_home() && $query->is_main_query() ) {
		$query->set( 'ignore_sticky_posts', true );
	}

}
add_action( 'pre_get_posts', 'kouprey_remove_posts_from_home_page' );
