<?php
/**
|------------------------------------------------------------------------------
| Static Control
|------------------------------------------------------------------------------
*/

	class kouprey_Theme_Info extends WP_Customize_Control {
		public function render_content() {
			echo $this->description;
		}
	}

	/**
	|------------------------------------------------------------------------------
	| OPTIONS
	|------------------------------------------------------------------------------
	*/
	$wp_customize->add_panel( 'panel_general', array(
		'priority'			=> 30,
		'capability'		=> 'edit_theme_options',
		'theme_supports'	=> '',
		'title'				=> __( 'Options General', 'kouprey' )
	));

	/*******************
	* Section: Layout *
	********************/
	$wp_customize->add_section( 'kouprey_general_layout_section' , array(
		'title'				=> __( 'Option Layout', 'kouprey' ),
		'priority'			=> 1,
		'section'			=> 'kouprey_general_section',
		'panel'				=> 'panel_general'
	));

	$wp_customize->add_setting( 'kouprey_general_layout', array('sanitize_callback' => 'kouprey_sanitize_select', 'default' => 'right_sidebar'));
	$wp_customize->add_control( 'kouprey_general_layout', array(
		'section'			=> 'kouprey_general_layout_section',
		'label'				=> __( 'Layout Style', 'kouprey' ),
		'description'		=> __( 'Choose your favorite layout', 'kouprey'),
		'type'				=> 'radio',
		'priority'			=> 2,
		'choices'			=> array(
			'none_sidebar'				=> __('None Sidebar', 'kouprey'),
			'left_sidebar'				=> __('Left Sidebar', 'kouprey'),
			'right_sidebar'				=> __('Right Sidebar', 'kouprey'),
		),
	));

	/*******************
	* Section: Meta info *
	********************/
	$wp_customize->add_section( 'kouprey_general_meta_info_section' , array(
		'title'				=> __( 'Option Meta info', 'kouprey' ),
		'priority'			=> 3,
		'section'			=> 'kouprey_general_section',
		'panel'				=> 'panel_general'
	));

	/*******************
	* Section: Excerpt *
	********************/
	$wp_customize->add_section( 'kouprey_general_excerpt_section' , array(
		'title'				=> __( 'Options Excerpt', 'kouprey' ),
		'priority'			=> 4,
		'section'			=> 'kouprey_general_section',
		'panel'				=> 'panel_general'
	));

	/* Excerpt Length */
	$wp_customize->add_setting('kouprey_general_excerpt_lengh', array('sanitize_callback' => 'kouprey_sanitize_number_absint', 'default' => 34));
	$wp_customize->add_control( 'kouprey_general_excerpt_lengh', array(
		'type'				=> 'number',
		'section'			=> 'kouprey_general_excerpt_section',
		'label'				=> __( 'Excerpt Length', 'kouprey' ),
		'description'		=> __( 'Expert Length is the number of words to show in Home/Archive pages.', 'kouprey'),
	));

	/* Excerpt End Text */
	$wp_customize->add_setting('kouprey_general_excerpt_end_text', array('sanitize_callback' => 'kouprey_sanitize_html', 'default' => ' ...'));
	$wp_customize->add_control( 'kouprey_general_excerpt_end_text', array(
		'type'				=> 'text',
		'section'			=> 'kouprey_general_excerpt_section',
		'label'				=> __( 'Excerpt Ending Text', 'kouprey' ),
	));

	/**********************
	* Section: Pagination *
	***********************/
	$wp_customize->add_section( 'kouprey_general_pagination_section' , array(
		'title'					=> __( 'Options Pagination', 'kouprey' ),
		'priority'				=> 5,
		'panel'					=> 'panel_general'
	));

	$wp_customize->add_setting('kouprey_general_pagination_mode', array('sanitize_callback' => 'kouprey_sanitize_select', 'default'	=> 'default', 'capability' => 'edit_theme_options' ));
	$wp_customize->add_control( 'kouprey_general_pagination_mode', array(
		'label'					=> __( 'Choose Pagination Type', 'kouprey' ),
		'section'				=> 'kouprey_general_pagination_section',
		'type'					=> 'radio',
		'priority'				=> 5,
		'choices'				=> array(
			'default'					=> __('Default (Older Posts/Newer Posts)', 'kouprey'),
			'numberal'					=> __('Numberal (1 2 3 ..)', 'kouprey'),
		),
	));
	