<?php
/**
|------------------------------------------------------------------------------
| OPTIONS
|------------------------------------------------------------------------------
*/
	$wp_customize->add_panel( 'options_banner_home', array(
		'priority'			=> 30,
		'capability'		=> 'edit_theme_options',
		'theme_supports'	=> '',
		'title'				=> __( 'Options Banner', 'kouprey' )
	));
	
	/*******************
	* Section: Homepage Banner *
	********************/
	$wp_customize->add_section( 'options_banner_home' , array(
		'title'				=> __( 'Homepage Banner', 'kouprey' ),
		'priority'			=> 1,
		'panel'				=> 'options_banner_home'
	));

	/*******************
	* Section: Banner Option *
	********************/
	$wp_customize->add_setting( 'kouprey_banner_option', array('sanitize_callback' => 'kouprey_sanitize_checkbox',	'default' => 'true'));
	$wp_customize->add_control( 'kouprey_banner_option', array(
		'section'			=> 'options_banner_home',
		'label'				=> __( 'Turn On Banner', 'kouprey' ),
		'type'				=> 'checkbox',
		'priority'			=> 1
	));

	/* Upload a BG Banner */
	$wp_customize->add_setting('kouprey_home_banner_bg', array('sanitize_callback' => 'kouprey_sanitize_url' ));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'kouprey_home_banner_bg', array(
			'label'				=> __( 'Background Image', 'kouprey' ),
			'section'			=> 'options_banner_home',
			'priority'			=> 1
		)
	));

	/* Label - Read More */
	$wp_customize->add_setting( 'kouprey_button_label_one', array( 'sanitize_callback' => 'kouprey_sanitize_nohtml', 'default' => 'Know More') );
	$wp_customize->add_control( 'kouprey_button_label_one', array(
		'label'				=> __( 'Label - Read More', 'kouprey' ),
		'type'				=> 'text',
		'section'			=> 'options_banner_home',
		'priority'			=> 2
	) );

	/* Label - Sign up Now */
	$wp_customize->add_setting( 'kouprey_button_label_two', array( 'sanitize_callback' => 'kouprey_sanitize_nohtml', 'default' => 'Sign up Now') );
	$wp_customize->add_control( 'kouprey_button_label_two', array(
		'label'				=> __( 'Label - Sign up Now', 'kouprey' ),
		'type'				=> 'text',
		'section'			=> 'options_banner_home',
		'priority'			=> 2
	) );

	/* Sign up Now - URL */
	$wp_customize->add_setting( 'kouprey_button_url_two', array( 'sanitize_callback' => 'kouprey_sanitize_url', 'default' => 'http://') );
	$wp_customize->add_control( 'kouprey_button_url_two', array(
		'type'				=> 'url',
		'section'			=> 'options_banner_home',
		'label'				=> __( 'Sign up Now - URL', 'kouprey' ),
		'priority'			=> 2,
		'input_attrs'		=> array(
			'placeholder'		=> __( 'http://', 'kouprey' ),
		)
	) );