<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Kouprey
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'kouprey' ); ?></a>
	
	<?php if ( get_header_image() ) : ?>
		<div id="site-header" class="clearfix" >
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
				<img src="<?php esc_url( header_image() ); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="">
			</a>
		</div>
	<?php endif; ?>

	<header id="masthead" class="banner-shadow sheader site-header clearfix">
		<div class="clearfix">
		
			<div class="content-wrap">
								
				<?php if ( has_custom_logo() ) : ?>

					<div class="site-branding branding-logo">
						<?php the_custom_logo(); ?>
					</div><!-- .site-branding -->

				<?php else : ?>

					<div class="site-branding">

						<?php if ( is_front_page() && is_home() ) : ?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h2>
						<?php
						endif;

						$description = get_bloginfo( 'description', 'display' );
						if ( $description || is_customize_preview() ) : ?>
							<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
						<?php
						endif;
						?>

					</div><!-- .site-branding -->

				<?php
				endif;
				?>

				<nav id="primary-site-navigation" class="primary-menu main-navigation">

					<a href="#" id="primary-pull" class="close-icon-menu" aria-controls="secondary-menu" aria-expanded="false"><?php esc_html_e( 'X', 'kouprey' ); ?></a>
					
					<?php
						wp_nav_menu( array(
							'theme_location'	=> 'menu-1',
							'menu_id'			=> 'primary-menu',
							'menu_class'		=> 'pmenu'
						) );
					?>

				</nav><!-- #primary-site-navigation -->
			</div>
		</div>

		<div class="super-menu clearfix">
			<div class="super-menu-nav">

				<button class="icon-toggle">
					<span class="inner-line"><?php esc_html_e( 'Toggle Main Menu', 'kouprey' ); ?></span>
				</button>

				<span class="inner-label"><?php esc_html_e( 'Menu', 'kouprey' ); ?></span>

			</div>
		</div>
	</header><!-- #masthead -->

	<?php
	if ( is_front_page() && is_home() ) :
		if ( get_theme_mod('kouprey_banner_option', true) == true ) :

			$args = array(
				'post_type'				=> 'post',
				'posts_per_page'		=> 1,
				'post__in'				=> get_option( 'sticky_posts' ),
				'ignore_sticky_posts'	=> 1
			);

			$loop = new WP_Query( $args );

			if ( $loop->have_posts() ) :
				?>

				<div class="xgouter-wrap">
					
					<?php
					if ( have_posts() ) :
						while ( $loop->have_posts() ) : $loop->the_post();
							?>
								
								<div class="intro-wel" <?php if ( get_theme_mod('kouprey_home_banner_bg') ) : ?>style="background-image: url(<?php echo esc_url( get_theme_mod('kouprey_home_banner_bg' ) ) ?>);"<?php endif; ?>>
									<div class="xginner content-wrap">
										
										<?php if ( has_post_thumbnail() ) : ?>
											<div class="xginner-left">
												<?php the_post_thumbnail('full'); ?>
											</div>
										<?php endif; ?>

										<div class="xginner-right">
											<h2 class="baner-header"><?php the_title(); ?></h2>
											<p class="sub-baner-header"><?php the_excerpt(); ?></p>
											<span class="super-btn">
												<a id="popup-subscribe" class="btn-view" href="<?php the_permalink(); ?>"><?php echo esc_html( get_theme_mod('kouprey_button_label_one', __('Know More', 'kouprey') ) ) ?></a>
												<a id="popup-subscribe" class="popup-subscribe btn-sign" href="<?php echo esc_url( get_theme_mod('kouprey_button_url_two', 'http://' ) ) ?>"><?php echo esc_html( get_theme_mod('kouprey_button_label_two', __('Sign up Now', 'kouprey') ) ) ?></a>
											</span>
										</div>
										
									</div>
								</div><!-- .intro-wel -->

							<?php
						endwhile; 
					endif;
					?>

					<?php wp_reset_postdata(); ?>

				</div>

			<?php
			endif;
		endif;
	endif;
	?>

	<div id="content" class="site-content clearfix">
		<div class="content-wrap">