<?php
/**
 * kouprey functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Kouprey
 */

define( 'KOUPREY_THEME_NAME', 'kouprey' );
define( 'KOUPREY_THEME_VERSION', '1.1.4' );
define( 'KOUPREY_PRO_URL', 'http://opensumo.com/kouprey/' );

if ( ! function_exists( 'kouprey_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function kouprey_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on kouprey, use a find and replace
		 * to change 'kouprey' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'kouprey', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 300 );

		add_image_size( 'kouprey-small', 350 , 230, true );
		add_image_size( 'kouprey-large', 750 , 350, true );
		add_image_size( 'kouprey-widget', 86 , 60, true );


		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1'	=> esc_html__( 'Primary', 'kouprey' ),
			'menu-2'	=> esc_html__( 'Footer', 'kouprey' )
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'kouprey_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		// This theme styles the visual editor to resemble the theme style.
		$google_font_url = str_replace( ',', '%2C', 'https://fonts.googleapis.com/css?family=PT+Sans:400,700|Source+Sans+Pro:600,700,900' );
		add_editor_style( array( 'css/editor-style.css', $google_font_url ) );

	}
endif;
add_action( 'after_setup_theme', 'kouprey_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function kouprey_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'kouprey_content_width', 640 );
}
add_action( 'after_setup_theme', 'kouprey_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function kouprey_widgets_init() {
	register_sidebar( array(
		'name'				=> esc_html__( 'Sidebar', 'kouprey' ),
		'id'				=> 'sidebar-1',
		'description'		=> esc_html__( 'Add widgets here.', 'kouprey' ),
		'before_widget'		=> '<section id="%1$s" class="fbox widget %2$s"><div class="swidget-inner">',
		'after_widget'		=> '</div></section>',
		'before_title'		=> '<div class="swidget"><h3 class="widget-title">',
		'after_title'		=> '</h3></div>',
	) );
	register_sidebar( array(
		'name'				=> esc_html__( 'Under Menu Ad', 'kouprey' ),
		'id'				=> 'sidebar-2',
		'description'		=> esc_html__( 'Add widgets here.', 'kouprey' ),
		'before_widget'		=> '<div id="%1$s" class="banner-widget %2$s">',
		'after_widget'		=> '</div>',
		'before_title'		=> '<div class="swidget"><h3 class="widget-title">',
		'after_title'		=> '</h3></div>',
	) );
}
add_action( 'widgets_init', 'kouprey_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function kouprey_scripts() {
	wp_enqueue_style( 'kouprey-font-google', 'https://fonts.googleapis.com/css?family=PT+Sans:400,700,700|Source+Sans+Pro:600,700,900' );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/all.css' );
	wp_enqueue_style( 'kouprey-style', get_stylesheet_uri() );

	wp_enqueue_script( 'kouprey-navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'kouprey-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '1.1', true );
	wp_enqueue_script( 'kouprey-script', get_template_directory_uri() . '/js/script.js', array(), '1.1', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'kouprey_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Widgets
 */
require get_template_directory() . '/inc/widget.php';

add_action( 'customize_register', 'kouprey_includes', 0 );

function kouprey_includes() {
	require_once( trailingslashit( get_template_directory() ) . 'inc/customizer/custom-controls/customize-control-radio-image.php' );
	require_once( trailingslashit( get_template_directory() ) . 'inc/customizer/custom-controls/control-checkbox-multiple.php' );
	require_once( trailingslashit( get_template_directory() ) . 'inc/customizer/custom-controls/css-custom-control.php' );
}

/**
* Custom Style 
*/
load_template( get_template_directory() . '/inc/options-style.php' );

