<?php

// Set the content width based on the Theme CSS
$content_width = apply_filters('kirby_content_width', '520');


// Your Changeable header business starts here 
// No CSS, just IMG call
define('HEADER_TEXTCOLOR', '');
define('HEADER_IMAGE', '%s/images/header-1.jpg'); // %s is theme dir uri
define('HEADER_IMAGE_WIDTH', apply_filters('kirby_header_image_width', '940'));
define('HEADER_IMAGE_HEIGHT', apply_filters('kirby_header_image_height', '198'));
define( 'NO_HEADER_TEXT', true );

function kirby_admin_header_style() {
?>
<style type="text/css">
#headimg {
	height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
	width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
}
#headimg h1, #headimg #desc {
	display: none;
}
</style>
<?php
}

add_custom_image_header('', 'kirby_admin_header_style');
// and thus ends the changeable header business


// Make theme available for translation
// Translations can be filed in the /languages/ directory
load_theme_textdomain( 'kirby', TEMPLATEPATH . '/languages' );

$locale = get_locale();
$locale_file = TEMPLATEPATH . "/languages/$locale.php";
if ( is_readable($locale_file) )
	require_once($locale_file);


// Get the page number
function get_page_number() {
    if (get_query_var('paged')) {
        print ' | ' . __( 'Page ' , 'kirby') . get_query_var('paged');
    }
} // end get_page_number


// For category lists on category archives: Returns other categories except the current one (redundant) -- adapted from The Sandbox
function cats_meow($glue) {
	$current_cat = single_cat_title( '', false );
	$separator = "\n";
	$cats = explode( $separator, get_the_category_list($separator) );
	foreach ( $cats as $i => $str ) {
		if ( strstr( $str, ">$current_cat<" ) ) {
			unset($cats[$i]);
			break;
		}
	}
	if ( empty($cats) )
		return false;

	return trim(join( $glue, $cats ));
} // end cats_meow


// For tag lists on tag archives: Returns other tags except the current one (redundant) -- adapted from The Sandbox
function tag_ur_it($glue) {
	$current_tag = single_tag_title( '', '',  false );
	$separator = "\n";
	$tags = explode( $separator, get_the_tag_list( "", "$separator", "" ) );
	foreach ( $tags as $i => $str ) {
		if ( strstr( $str, ">$current_tag<" ) ) {
			unset($tags[$i]);
			break;
		}
	}
	if ( empty($tags) )
		return false;

	return trim(join( $glue, $tags ));
} // end tag_ur_it


// Register widgetized areas
function theme_widgets_init() {
	// Area 1
	register_sidebar( array (
		'name' => 'Primary Widget Area',
		'id' => 'primary-widget-area',
		'description' => __('The primary widget area' , 'kirby'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => "</li>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Area 2
	register_sidebar( array (
		'name' => 'Secondary Widget Area',
		'id' => 'secondary-widget-area', 
		'description' => __('The secondary widget area' , 'kirby'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => "</li>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Area 3
	register_sidebar( array (
		'name' => 'First Footer Widget Area',
		'id' => 'first-footer-widget-area', 
		'description' => __('The first footer widget area' , 'kirby'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => "</li>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );  

	// Area 4
	register_sidebar( array (
		'name' => 'Second Footer Widget Area',
		'id' => 'second-footer-widget-area', 
		'description' => __('The second footer widget area' , 'kirby'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => "</li>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );  

	// Area 5
	register_sidebar( array (
		'name' => 'Third Footer Widget Area',
		'id' => 'third-footer-widget-area', 
		'description' => __('The third footer widget area' , 'kirby'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => "</li>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );  

	// Area 6
	register_sidebar( array (
		'name' => 'Fourth Footer Widget Area',
		'id' => 'fourth-footer-widget-area', 
		'description' => __('The fourth footer widget area' , 'kirby'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => "</li>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );  
  
} // end theme_widgets_init


// Add all the groovy widget areas
add_action( 'init', 'theme_widgets_init' );


// Kirby Theme Settings
// It'd be nice if this was simpler--but it's not
// I guess it could be since it's only one option -- I'll have to do that I guess
// Theme options adapted from "A Theme Tip For WordPress Theme Authors"
// http://literalbarrage.org/blog/archives/2007/05/03/a-theme-tip-for-wordpress-theme-authors/

$themename = "Kirby";
$shortname = "kt";

// Create theme options

$options = array (

				array(	"name" => __('Text in Footer','kirby'),
						"desc" => __("You can use the following shortcodes in your footer text: [wp-link] [theme-link] [loginout-link] [blog-title] [blog-link] [the-year]",'kirby'),
						"id" => $shortname."_footertext",
						"std" => __("[blog-link] uses the [theme-link] by [designer-link].", 'kirby'),
						"type" => "textarea",
						"options" => array(	"rows" => "5",
											"cols" => "94") ),

		);

function mytheme_add_admin() {

    global $themename, $shortname, $options;

    if ( $_GET['page'] == basename(__FILE__) ) {
    
        if ( 'save' == $_REQUEST['action'] ) {

                foreach ($options as $value) {
                    update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

                foreach ($options as $value) {
                    if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }

                header("Location: themes.php?page=functions.php&saved=true");
                die;

        } else if( 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
                delete_option( $value['id'] ); }

            header("Location: themes.php?page=functions.php&reset=true");
            die;

        }
 	}

    add_theme_page($themename." Settings", $themename." Settings", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}

function mytheme_admin() {

    global $themename, $shortname, $options;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' '.__('settings saved.','kirby').'</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' '.__('settings reset.','kirby').'</strong></p></div>';
    if ( $_REQUEST['resetwidgets'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' '.__('widgets reset.','kirby').'</strong></p></div>';
    if ( $_REQUEST['createdefinitions'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' '.__('definitions created.','kirby').'</strong></p></div>';
    if ( $_REQUEST['directoryfailed'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' '.__('failed to create directory:','kirby').' '.STYLESHEETPATH . '/settings/'.'</strong></p></div>';
    if ( $_REQUEST['filefailed'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' '.__('failed to create the file:','kirby').' '.STYLESHEETPATH . '/settings/settings.php'.'</strong></p></div>';
    
?>
<div class="wrap">
<?php screen_icon(); ?>
<h2><?php echo $themename; ?> Settings</h2>

<form method="post" action="">

	<table class="form-table">

<?php foreach ($options as $value) { 
	
	switch ( $value['type'] ) {
		case 'text':
		?>
		<tr valign="top"> 
			<th scope="row"><label for="<?php echo $value['id']; ?>"><?php echo __($value['name'],'kirby'); ?></label></th>
			<td>
				<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo get_option( $value['id'] ); } else { echo $value['std']; } ?>" />
				<?php echo __($value['desc'],'kirby'); ?>

			</td>
		</tr>
		<?php
		break;
		
		case 'select':
		?>
		<tr valign="top">
			<th scope="row"><label for="<?php echo $value['id']; ?>"><?php echo __($value['name'],'kirby'); ?></label></th>
				<td>
					<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
					<?php foreach ($value['options'] as $option) { ?>
					<option<?php if ( get_option( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
					<?php } ?>
				</select>
			</td>
		</tr>
		<?php
		break;
		
		case 'textarea':
		$ta_options = $value['options'];
		?>
		<tr valign="top"> 
			<th scope="row"><label for="<?php echo $value['id']; ?>"><?php echo __($value['name'],'kirby'); ?></label></th>
			<td><textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="<?php echo $ta_options['cols']; ?>" rows="<?php echo $ta_options['rows']; ?>"><?php 
				if( get_option($value['id']) != "") {
						echo __(stripslashes(get_option($value['id'])),'kirby');
					}else{
						echo __($value['std'],'kirby');
				}?></textarea><br /><?php echo __($value['desc'],'kirby'); ?></td>
		</tr>
		<?php
		break;

		case 'radio':
		?>
		<tr valign="top"> 
			<th scope="row"><?php echo __($value['name'],'kirby'); ?></th>
			<td>
				<?php foreach ($value['options'] as $key=>$option) { 
				$radio_setting = get_option($value['id']);
				if($radio_setting != ''){
					if ($key == get_option($value['id']) ) {
						$checked = "checked=\"checked\"";
						} else {
							$checked = "";
						}
				}else{
					if($key == $value['std']){
						$checked = "checked=\"checked\"";
					}else{
						$checked = "";
					}
				}?>
				<input type="radio" name="<?php echo $value['id']; ?>" id="<?php echo $value['id'] . $key; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><label for="<?php echo $value['id'] . $key; ?>"><?php echo $option; ?></label><br />
				<?php } ?>
			</td>
		</tr>
		<?php
		break;
		
		case 'checkbox':
		?>
		<tr valign="top"> 
			<th scope="row"><?php echo __($value['name'],'kirby'); ?></th>
			<td>
				<?php
					if(get_option($value['id'])){
						$checked = "checked=\"checked\"";
					}else{
						$checked = "";
					}
				?>
				<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
				<label for="<?php echo $value['id']; ?>"><?php echo __($value['desc'],'kirby'); ?></label>
			</td>
		</tr>
		<?php
		break;

		default:

		break;
	}
}
?>

	</table>

	<p class="submit">
		<input name="save" type="submit" class="button-primary" value="<?php _e('Update Settings','kirby'); ?>" />    
		<input type="hidden" name="action" value="save" />
	</p>
</form>
<form method="post" action="">
	<p class="submit">
		<input name="reset" type="submit" value="<?php _e('Reset','kirby'); ?>" />
		<input type="hidden" name="action" value="reset" />
	</p>
</form>
</div>
<?php
}

add_action('admin_menu' , 'mytheme_add_admin'); 


// Kirby Shortcodes -- adapted from Thematic
function kirby_wp_link() {
    return '<a class="wp-link" href="http://WordPress.org/" title="Semantic Personal Publishing Platform" rel="generator">WordPress</a>';
}
add_shortcode('wp-link', 'kirby_wp_link');		  
		  
function kirby_theme_link() {
    $themelink = '<a class="theme-link" href="http://themeshaper.com/kirby/" title="The Kirby Theme for WordPress" rel="designer">Kirby Theme</a>';
    return apply_filters('kirby_theme_link_filter',$themelink);
}
add_shortcode('theme-link', 'kirby_theme_link');	

function kirby_designer_link() {
    $themelink = '<a class="designer-link" href="http://themeshaper.com/" title="ThemeShaper" rel="designer">Ian Stewart</a>';
    return apply_filters('kirby_designer_link_filter',$themelink);
}
add_shortcode('designer-link', 'kirby_designer_link');	

function kirby_login_link() {
    if ( ! is_user_logged_in() )
        $link = '<a href="' . get_option('siteurl') . '/wp-login.php">' . __('Login','kirby') . '</a>';
    else
    $link = '<a href="' . wp_logout_url($redirect) . '">' . __('Logout','kirby') . '</a>';
    return apply_filters('loginout', $link);
}
add_shortcode('loginout-link', 'kirby_login_link');		  	  

function kirby_blog_title() {
	return '<span class="blog-title">' . get_option('blogname') . '</span>';
}
add_shortcode('blog-title', 'kirby_blog_title');

function kirby_blog_link() {
	return '<a href="' . get_option('siteurl') . '" title="' . get_option('blogname') . '" >' . get_option('blogname') . "</a>";
}
add_shortcode('blog-link', 'kirby_blog_link');

function kirby_year() {   
    return '<span class="the-year">' . date('Y') . '</span>';
}
add_shortcode('the-year', 'kirby_year');

// Kirby Footer Text
function kirby_footer_text() {
	global $options;
	foreach ($options as $value) {
	    if (get_settings( $value['id'] ) === FALSE) { $$value['id'] = $value['std']; } else { $$value['id'] = get_settings( $value['id'] ); }
	}
	echo do_shortcode(__(stripslashes($kt_footertext), 'kirby'));
}

