<?php
/**
 * kimono functions and definitions
 *
 * @package kimono
 */
/**
 * Custom template tags for this theme.
 */
require( get_template_directory() . '/inc/template-tags.php' );

/**
 * Custom functions that act independently of the theme templates
 */
require( get_template_directory() . '/inc/extras.php' );

/**
 * Customizer additions
 */
require( get_template_directory() . '/inc/customizer.php' );


/*
 * Load Jetpack compatibility file.
 */
require( get_template_directory() . '/inc/jetpack.php' );

if ( ! function_exists( 'kimono_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function kimono_setup() {

/**
 * Set the content width based on the theme's design and stylesheet.
 */
global $content_width;
if ( ! isset( $content_width ) )
	$content_width = 700; /* pixels */

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on kimono, use a find and replace
	 */
	load_theme_textdomain( 'kimono', get_template_directory() . '/languages' );

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	/**
	 * Enable support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );
	add_theme_support('custom-background', array('default-color' => 'f1f1f1'));
	set_post_thumbnail_size( 320, 230, true );
}
endif; // kimono_setup
add_action( 'after_setup_theme', 'kimono_setup' );

/**
 * Setup the WordPress core custom background feature.
 *
 * Use add_theme_support to register support for WordPress 3.4+
 * as well as provide backward compatibility for WordPress 3.3
 * using feature detection of wp_get_theme() which was introduced
 * in WordPress 3.4.
 *
 * @todo Remove the 3.3 support when WordPress 3.6 is released.
 *
 * Hooks into the after_setup_theme action.
 */


/**
 * Register widgetized area and update sidebar with default widgets
 */
function kimono_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'kimono' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}

add_action( 'widgets_init', 'kimono_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function kimono_scripts() {

	wp_enqueue_style( 'kimono-style', get_stylesheet_uri() );
	wp_enqueue_style( 'bxslider-style', get_template_directory_uri() . '/css/jquery.bxslider.css' );
	wp_enqueue_script( 'bxslider', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array('jquery'), '' );
	wp_enqueue_script( 'ah-placeholder', get_template_directory_uri() . '/js/jquery.ah-placeholder.js', array(), '' );
	wp_enqueue_script( 'kimono-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array() );

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'kimono-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
	}

	wp_enqueue_script(
	'kimono_function',
	get_template_directory_uri() . '/js/cs.js',
	array('jquery')
);


}
add_action( 'wp_enqueue_scripts', 'kimono_scripts' );

function kimono_new_excerpt_mblength($length) {
	 return 180;
}
add_filter('excerpt_length', 'kimono_new_excerpt_mblength');

function kimono_new_excerpt_more($post) {

	return ' ...<a class="readmore" href="'. esc_url( get_permalink() ) . '">' . 'read more' . '</a>';
}
add_filter('excerpt_more', 'kimono_new_excerpt_more');

add_filter( "comment_form_defaults", "kimono_my_comment_notes_after");

function kimono_my_comment_notes_after($defaults){
  $defaults['comment_notes_after'] = '';
  return $defaults;
}



add_action('admin_print_styles', 'kimono_my_admin_print_styles');
function kimono_my_admin_print_styles() {
  wp_enqueue_style( 'farbtastic' );
}
add_action('admin_enqueue_scripts', 'kimono_my_admin_enqueue_scripts');
function kimono_my_admin_enqueue_scripts() {
  wp_enqueue_script( 'farbtastic' );
  wp_enqueue_script( 'quicktags' );
  wp_enqueue_script( 'my-admin-script', get_stylesheet_directory_uri() . '/admin-script.js', array( 'farbtastic', 'quicktags' ), false, true );
}



// kimono_fc_settings_page() displays the page content for the Header and Footer Commander submenu
function kimono_fc_settings_page() {

	//must check that the user has the required capability
	if (!current_user_can('edit_theme_options')) {

	}

	//checks to see if empty then populates values


	// See if the user has posted us some information
	// If they did, this hidden field will be set to 'Y'

	if( isset($_POST[ $hidden_field_name ]) && $_POST[ $hidden_field_name ] == 'Y' ) {

}
?>

</form>
<?php }


function kimono_paginate() {
	global $wp_query;

	$big = 999999999;

	// http://codex.wordpress.org/Function_Reference/paginate_links
	$paginate_links = paginate_links( array(
		'base' => str_replace( $big, '%#%', get_pagenum_link($big) ),
		'current' => max( 1, get_query_var('paged') ),
		'total' => $wp_query->max_num_pages,
		'mid_size' => 5
	) );

	if ( $paginate_links ) {
		echo '<div class="pagination">';
		echo $paginate_links;
		echo '</div><!--// end .pagination -->';
	}
}

function kimono_scriptsMore(){
	// wp_enqueue_script('jquery');
	// wp_enqueue_script( 'script', get_stylesheet_directory_uri() . '/js/more.js' );
}
add_action( 'admin_enqueue_scripts', 'kimono_scriptsMore' );

add_action('appearance_page_more', 'regist_more_css');
function regist_more_css() { ?>
<link rel='stylesheet' id='kimono_style-css' href='<?php echo get_stylesheet_directory_uri() .'/css/more.css' ?>' type='text/css' media='all' /><?php }

//More
function kimono_menu_more() {
	$siteurl = get_option( 'siteurl' );
?>
<div class="moreWrap">
	<h2>
		<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/head_title.png" alt="Internet For Everyone Z.com by GMO" >
	</h2>

	<div class="more_navigation">
		<ul>
			<li><a href="#hosting">WordPress Hosting</a></li>
			<li><a href="#themes">Themes</a></li>
			<li><a href="#plugins">Plugins</a></li>
		</ul>
	</div>

	<a id="hosting" name="hosting"></a>
	<div class="more_contents">

		<h3>Z.com WordPress Hosting</h3>
		<div class="hosting">
			<a href="https://cloud.z.com/jp/en/wp/?utm_source=themes&utm_medium=aboutz&utm_campaign=themes_aboutz" target="_blank">
				<p class="title">Reason for smooth WordPress Experience</p>
				<p>
					You don’t have to care about Speeding up, security and updates, because “Z.com WordPress Hosting” is optimized for WordPress.<br>
					The structure designing for exclusive use of WordPress with high-speed SSD supports WordPress specific mechanism that depends on the database. You can enjoy seamless operation which cannot be provided with the regular HDD.<br>
					Z.com WordPress Hosting features safe and seamless WordPress site building experience to let you focus on site contents and updating.
				</p>
				<p class="btn">View More</p>
			</a>
		</div>

		<a id="themes" name="themes"></a>
		<h3>Z.com WordPress Themes</h3>
		<div class="block-themes">
			<ul class="list-themes">
				<li class="items list1">
					<div class="box-inner">
						<h4 class="titles">waffle</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_waffle.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://waffle.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="https://wordpress.org/themes/waffle" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							waffle is child theme of twenty fifteen base functionality is took over parent has and additional features are installed especially background color and text color on sidebar.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
				<li class="items list2">
					<div class="box-inner">
						<h4 class="titles">Tidy</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_tidy.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://tidy.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="https://wordpress.org/themes/tidy" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							Tidy - The multi-purpose WordPress theme with ultimate simplicity. The theme is fully customizable, responsive and flexible with full of revolutionary functions. Contents can turned on and off as desired, and a wide variety of layout options to help you build a satisfactory website.<br>
							The theme comes standard with the original slider, social media integration, Google advertisement & stats plugins along with the web font support with full color customization for enhanced flexibility.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
				<li class="items list3">
					<div class="box-inner">
						<h4 class="titles">Madeini</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_madeini.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://madeini.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="http://wordpress.org/themes/madeini" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							Madeini is an upgraded version of Twenty-Fourteen WordPress default theme with enhanced custom color and custom background image feature.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
				<li class="items list4">
					<div class="box-inner">
						<h4 class="titles">Kimono</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_kimono.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://kimono.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="http://wordpress.org/themes/kimono" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							Kimono is a simple, and user friendly WordPress theme. Beautiful design inspiration comes from Japanese traditional garment called Kimono.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
				<li class="items list5">
					<div class="box-inner">
						<h4 class="titles">Kotenhanagara</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_kotenhanagara.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://kotenhanagara.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="http://wordpress.org/themes/kotenhanagara" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							Kotenhanagara is a simple, easy-to-use, and highly customizable WordPress theme. Beautiful Japanese design inspiration comes from Urushi coating which is lacquerware decorated and varnished in the Japanese manner.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
				<li class="items list6">
					<div class="box-inner">
						<h4 class="titles">de naani.</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_denaani.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://denaani.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="https://wordpress.org/themes/de-naani" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							'de naani' is an upgraded version of Twenty-Twelve default theme which is designed to work perfectly with 'GMO Show Time' slider plugin and 'GMO Font agent'web font plugin. This theme also allow you to insert logo, and change site title/tagline positions.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
				<li class="items list7">
					<div class="box-inner">
						<h4 class="titles">Azabu Juban</h4>
						<div class="box-links">
							<p class="thumbs"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/themes_azabujuban.jpg" alt=""></p>
							<ul class="list-themes-links" tabindex="0">
								<li class="link-demo"><a href="http://azabujuban.webstarterz.com/" target="_blank" class="btn">Demo</a></li>
								<li class="link-download"><a href="http://wordpress.org/themes/azabu-juban" target="_blank" class="btn">Download</a></li>
							</ul><!-- .list-themes-links -->
						</div><!-- .box-links -->
						<div class="contents">
							Azabu-Juban is a simple, easy-to-use, and highly customizable WordPress theme. Beautiful Japanese design inspiration comes from Urushi coating which is lacquerware decorated and varnished in the Japanese manner.
						</div><!-- .contents -->
					</div><!-- .box-inner -->
				</li><!-- .items -->
			</ul><!-- .list-themes -->
		</div><!-- .block-themes -->



		<a id="plugins" name="plugins"></a>
		<h3>Z.com WordPress Plugins</h3>

		<div class="plugins">

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_showtime.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-showtime/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Showtime</h4>
					<p>GMO Showtime slider plugin gives cool effects to the slider in a snap. The control screen is simple, for anyone to easily use. Express user's originality with fully customizable link and color as well as 16 slider effects in 6 different layouts.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_font_agent.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-font-agent/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Font Agent</h4>
					<p>GMO Font Agent plugin works with Google fonts, gives you a choice to use variety of stylish web fonts. The plugin is genericon and IcoMoon compatible, to enhance its usability. Icons can be inserted from the post editor.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_sahre_connection.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-share-connection/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Share Connection</h4>
					<p>GMO Share Connection plugin is designed for easy social sharing by letting user choose place/pages to use icons. 9 social network services are supported in this plugin including Facebook and Twitter.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_ads_master.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-ads-master/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Ads Master</h4>
					<p>GMO Ads Master is the ad banner plugin which enables you to place ad contents to the desired locations such as inside article, sidebar and footer. In addition to that, using this plugin let you setup Google Analytics tracking code and sitemap tool settings, and sitemap can be easily generated without playing with PHP files.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_go_to_top.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-go-to-top/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Go to Top</h4>
					<p>GMO Go to Top is a simple plugin adds a simple button which allows users to scroll all the way up to the top by 1-click. Button color, style, position can be modified or you can also upload your own button image.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_page_trasitions.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-page-transitions/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Page Transitions</h4>
					<p>GMO Page Transitions adds Page Transitions actions to your site. Click on the link, and page will slide over to left or right. This effect will not apply when "target=_brank" is used.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_tinymce_smiley.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-tinymce-smiley/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO TinyMCE Smiley</h4>
					<p>GMO TinyMCE Smiley is a plugin to let you instantly add smilies into your site from the toolbar..</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_google_map.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-google-map/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Google Map</h4>
					<p>With "GMO Google Map" plugin, you can use Google Maps on your website by simply embedding a shortcode in anywhere you desire. No special coding skill is required. Simply enter information (eg. address) to create a shortcode and paste it to complete.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_showtime.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-widget-custom/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Widget Custom</h4>
					<p>This is a useful widget customizer plugin which enables you to insert images, ad and recommendation banners.</p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_slider.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-slider/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Slider</h4>
					<p>GMO Slider plugin let you insert sliders in posts and pages. The control screen is simple, for anyone to easily use. GMO Slider supports images as well as text and video. </p>
				</div>
			</div>

			<div class="plugins_detail">
				<div class="plugins_detail_l">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/ico_plugin_social_connection.gif">
					<p class="link"><a href="https://wordpress.org/plugins/gmo-social-connection/" class="btn" target="_blank">Download</a></p>
				</div>
				<div class="plugins_detail_r">
					<h4>GMO Social Connection</h4>
					<p>GMO Social Connection let you easily place SNS share buttons on the articles. It also allows you to choose button position from top or bottom. Supported SNS are Facebook, Twitter and Google+.</p>
				</div>
			</div>


		</div>

	</div>


	<div class="quality">
		<h3>Quality Service</h3>
		<p class="lead">“Brought to you by Japan's leading one-stop provider of Internet services”</p>
		<p><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/more/footer_logo_gmo.png" alt="GMO INTERNET GROUP" ></p>
		<p>Z.com WordPress Hosting is operated by GMO Internet group, the number one provider of domain registration, web hosting, security, ecommerce and payment processing solutions in Japan.Under the corporate slogan "Internet for Everyone", GMO Internet Group's trusted service brand represents industry expertise, a proven track record and quality service.</p>
		<p><a href="http://www.gmo.jp/en/" target="_blank">> Visit GMO Internet Group</a></p>
	</div>

</div>

<?php
}
function kimono_admin_menu() {
	add_theme_page( 'Z.com WordPress Hosting', 'More', 'read','more', 'kimono_menu_more' );
}

add_action( 'admin_menu', 'kimono_admin_menu' );

//Dashboard
function kimono_dashboard_widget_function() {
?>
<a href="https://cloud.z.com/jp/en/wp/?utm_source=themes&utm_medium=dashboard&utm_campaign=themes_dashboard" target="_blank"><img src="<?php echo get_stylesheet_directory_uri() .'/images/zcom_wordpress_hosting.gif' ?>" style="width:100%"></a>
<?php
}
function kimono_add_dashboard_widgets() {
wp_add_dashboard_widget('kimono_dashboard_widget', 'Z.com WordPress Hosting', 'kimono_dashboard_widget_function');
global $wp_meta_boxes;
$normal_dashboard = $wp_meta_boxes['dashboard']['normal']['core'];
$example_widget_backup = array('kimono_dashboard_widget' => $normal_dashboard['kimono_dashboard_widget']);
unset($normal_dashboard['kimono_dashboard_widget']);
$sorted_dashboard = array_merge($example_widget_backup, $normal_dashboard);
$wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
}
add_action('wp_dashboard_setup', 'kimono_add_dashboard_widgets' );
?>
