<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( ! function_exists( 'kiducation_lite_enqueue_styles' ) ) :
    /**
     * Load assets.
     *
     * @since 1.0.0
     */
    function kiducation_lite_enqueue_styles() {
        wp_enqueue_style( 'kiducation-style-parent', get_template_directory_uri() . '/style.css' );
        wp_enqueue_style( 'kiducation-lite-style', get_stylesheet_directory_uri() . '/style.css', array( 'kiducation-style-parent' ), '1.0.0' );
    }
endif;
add_action( 'wp_enqueue_scripts', 'kiducation_lite_enqueue_styles', 99 );

// END ENQUEUE PARENT ACTION
if ( ! function_exists( 'kiducation_lite_fonts_url' ) ) :

    function kiducation_lite_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = 'latin,latin-ext';

    /* translators: If there are characters in your language that are not supported by Kaushan Script, translate this to 'off'. Do not translate into your own language. */
    if ( 'off' !== _x( 'on', 'Kaushan Script font: on or off', 'kiducation-lite' ) ) {
        $fonts[] = 'Kaushan Script:300,400,500,600,700';
    }

    /* translators: If there are characters in your language that are not supported by Redressed, translate this to 'off'. Do not translate into your own language. */
    if ( 'off' !== _x( 'on', 'Redressed: on or off', 'kiducation-lite' ) ) {
        $fonts[] = 'Redressed';
    }

    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $fonts ) ),
            'subset' => urlencode( $subsets ),
        ), 'https://fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
}
endif;

if ( ! function_exists( 'kiducation_lite_get_default_theme_options' ) ) :

    /**
     * Get default theme options.
     *
     * @since 1.0.0
     *
     * @return array Default theme options.
     */
function kiducation_lite_get_default_theme_options() {

    $theme_data = wp_get_theme();
    $defaults = array();


    $defaults['disable_homepage_content_section'] = true;

    // Featured Slider Section
    $defaults['disable_featured-slider_section']    = false;
    $defaults['number_of_slider_items']             = 3;

    //About Section 
    $defaults['disable_about_section']      = false;
    $defaults['about_btn_text']             = esc_html__( 'Read More', 'kiducation-lite' );


    // Our Service Section
    $defaults['disable_services_section']   = false;
    $defaults['service_title']              = esc_html__( 'We Offer Premium Child Care', 'kiducation-lite' );
    $defaults['number_of_service_column']   = 3;
    $defaults['number_of_service_items']    = 3;


    // Featured Section
    $defaults['disable_course_section'] = false;
    $defaults['course_title']               = esc_html__( 'Our Course', 'kiducation-lite' );

    // Testimonial Section
    $defaults['disable_testimonial_section']    = false;
    $defaults['testimonial_title']              = esc_html__( 'Happy Parents', 'kiducation-lite' );
    $defaults['number_of_testimonial_items']    = 4;

    //Cta Section   
    $defaults['disable_cta_section']        = false;
    $defaults['background_cta_section']     = get_template_directory_uri() .'/assets/images/default-header.jpg';
    $defaults['cta_button_label']           = esc_html__( 'Purchase Now', 'kiducation-lite' );
    $defaults['cta_button_url']             = '#';
    $defaults['cta_alt_button_label']       = esc_html__( 'Contact Us', 'kiducation-lite' );
    $defaults['cta_alt_button_url']         = '#';
    $defaults['cta_content_type']           = 'cta_post';


    // Blog Section
    $defaults['disable_blog_section']       = false;
    $defaults['blog_title']                 = esc_html__( 'Latest Post', 'kiducation-lite' ); 
    $defaults['blog_number']                = 3;
    $defaults['number_of_blog_column']      = 3;


    //General Section
    $defaults['blog_readmore_text']             = esc_html__('Read More','kiducation-lite');
    $defaults['excerpt_length']             = 40;
    $defaults['layout_options_blog']            = 'no-sidebar';
    $defaults['layout_options_archive']         = 'right-sidebar';
    $defaults['layout_options_page']            = 'right-sidebar';  
    $defaults['layout_options_single']          = 'right-sidebar';  


    //Footer section        
    $defaults['copyright_text']             = esc_html__( 'Copyright &copy; All rights reserved.', 'kiducation' );


    return $defaults;
}
endif;
add_filter( 'kiducation_filter_default_theme_options', 'kiducation_lite_get_default_theme_options', 99 );


