<?php
/**
 * Title: Bento Grid
 * Slug: kentwood/bento
 * Categories: featured, call-to-action
 */

declare( strict_types = 1 );
?>

<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide">
	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|40"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column {"width":"32.90938%"} -->
		<div class="wp-block-column" style="flex-basis:32.90938%">
			<!-- wp:cover {"url":"<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/4249179026_1c11793d55_k-cropped.jpg","dimRatio":40,"isUserOverlayColor":true,"focalPoint":{"x":0.25,"y":0.2},"minHeight":100,"minHeightUnit":"%","customGradient":"linear-gradient(180deg,rgba(0,0,0,0) 0%,rgb(0,0,0) 76%)","contentPosition":"bottom center","style":{"layout":{"selfStretch":"fill","flexSize":null},"border":{"radius":"28px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}}},"textColor":"base"} -->
			<div class="wp-block-cover has-custom-content-position is-position-bottom-center has-base-color has-text-color has-link-color" style="border-radius:28px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60);min-height:100%"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-40 has-background-dim wp-block-cover__gradient-background has-background-gradient" style="background:linear-gradient(180deg,rgba(0,0,0,0) 0%,rgb(0,0,0) 76%)"></span><img class="wp-block-cover__image-background" alt="<?php echo esc_attr_e( 'A smiling woman wearing a suit.', 'kentwood' ); ?>" src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/4249179026_1c11793d55_k-cropped.jpg" style="object-position:25% 20%" data-object-fit="cover" data-object-position="25% 20%"/>
				<div class="wp-block-cover__inner-container">
					<!-- wp:heading {"textAlign":"left","fontSize":"x-large"} -->
					<h2 class="wp-block-heading has-text-align-left has-x-large-font-size"><?php echo esc_html__( 'Welcome from the Headteacher', 'kentwood' ); ?></h2>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size"><?php echo esc_html__( 'At Kentwood Academy, our guiding principle is ‘Aim High, Be Kind, and Dare to be Different’. This motto, deeply rooted at our core, combined with exceptional teaching sets us apart.', 'kentwood' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button {"textColor":"base","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"className":"is-style-fill"} -->
						<div class="wp-block-button is-style-fill">
							<a class="wp-block-button__link has-base-color has-text-color has-link-color wp-element-button" href="#"><?php echo esc_html__( 'Read More', 'kentwood' ); ?></a>
						</div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
			</div>
			<!-- /wp:cover -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"width":"67.09062%","style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
		<div class="wp-block-column" style="flex-basis:67.09062%">
			<!-- wp:group {"style":{"dimensions":{"minHeight":""},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"border":{"radius":"28px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"backgroundColor":"primary","textColor":"base","layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center"}} -->
			<div class="wp-block-group has-base-color has-primary-background-color has-text-color has-background has-link-color" style="border-radius:28px;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)">
				<!-- wp:heading {"fontSize":"x-large"} -->
				<h2 class="wp-block-heading has-x-large-font-size"><?php echo esc_html__( 'Arrange a Personal Visit', 'kentwood' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
				<p><?php echo esc_html__( 'Experience Kentwood Academy firsthand. Tailored to your child’s interests and admission stage, we offer visits year-round, from Nursery to Prep School.', 'kentwood' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button {"textColor":"base","style":{"border":{"width":"2px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"borderColor":"base","className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline">
						<a class="wp-block-button__link has-base-color has-text-color has-link-color has-border-color has-base-border-color wp-element-button" style="border-width:2px"><?php echo esc_html__( 'Arrange a Visit', 'kentwood' ); ?></a>
					</div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->

			<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|40"}}}} -->
			<div class="wp-block-columns">
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"border":{"radius":"28px"},"dimensions":{"minHeight":"100%"}},"backgroundColor":"primary","layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"center"}} -->
					<div class="wp-block-group has-primary-background-color has-background" style="border-radius:28px;min-height:100%">
						<!-- wp:image {"sizeSlug":"full","style":{"color":[]}} -->
						<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/school-logo.png" alt="<?php echo esc_attr_e( 'Logo of the school made up with a shield and a lion.', 'kentwood' ); ?>"/></figure>
						<!-- /wp:image -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->

				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"border":{"radius":"28px"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}}},"backgroundColor":"tertiary","textColor":"primary","layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center","justifyContent":"stretch"}} -->
					<div class="wp-block-group has-primary-color has-tertiary-background-color has-text-color has-background" style="border-radius:28px;min-height:100%;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)">
						<!-- wp:heading {"fontSize":"x-large"} -->
						<h2 class="wp-block-heading has-x-large-font-size"><?php echo esc_html__( 'Admissions', 'kentwood' ); ?></h2>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php echo esc_html__( 'Selecting the ideal educational environment for your child is a significant and profound choice.', 'kentwood' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"className":"is-style-fill"} -->
							<div class="wp-block-button is-style-fill">
								<a class="wp-block-button__link wp-element-button"><?php echo esc_html__( 'Read More', 'kentwood' ); ?></a>
							</div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|40"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column {"width":"67.09062%","style":{"spacing":{"blockGap":"var:preset|spacing|40"}}} -->
		<div class="wp-block-column" style="flex-basis:67.09062%">
			<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"}},"border":{"radius":"28px"}},"backgroundColor":"tertiary","textColor":"primary","layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center"}} -->
			<div class="wp-block-group has-primary-color has-tertiary-background-color has-text-color has-background" style="border-radius:28px;min-height:100%;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)">
				<!-- wp:heading {"fontSize":"x-large"} -->
				<h2 class="wp-block-heading has-x-large-font-size"><?php echo esc_html__( 'The Ethos and the Environment', 'kentwood' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:paragraph -->
				<p><?php echo esc_html__( 'At Kentwood Academy, our ethos goes beyond academia. We believe in nurturing the whole child, promoting resilience, creativity, and global awareness. Set against the backdrop of Kent’s natural beauty, our campus offers an environment where students are inspired daily, both by the lessons in the classroom and the serenity outside.', 'kentwood' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button -->
					<div class="wp-block-button">
						<a class="wp-block-button__link wp-element-button"><?php echo esc_html__( 'Read More', 'kentwood' ); ?></a>
					</div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"width":"32.90938%"} -->
		<div class="wp-block-column" style="flex-basis:32.90938%">
			<!-- wp:cover {"url":"<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/people-audience-young-youth-cheering-child-759682-pxhere.com-1.jpg","dimRatio":0,"minHeight":100,"minHeightUnit":"%","isDark":false,"style":{"layout":{"selfStretch":"fill","flexSize":null},"border":{"radius":"28px"}}} -->
			<div class="wp-block-cover is-light" style="border-radius:28px;min-height:100%"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background" alt="<?php echo esc_attr_e( 'Smiling small children waving their hands.', 'kentwood' ); ?>" src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/people-audience-young-youth-cheering-child-759682-pxhere.com-1.jpg" data-object-fit="cover"/>
				<div class="wp-block-cover__inner-container">
					<!-- wp:paragraph {"align":"center","fontSize":"large"} -->
					<p class="has-text-align-center has-large-font-size"></p>
					<!-- /wp:paragraph -->
				</div>
			</div>
			<!-- /wp:cover -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
