<?php
/**
 * Theme patterns
 *
 * @package Kenta Ciela
 */

if ( ! function_exists( 'kenta_ciela_block_patterns_init' ) ) {
	/**
	 * Init block patterns
	 */
	function kenta_ciela_block_patterns_init() {
		// register custom pattern category
		if ( function_exists( 'register_block_pattern_category' ) ) {
			register_block_pattern_category( 'kenta-ciela', array(
				'label' => __( 'Kenta Ciela', 'kenta-ciela' )
			) );
		}

		// register custom patterns
		if ( function_exists( 'register_block_pattern' ) ) {
			register_block_pattern(
				'kenta-ciela/hero',
				array(
					'title'      => __( 'Big Hero', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'hero' ),
					'categories' => array( 'kenta-ciela', 'featured', 'header', 'banner' )
				)
			);

			register_block_pattern(
				'kenta-ciela/page-hero',
				array(
					'title'      => __( 'Page Hero', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'page-hero' ),
					'categories' => array( 'kenta-ciela', 'featured', 'header', 'banner' )
				)
			);

			register_block_pattern(
				'kenta-ciela/counters',
				array(
					'title'      => __( 'Counters', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'counters' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns' )
				)
			);

			register_block_pattern(
				'kenta-ciela/services',
				array(
					'title'      => __( 'Services', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'services' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns' )
				)
			);

			register_block_pattern(
				'kenta-ciela/features',
				array(
					'title'      => __( 'Features', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'features' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns' )
				)
			);

			register_block_pattern(
				'kenta-ciela/section-left-media',
				array(
					'title'      => __( 'Section with left media', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'section-01' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns', 'call-to-action' )
				)
			);

			register_block_pattern(
				'kenta-ciela/section-right-media',
				array(
					'title'      => __( 'Section with right media', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'section-02' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns', 'call-to-action' )
				)
			);

			register_block_pattern(
				'kenta-ciela/works',
				array(
					'title'      => __( 'Works gallery', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'works' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns', 'gallery' )
				)
			);

			register_block_pattern(
				'kenta-ciela/introduce',
				array(
					'title'      => __( 'Introduce', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'introduce' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns', 'text' )
				)
			);

			register_block_pattern(
				'kenta-ciela/reviews',
				array(
					'title'      => __( 'Reviews', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'reviews' ),
					'categories' => array( 'kenta-ciela', 'featured', 'columns', 'text' )
				)
			);

			register_block_pattern(
				'kenta-ciela/quote',
				array(
					'title'      => __( 'Quote', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'quote' ),
					'categories' => array( 'kenta-ciela', 'featured', 'text' )
				)
			);

			register_block_pattern(
				'kenta-ciela/faq',
				array(
					'title'      => __( 'Frequent Asked Questions', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'faq' ),
					'categories' => array( 'kenta-ciela', 'featured', 'text' )
				)
			);

			register_block_pattern(
				'kenta-ciela/contact-us',
				array(
					'title'      => __( 'Contact Us', 'kenta-ciela' ),
					'content'    => kenta_ciela_pattern_markup( 'contact-us' ),
					'categories' => array( 'kenta-ciela', 'featured', 'text', 'columns' )
				)
			);
		}
	}
}
add_action( 'init', 'kenta_ciela_block_patterns_init' );
