<?php
/**
 * Theme functions
 *
 * @package Kenta Ciela
 */

// don't call the file directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'KENTA_CIELA_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'KENTA_CIELA_VERSION', '1.0.0' );
}

if ( ! defined( 'KENTA_CIELA_PATH' ) ) {
	define( 'KENTA_CIELA_PATH', trailingslashit( get_stylesheet_directory() ) );
}

if ( ! defined( 'KENTA_CIELA_URL' ) ) {
	define( 'KENTA_CIELA_URL', trailingslashit( get_stylesheet_directory_uri() ) );
}

if ( ! defined( 'KENTA_CIELA_ASSETS_URL' ) ) {
	define( 'KENTA_CIELA_ASSETS_URL', KENTA_CIELA_URL . 'assets/' );
}

// Helper functions
require_once KENTA_CIELA_PATH . 'helpers.php';
// Customizer settings hook
require_once KENTA_CIELA_PATH . 'setup.php';
// Theme patterns
require_once KENTA_CIELA_PATH . 'patterns.php';
// Customizer settings hook
require_once KENTA_CIELA_PATH . 'customizer.php';
