<?php
/**
 * Customizer settings default value
 *
 * @package Kenta Ciela
 */

if ( ! function_exists( 'kenta_ciela_return_yes' ) ) {
	function kenta_ciela_return_yes() {
		return 'yes';
	}
}

if ( ! function_exists( 'kenta_ciela_return_no' ) ) {
	function kenta_ciela_return_no() {
		return 'no';
	}
}

// Disable site wrap by default
add_filter( 'kenta_enable_site_wrap_default_value', 'kenta_ciela_return_no' );
// Disable customizer cache by default
add_filter( 'kenta_enable_customizer_cache_default_value', 'kenta_ciela_return_no' );
// Enable transparent header by default
add_filter( 'kenta_enable_transparent_header_default_value', 'kenta_ciela_return_yes' );
// Disable scroll reveal by default
add_filter( 'kenta_global_scroll_reveal_default_value', 'kenta_ciela_return_no' );
// Disable preloader by default
add_filter( 'kenta_global_preloader_default_value', 'kenta_ciela_return_no' );

//
// Sidebar
//
add_filter( 'kenta_post_sidebar_section_default_value', 'kenta_ciela_return_yes' );
add_filter( 'kenta_archive_sidebar_section_default_value', 'kenta_ciela_return_no' );
if ( ! function_exists( 'kenta_ciela_left_sidebar' ) ) {
	function kenta_ciela_left_sidebar() {
		return 'left-sidebar';
	}
}
add_filter( 'kenta_post_sidebar_layout_default_value', 'kenta_ciela_left_sidebar' );

//
//  Card style
//
if ( ! function_exists( 'kenta_ciela_card_preset' ) ) {
	function kenta_ciela_card_preset() {
		return 'bordered';
	}
}
add_filter( 'kenta_card_style_preset_default_value', 'kenta_ciela_card_preset' );
add_filter( 'kenta_store_card_style_preset_default_value', 'kenta_ciela_card_preset' );
add_filter( 'kenta_global_sidebar_widgets-style_default_value', 'kenta_ciela_card_preset' );

//
// Form style
//
if ( ! function_exists( 'kenta_ciela_form_style' ) ) {
	function kenta_ciela_form_style() {
		return 'modern';
	}
}
add_filter( 'kenta_content_form_style_default_value', 'kenta_ciela_form_style' );

//
// Default color preset
//

if ( ! function_exists( 'kenta_ciela_default_color_presets' ) ) {
	function kenta_ciela_default_color_presets() {
		return 'kenta-ciela';
	}
}
add_filter( 'kenta_color_palettes_default_value', 'kenta_ciela_default_color_presets' );

if ( ! function_exists( 'kenta_ciela_color_presets' ) ) {
	function kenta_ciela_color_presets( $presets ) {
		$presets['kenta-ciela'] = array(
			'kenta-primary-color'  => '#02c6f5',
			'kenta-primary-active' => '#03a9f4',
			'kenta-accent-color'   => '#181f28',
			'kenta-accent-active'  => '#334155',
			'kenta-base-300'       => '#e2e8f0',
			'kenta-base-200'       => '#f1f5f9',
			'kenta-base-100'       => '#f8fafc',
			'kenta-base-color'     => '#ffffff',
		);

		return $presets;
	}
}
add_filter( 'kenta_filter_color_presets', 'kenta_ciela_color_presets' );

//
// Dark color preset
//
if ( ! function_exists( 'kenta_ciela_dark_base_color' ) ) {
	function kenta_ciela_dark_base_color() {
		return [
			'300'     => '#2c2c2e',
			'200'     => '#1d1e20',
			'100'     => '#151519',
			'default' => '#0e0d0f',
		];
	}
}
add_filter( 'kenta_dark_base_color_default_value', 'kenta_ciela_dark_base_color' );

if ( ! function_exists( 'kenta_ciela_dark_accent_color' ) ) {
	function kenta_ciela_dark_accent_color() {
		return [
			'default' => '#ffffff',
			'active'  => '#bababa',
		];
	}
}
add_filter( 'kenta_dark_accent_color_default_value', 'kenta_ciela_dark_accent_color' );
add_filter( 'kenta_default_dark_scheme_default_value', 'kenta_ciela_return_yes' );

//
// Global typography
//
if ( ! function_exists( 'kenta_ciela_global_typography' ) ) {
	function kenta_ciela_global_typography() {
		return [
			'family'   => 'poppins',
			'fontSize' => '18px',
			'variant'  => '400',
		];
	}
}
add_filter( 'kenta_site_global_typography_default_value', 'kenta_ciela_global_typography' );

//
// Preloader
//
if ( ! function_exists( 'kenta_ciela_preloader_preset' ) ) {
	function kenta_ciela_preloader_preset() {
		return 'preset-2';
	}
}
add_filter( 'kenta_preloader_preset_default_value', 'kenta_ciela_preloader_preset' );

if ( ! function_exists( 'kenta_ciela_preloader_colors' ) ) {
	function kenta_ciela_preloader_colors() {
		return [
			'background' => '#181f28',
			'accent'     => '#ffffff',
			'primary'    => 'var(--kenta-primary-color)',
		];
	}
}
add_filter( 'kenta_preloader_colors_default_value', 'kenta_ciela_preloader_colors' );

//
// Social Networks
//
if ( ! function_exists( 'kenta_ciela_social_networks' ) ) {
	function kenta_ciela_social_networks() {
		return [
			[
				'visible'  => true,
				'settings' => [
					'color' => [ 'official' => '#557dbc' ],
					'label' => 'Facebook',
					'url'   => '',
					'share' => 'https://www.facebook.com/sharer/sharer.php?u={url}',
					'icon'  => [ 'value' => 'fab fa-facebook', 'library' => 'fa-brands' ]
				],
			],
			[
				'visible'  => true,
				'settings' => [
					'color' => [ 'official' => '#000000' ],
					'label' => 'Twitter',
					'url'   => '',
					'share' => 'https://twitter.com/share?url={url}&text={text}',
					'icon'  => [ 'value' => 'fab fa-x-twitter', 'library' => 'fa-brands' ]
				],
			],
			[
				'visible'  => true,
				'settings' => [
					'color' => [ 'official' => '#ed1376' ],
					'label' => 'Instagram',
					'url'   => '',
					'icon'  => [ 'value' => 'fab fa-instagram', 'library' => 'fa-brands' ]
				],
			],
			[
				'visible'  => true,
				'settings' => [
					'color' => [ 'official' => '#f42e53' ],
					'label' => 'Tiktok',
					'url'   => '',
					'icon'  => [ 'value' => 'fab fa-tiktok', 'library' => 'fa-brands' ]
				],
			],
		];
	}
}
add_filter( 'kenta_social_networks_default_value', 'kenta_ciela_social_networks' );

//
// Archive
//
if ( ! function_exists( 'kenta_ciela_archive_structure' ) ) {
	function kenta_ciela_archive_structure() {
		return [
			[ 'id' => 'thumbnail', 'visible' => true ],
			[ 'id' => 'categories', 'visible' => true ],
			[ 'id' => 'title', 'visible' => true ],
			[ 'id' => 'metas', 'visible' => true ],
			[ 'id' => 'excerpt', 'visible' => true ],
		];
	}
}
add_filter( 'kenta_card_structure_default_value', 'kenta_ciela_archive_structure' );

// archive header
if ( ! function_exists( 'kenta_ciela_archive_header_background' ) ) {
	function kenta_ciela_archive_header_background() {
		return [
			'type'  => 'color',
			'color' => 'var(--kenta-base-color)'
		];
	}
}
add_filter( 'kenta_archive_header_background_default_value', 'kenta_ciela_archive_header_background' );

if ( ! function_exists( 'kenta_ciela_archive_title_color' ) ) {
	function kenta_ciela_archive_title_color() {
		return [ 'initial' => 'var(--kenta-accent-color)' ];
	}
}
add_filter( 'kenta_archive_title_color_default_value', 'kenta_ciela_archive_title_color' );

if ( ! function_exists( 'kenta_ciela_archive_description_color' ) ) {
	function kenta_ciela_archive_description_color() {
		return [ 'initial' => 'var(--kenta-accent-active)' ];
	}
}
add_filter( 'kenta_archive_description_color_default_value', 'kenta_ciela_archive_description_color' );

//
// Header elements
//

if ( ! function_exists( 'kenta_ciela_header_primary_row_elements' ) ) {
	function kenta_ciela_header_primary_row_elements() {
		return [
			'desktop' => [
				[
					'elements' => [ 'logo' ],
					'settings' => [ 'width' => '30%' ]
				],
				[
					'elements' => [ 'menu-1', 'socials', 'theme-switch', 'search', 'trigger' ],
					'settings' => [ 'width' => '70%', 'justify-content' => 'flex-end', 'elements-gap' => '16px' ]
				],
			],
			'mobile'  => [
				[
					'elements' => [ 'logo' ],
					'settings' => [ 'width' => '70%', ]
				],
				[
					'elements' => [ 'socials', 'theme-switch', 'search', 'trigger' ],
					'settings' => [ 'width' => '30%', 'justify-content' => 'flex-end', 'elements-gap' => '16px' ]
				],
			],
		];
	}
}
add_filter( 'kenta_header_primary_row_default_value', 'kenta_ciela_header_primary_row_elements' );

// socials element
if ( ! function_exists( 'kenta_ciela_header_socials_icons_color_type' ) ) {
	function kenta_ciela_header_socials_icons_color_type() {
		return 'custom';
	}
}
add_filter( 'kenta_header_el_socials_icons_color_type_default_value', 'kenta_ciela_header_socials_icons_color_type' );

// icon size
if ( ! function_exists( 'kenta_ciela_icon_size' ) ) {
	function kenta_ciela_icon_size() {
		return '16px';
	}
}
add_filter( 'kenta_header_el_socials_icons_size_default_value', 'kenta_ciela_icon_size' );
add_filter( 'kenta_header_el_search_icon_button_size_default_value', 'kenta_ciela_icon_size' );
add_filter( 'kenta_header_el_trigger_icon_button_size_default_value', 'kenta_ciela_icon_size' );
add_filter( 'kenta_header_el_theme_switch_icon_button_size_default_value', 'kenta_ciela_icon_size' );
add_filter( 'kenta_header_el_cart_icon_button_size_default_value', 'kenta_ciela_icon_size' );

// menu element
if ( ! function_exists( 'kenta_ciela_menu_typography' ) ) {
	function kenta_ciela_menu_typography() {
		return [
			'family'        => 'inherit',
			'fontSize'      => [ 'desktop' => '0.875rem', 'tablet' => '0.875rem', 'mobile' => '0.75em' ],
			'variant'       => '500',
			'lineHeight'    => '1.5',
			'textTransform' => 'capitalize',
		];
	}
}
add_filter( 'kenta_header_el_menu_1_top_level_typography_default_value', 'kenta_ciela_menu_typography' );
add_filter( 'kenta_header_el_menu_2_top_level_typography_default_value', 'kenta_ciela_menu_typography' );

// logo element
if ( ! function_exists( 'kenta_ciela_header_logo_title_typography' ) ) {
	function kenta_ciela_header_logo_title_typography() {
		return [
			'family'        => 'inherit',
			'fontSize'      => '1.45rem',
			'variant'       => '700',
			'lineHeight'    => '1.5',
			'textTransform' => 'capitalize',
		];
	}
}
add_filter( 'kenta_header_el_logo_site_title_typography_default_value', 'kenta_ciela_header_logo_title_typography' );

//
// Sticky header
//
add_filter( 'kenta_sticky_header_default_value', 'kenta_ciela_return_yes' );

//
// Footer elements
//

if ( ! function_exists( 'kenta_ciela_footer_middle_row_elements' ) ) {
	function kenta_ciela_footer_middle_row_elements() {
		return [
			[
				'elements' => [ 'widgets-1', 'footer-socials' ],
				'settings' => [
					'width'   => [ 'desktop' => '33.33%', 'tablet' => '100%', 'mobile' => '100%' ],
					'padding' => [ 'top' => '12px', 'right' => '12px', 'bottom' => '12px', 'left' => '12px' ]
				],
			],
			[
				'elements' => [ 'widgets-2' ],
				'settings' => [
					'width'   => [ 'desktop' => '33.33%', 'tablet' => '100%', 'mobile' => '100%' ],
					'padding' => [ 'top' => '12px', 'right' => '12px', 'bottom' => '12px', 'left' => '12px' ]
				],
			],
			[
				'elements' => [ 'widgets-4' ],
				'settings' => [
					'width'   => [ 'desktop' => '33.33%', 'tablet' => '100%', 'mobile' => '100%' ],
					'padding' => [ 'top' => '12px', 'right' => '12px', 'bottom' => '12px', 'left' => '12px' ]
				],
			]
		];
	}
}
add_filter( 'kenta_footer_middle_row_default_value', 'kenta_ciela_footer_middle_row_elements' );

if ( ! function_exists( 'kenta_ciela_footer_middle_row_vt_spacing' ) ) {
	function kenta_ciela_footer_middle_row_vt_spacing() {
		return '68px';
	}
}
add_filter( 'kenta_footer_middle_row_vt_spacing_default_value', 'kenta_ciela_footer_middle_row_vt_spacing' );

if ( ! function_exists( 'kenta_ciela_builder_row_border' ) ) {
	function kenta_ciela_builder_row_border() {
		return [
			'style' => 'solid',
			'width' => 1,
			'color' => 'var(--kenta-base-300)',
		];
	}
}
add_filter( 'kenta_footer_bottom_row_border_top_default_value', 'kenta_ciela_builder_row_border' );
add_filter( 'kenta_footer_middle_row_border_top_default_value', 'kenta_ciela_builder_row_border' );
add_filter( 'kenta_header_primary_navbar_row_border_bottom_default_value', 'kenta_ciela_builder_row_border' );

//
// Article & Archive header style
//
if ( ! function_exists( 'kenta_ciela_article_featured_image_position' ) ) {
	/**
	 * Change default article featured image position design
	 *
	 * @return string
	 */
	function kenta_ciela_article_featured_image_position() {
		return 'behind';
	}
}
add_filter( 'kenta_post_featured_image_position_default_value', 'kenta_ciela_article_featured_image_position' );
add_filter( 'kenta_page_featured_image_position_default_value', 'kenta_ciela_article_featured_image_position' );


if ( ! function_exists( 'kenta_ciela_remove_default_content_spacing' ) ) {
	/**
	 * Remove default content spacing
	 *
	 * @return string
	 */
	function kenta_ciela_remove_default_content_spacing() {
		return '0x';
	}
}
//add_filter( 'kenta_single_post_content_spacing_default_value', 'kenta_ciela_remove_default_content_spacing' );
add_filter( 'kenta_pages_content_spacing_default_value', 'kenta_ciela_remove_default_content_spacing' );

if ( ! function_exists( 'kenta_ciela_default_archive_header_padding' ) ) {
	/**
	 * Change default padding for archive header
	 *
	 * @return array
	 */
	function kenta_ciela_default_archive_header_padding() {
		return array(
			'top'    => '148px',
			'bottom' => '68px',
			'left'   => '24px',
			'right'  => '24px',
			'linked' => false
		);
	}
}
add_filter( 'kenta_archive_header_padding_default_value', 'kenta_ciela_default_archive_header_padding' );

if ( ! function_exists( 'kenta_ciela_archive_title_typography' ) ) {
	function kenta_ciela_archive_title_typography() {
		return array(
			'family'        => 'inherit',
			'fontSize'      => [ 'desktop' => '3rem', 'tablet' => '2rem', 'mobile' => '1.875em' ],
			'variant'       => '700',
			'lineHeight'    => '1.5',
			'textTransform' => 'capitalize',
		);
	}
}
add_filter( 'kenta_archive_title_typography_default_value', 'kenta_ciela_archive_title_typography' );

if ( ! function_exists( 'kenta_ciela_archive_title_color' ) ) {
	function kenta_ciela_archive_title_color() {
		return array(
			'initial' => '#fff'
		);
	}
}
add_filter( 'kenta_archive_title_color_default_value', 'kenta_ciela_archive_title_color' );

// Enable archive header overlay
add_filter( 'kenta_archive_header_has_overlay_default_value', 'kenta_ciela_return_yes' );

if ( ! function_exists( 'kenta_ciela_archive_description_color' ) ) {
	function kenta_ciela_archive_description_color() {
		return array(
			'initial' => 'rgba(255,255,255,0.75)',
		);
	}
}
add_filter( 'kenta_archive_description_color_default_value', 'kenta_ciela_archive_description_color' );

if ( ! function_exists( 'kenta_ciela_hero_background' ) ) {
	/**
	 * Change default hero background for archive
	 *
	 * @return array
	 */
	function kenta_ciela_hero_background() {
		return array(
			'type'  => 'image',
			'image' => array(
				'color'  => 'var(--kenta-accent-color)',
				'size'   => 'cover',
				'repeat' => 'no-repeat',
				'source' => array(
					'url' => KENTA_CIELA_ASSETS_URL . 'images/hero-background.jpg',
					'x'   => 0.5,
					'y'   => 0.5,
				)
			),
		);
	}
}
add_filter( 'kenta_archive_header_background_default_value', 'kenta_ciela_hero_background' );

if ( ! function_exists( 'kenta_ciela_featured_image_background_overlay' ) ) {
	/**
	 * Change default hero background for single posts and pages
	 *
	 * @return array
	 */
	function kenta_ciela_featured_image_background_overlay() {
		return array(
			'type'  => 'color',
			'color' => '#2c2c2c'
		);
	}
}
add_filter( 'kenta_post_featured_image_background_overlay_default_value', 'kenta_ciela_featured_image_background_overlay' );
add_filter( 'kenta_page_featured_image_background_overlay_default_value', 'kenta_ciela_featured_image_background_overlay' );


if ( ! function_exists( 'kenta_ciela_featured_image_background_overlay_opacity' ) ) {
	/**
	 * Change default hero background for single posts and pages
	 *
	 */
	function kenta_ciela_featured_image_background_overlay_opacity() {
		return 0.35;
	}
}
add_filter( 'kenta_post_featured_image_background_overlay_opacity_default_value', 'kenta_ciela_featured_image_background_overlay_opacity' );
add_filter( 'kenta_page_featured_image_background_overlay_opacity_default_value', 'kenta_ciela_featured_image_background_overlay_opacity' );

if ( ! function_exists( 'kenta_ciela_featured_image_fallback' ) ) {
	function kenta_ciela_featured_image_fallback() {
		return array(
			'url' => KENTA_CIELA_ASSETS_URL . 'images/page-header.jpg',
			'x'   => 0.5,
			'y'   => 0.5,
		);
	}
}
add_filter( 'kenta_post_featured_image_fallback_default_value', 'kenta_ciela_featured_image_fallback' );
add_filter( 'kenta_page_featured_image_fallback_default_value', 'kenta_ciela_featured_image_fallback' );
// Disable fallback image in archive
add_filter( 'kenta_entry_thumbnail_use_fallback_default_value', 'kenta_ciela_return_no' );

if ( ! function_exists( 'kenta_ciela_featured_image_elements_override' ) ) {
	function kenta_ciela_featured_image_elements_override() {
		return array(
			'override' => '#fff'
		);
	}
}
add_filter( 'kenta_post_featured_image_elements_override_default_value', 'kenta_ciela_featured_image_elements_override' );
add_filter( 'kenta_page_featured_image_elements_override_default_value', 'kenta_ciela_featured_image_elements_override' );

//
// Transparent Header settings
//

if ( ! function_exists( 'kenta_ciela_transparent_header_device' ) ) {
	function kenta_ciela_transparent_header_device() {
		return 'all';
	}
}
add_filter( 'kenta_enable_transparent_header_device_default_value', 'kenta_ciela_transparent_header_device' );

if ( ! function_exists( 'kenta_ciela_trans_header_site_title_color' ) ) {
	function kenta_ciela_trans_header_site_title_color() {
		return array(
			'initial' => '#fff',
			'hover'   => '#fff',
		);
	}
}
add_filter( 'kenta_trans_header_site_title_color_default_value', 'kenta_ciela_trans_header_site_title_color' );

if ( ! function_exists( 'kenta_ciela_trans_header_menu_color' ) ) {
	function kenta_ciela_trans_header_menu_color() {
		return array(
			'initial' => '#fff',
			'hover'   => 'var(--kenta-primary-color)',
			'active'  => 'var(--kenta-primary-color)',
		);
	}
}
add_filter( 'kenta_trans_header_menu_color_default_value', 'kenta_ciela_trans_header_menu_color' );

if ( ! function_exists( 'kenta_ciela_trans_header_button_color' ) ) {
	function kenta_ciela_trans_header_button_color() {
		return array(
			'initial' => '#fff',
			'hover'   => 'var(--kenta-primary-color)',
		);
	}
}
add_filter( 'kenta_trans_header_button_color_default_value', 'kenta_ciela_trans_header_button_color' );
if ( ! function_exists( 'kenta_ciela_trans_header_border_bottom' ) ) {
	function kenta_ciela_trans_header_border_bottom() {
		return [
			'width' => 1,
			'style' => 'none',
			'color' => 'var(--kenta-base-300)',
		];
	}
}
add_filter( 'kenta_trans_header_border_bottom_default_value', 'kenta_ciela_trans_header_border_bottom' );

//
// Widgets area
//
if ( ! function_exists( 'kenta_ciela_widgets_title' ) ) {
	function kenta_ciela_widgets_title() {
		return 'style-2';
	}
}
add_action( 'kenta_global_sidebar_title-style_default_value', 'kenta_ciela_widgets_title' );
add_action( 'kenta_footer_el_widgets_1_title-style_default_value', 'kenta_ciela_widgets_title' );
add_action( 'kenta_footer_el_widgets_2_title-style_default_value', 'kenta_ciela_widgets_title' );
add_action( 'kenta_footer_el_widgets_3_title-style_default_value', 'kenta_ciela_widgets_title' );
add_action( 'kenta_footer_el_widgets_4_title-style_default_value', 'kenta_ciela_widgets_title' );
add_action( 'kenta_header_el_widgets_1_title-style_default_value', 'kenta_ciela_widgets_title' );
add_action( 'kenta_header_el_widgets_2_title-style_default_value', 'kenta_ciela_widgets_title' );

//
// button element
//
if ( ! function_exists( 'kenta_ciela_header_button_icon' ) ) {
	function kenta_ciela_header_button_icon() {
		return [
			'library' => 'fa-solid',
			'value'   => 'fas fa-paper-plane',
		];
	}
}
add_filter( 'kenta_header_el_button_1_arrow_default_value', 'kenta_ciela_header_button_icon' );

if ( ! function_exists( 'kenta_ciela_header_button_text' ) ) {
	function kenta_ciela_header_button_text() {
		return __( 'Subscribe', 'kenta-ciela' );
	}
}
add_filter( 'kenta_header_el_button_1_text_default_value', 'kenta_ciela_header_button_text' );

if ( ! function_exists( 'kenta_ciela_header_button_preset' ) ) {
	function kenta_ciela_header_button_preset() {
		return 'outline';
	}
}
add_filter( 'kenta_header_el_button_1_preset_default_value', 'kenta_ciela_header_button_preset' );

if ( ! function_exists( 'kenta_ciela_global_button_preset' ) ) {
	function kenta_ciela_global_button_preset() {
		return 'primary';
	}
}
add_filter( 'kenta_header_el_button_1_preset_default_value', 'kenta_ciela_global_button_preset' );
add_filter( 'kenta_header_el_button_2_preset_default_value', 'kenta_ciela_global_button_preset' );
add_filter( 'kenta_entry_read_more_preset_default_value', 'kenta_ciela_global_button_preset' );
add_filter( 'kenta_content_buttons_preset_default_value', 'kenta_ciela_global_button_preset' );
add_filter( 'kenta_related_posts_read_more_preset_default_value', 'kenta_ciela_global_button_preset' );

if ( ! function_exists( 'kenta_ciela_button_radius' ) ) {
	function kenta_ciela_button_radius() {
		return [
			'linked' => true,
			'left'   => '4px',
			'right'  => '4px',
			'top'    => '4px',
			'bottom' => '4px',
		];
	}
}
add_filter( 'kenta_header_el_button_1_radius_default_value', 'kenta_ciela_button_radius' );
add_filter( 'kenta_header_el_button_2_radius_default_value', 'kenta_ciela_button_radius' );
add_filter( 'kenta_entry_read_more_radius_default_value', 'kenta_ciela_button_radius' );
add_filter( 'kenta_content_buttons_radius_default_value', 'kenta_ciela_button_radius' );
add_filter( 'kenta_related_posts_read_more_radius_default_value', 'kenta_ciela_button_radius' );

if ( ! function_exists( 'kenta_ciela_button_shadow' ) ) {
	function kenta_ciela_button_shadow() {
		return [
			'enable'     => 'no',
			'horizontal' => '4px',
			'vertical'   => '4px',
			'blur'       => '0px',
			'spread'     => '0px',
			'color'      => 'var(--kenta-primary-color)',
		];
	}
}
add_filter( 'kenta_header_el_button_1_shadow_active_default_value', 'kenta_ciela_button_shadow' );
add_filter( 'kenta_header_el_button_2_shadow_active_default_value', 'kenta_ciela_button_shadow' );
add_filter( 'kenta_entry_read_more_shadow_active_default_value', 'kenta_ciela_button_shadow' );
add_filter( 'kenta_content_buttons_shadow_active_default_value', 'kenta_ciela_button_shadow' );
add_filter( 'kenta_related_posts_read_more_shadow_active_default_value', 'kenta_ciela_button_shadow' );

if ( ! function_exists( 'kenta_ciela_button_preset_args' ) ) {
	function kenta_ciela_button_preset_args( $args, $id, $preset ) {
		if ( $preset === 'outline' ) {
			$args[ $id . 'text_color' ] = [
				'initial' => 'var(--kenta-primary-color)',
				'hover'   => '#ffffff',
			];
		}

		if ( $preset === 'solid' ) {
			$args[ $id . 'text_color' ] = [
				'initial' => '#ffffff',
				'hover'   => 'var(--kenta-base-color)',
			];
		}

		if ( $preset === 'invert' ) {
			$args[ $id . 'text_color' ] = [
				'initial' => 'var(--kenta-base-color)',
				'hover'   => '#ffffff',
			];
		}

		if ( $preset === 'primary' ) {
			$args[ $id . 'text_color' ] = [
				'initial' => '#ffffff',
				'hover'   => '#ffffff',
			];
		}

		return $args;
	}
}
add_filter( 'kenta_header_el_button_1_preset_args', 'kenta_ciela_button_preset_args', 10, 3 );
add_filter( 'kenta_header_el_button_2_preset_args', 'kenta_ciela_button_preset_args', 10, 3 );
add_filter( 'kenta_entry_read_more_preset_args', 'kenta_ciela_button_preset_args', 10, 3 );
add_filter( 'kenta_content_buttons_preset_args', 'kenta_ciela_button_preset_args', 10, 3 );
add_filter( 'kenta_related_posts_read_more_preset_args', 'kenta_ciela_button_preset_args', 10, 3 );
