<?php
/**
 * Theme functions
 *
 * @package Kenta Artistic Blog
 */

// don't call the file directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'KENTA_ARTISTIC_BLOG_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'KENTA_ARTISTIC_BLOG_VERSION', '1.0.1' );
}

if ( ! defined( 'KENTA_ARTISTIC_BLOG_PATH' ) ) {
	define( 'KENTA_ARTISTIC_BLOG_PATH', trailingslashit( get_stylesheet_directory() ) );
}

if ( ! defined( 'KENTA_ARTISTIC_BLOG_URL' ) ) {
	define( 'KENTA_ARTISTIC_BLOG_URL', trailingslashit( get_stylesheet_directory_uri() ) );
}

if ( ! defined( 'KENTA_ARTISTIC_BLOG_ASSETS_URL' ) ) {
	define( 'KENTA_ARTISTIC_BLOG_ASSETS_URL', KENTA_ARTISTIC_BLOG_URL . 'assets/' );
}

// Helper functions
require_once KENTA_ARTISTIC_BLOG_PATH . 'helpers.php';
// Customizer settings hook
require_once KENTA_ARTISTIC_BLOG_PATH . 'customizer.php';

//
// One click demo import
//
if ( ! function_exists( 'kenta_artistic_blog_demo_slug' ) ) {
	function kenta_artistic_blog_demo_slug() {
		return '';
	}
}
add_filter( 'kenta_welcome_demo_slug', 'kenta_artistic_blog_demo_slug' );

if ( ! function_exists( 'kenta_artistic_blog_demo_name' ) ) {
	function kenta_artistic_blog_demo_name() {
		return __( 'Kenta Artistic Blog', 'kenta-artistic-blog' );
	}
}
add_filter( 'kenta_welcome_demo_name', 'kenta_artistic_blog_demo_name' );

if ( ! function_exists( 'kenta_artistic_blog_demo_screenshot' ) ) {
	function kenta_artistic_blog_demo_screenshot() {
		return '';
	}
}
add_filter( 'kenta_welcome_demo_screenshot', 'kenta_artistic_blog_demo_screenshot' );

//
// Dynamic css cache
//
if ( ! function_exists( 'kenta_artistic_blog_cache_key' ) ) {
	function kenta_artistic_blog_cache_key() {
		return 'kenta_artistic_blog_dynamic_css';
	}
}
add_filter( 'kenta_filter_dynamic_css_cache_key', 'kenta_artistic_blog_cache_key' );

if ( ! function_exists( 'kenta_artistic_blog_cache_version' ) ) {
	function kenta_artistic_blog_cache_version() {
		return KENTA_ARTISTIC_BLOG_VERSION;
	}
}
add_filter( 'kenta_filter_cached_dynamic_css_version', 'kenta_artistic_blog_cache_version' );
