<?php
/**
 * Theme Customizer
 *
 * @package Kenta Artistic Blog
 */

// don't call the file directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'kenta_artistic_blog_return_yes' ) ) {
	function kenta_artistic_blog_return_yes() {
		return 'yes';
	}
}

if ( ! function_exists( 'kenta_artistic_blog_return_no' ) ) {
	function kenta_artistic_blog_return_no() {
		return 'no';
	}
}

// Disable site wrap by default
add_filter( 'kenta_enable_site_wrap_default_value', 'kenta_artistic_blog_return_no' );

//
//  Card style
//
if ( ! function_exists( 'kenta_artistic_blog_card_preset' ) ) {
	function kenta_artistic_blog_card_preset() {
		return 'solid-shadow';
	}
}
add_filter( 'kenta_card_style_preset_default_value', 'kenta_artistic_blog_card_preset' );
add_filter( 'kenta_store_card_style_preset_default_value', 'kenta_artistic_blog_card_preset' );
add_filter( 'kenta_global_sidebar_widgets-style_default_value', 'kenta_artistic_blog_card_preset' );
add_filter( 'kenta_post_content_style_preset_default_value', 'kenta_artistic_blog_card_preset' );

//
// Sidebar
//
add_filter( 'kenta_post_sidebar_section_default_value', 'kenta_artistic_blog_return_yes' );

//
// Default color preset
//

if ( ! function_exists( 'kenta_artistic_blog_default_color_presets' ) ) {
	function kenta_artistic_blog_default_color_presets() {
		return 'kenta-artistic-blog';
	}
}
add_filter( 'kenta_color_palettes_default_value', 'kenta_artistic_blog_default_color_presets' );

if ( ! function_exists( 'kenta_artistic_blog_color_presets' ) ) {
	function kenta_artistic_blog_color_presets( $presets ) {
		$presets['kenta-artistic-blog'] = array(
			'kenta-primary-color'  => '#bc5917',
			'kenta-primary-active' => '#d97407',
			'kenta-accent-color'   => '#202023',
			'kenta-accent-active'  => '#252528',
			'kenta-base-300'       => '#e2e8f0',
			'kenta-base-200'       => '#f1f5f9',
			'kenta-base-100'       => '#f8fafc',
			'kenta-base-color'     => '#ffffff',
		);

		return $presets;
	}
}
add_filter( 'kenta_filter_color_presets', 'kenta_artistic_blog_color_presets' );

//
// Dark color preset
//
if ( ! function_exists( 'kenta_artistic_blog_dark_base_color' ) ) {
	function kenta_artistic_blog_dark_base_color() {
		return [
			'300'     => '#3d3d3d',
			'200'     => '#36373b',
			'100'     => '#252528',
			'default' => '#202023',
		];
	}
}
add_filter( 'kenta_dark_base_color_default_value', 'kenta_artistic_blog_dark_base_color' );

if ( ! function_exists( 'kenta_artistic_blog_dark_accent_color' ) ) {
	function kenta_artistic_blog_dark_accent_color() {
		return [
			'default' => '#fefefe',
			'active'  => '#c2c3c8',
		];
	}
}
add_filter( 'kenta_dark_accent_color_default_value', 'kenta_artistic_blog_dark_accent_color' );

//
// Global typography
//
if ( ! function_exists( 'kenta_artistic_blog_global_typography' ) ) {
	function kenta_artistic_blog_global_typography() {
		return [
			'family'     => 'montserrat',
			'fontSize'   => [
				'desktop' => '16px',
				'tablet'  => '__INITIAL_VALUE__',
				'mobile'  => '__INITIAL_VALUE__'
			],
			'variant'    => '500',
			'lineHeight' => '1',
		];
	}
}
add_filter( 'kenta_site_global_typography_default_value', 'kenta_artistic_blog_global_typography' );

//
// Site background
//
if ( ! function_exists( 'kenta_artistic_blog_site_background' ) ) {
	function kenta_artistic_blog_site_background() {
		return [
			'type'  => 'image',
			'color' => 'var(--kenta-base-100)',
			'image' => [
				'color'  => 'var(--kenta-base-100)',
				'size'   => 'auto',
				'repeat' => 'repeat',
				'source' => [
					'x'   => 0,
					'y'   => 0,
					'url' => kenta_artistic_blog_asset_url( 'images/background-pattern.png' ),
				]
			]
		];
	}
}
add_filter( 'kenta_site_background_default_value', 'kenta_artistic_blog_site_background' );

//
// Preloader
//
if ( ! function_exists( 'kenta_artistic_blog_preloader_preset' ) ) {
	function kenta_artistic_blog_preloader_preset() {
		return 'preset-4';
	}
}
add_filter( 'kenta_preloader_preset_default_value', 'kenta_artistic_blog_preloader_preset' );

if ( ! function_exists( 'kenta_artistic_blog_preloader_colors' ) ) {
	function kenta_artistic_blog_preloader_colors() {
		return [
			'background' => '#202023',
			'accent'     => '#ffffff',
			'primary'    => 'var(--kenta-primary-color)',
		];
	}
}
add_filter( 'kenta_preloader_colors_default_value', 'kenta_artistic_blog_preloader_colors' );

//
// Header offcanvas
//
if ( ! function_exists( 'kenta_artistic_blog_canvas_drawer_placement' ) ) {
	function kenta_artistic_blog_canvas_drawer_placement() {
		return 'left';
	}
}
add_filter( 'kenta_canvas_drawer_placement_default_value', 'kenta_artistic_blog_canvas_drawer_placement' );

//
// Header top row
//
if ( ! function_exists( 'kenta_artistic_blog_header_top_row_elements' ) ) {
	function kenta_artistic_blog_header_top_row_elements() {
		return [
			'desktop' => [
				[
					'elements' => [],
					'settings' => [ 'width' => '70%', 'justify-content' => 'start' ]
				],
				[
					'elements' => [],
					'settings' => [ 'width' => '30%', 'justify-content' => 'end' ]
				],
			],
			'mobile'  => [
				[
					'elements' => [],
					'settings' => [ 'width' => '100%', 'justify-content' => 'center' ]
				],
			],
		];
	}
}
add_filter( 'kenta_header_top_row_default_value', 'kenta_artistic_blog_header_top_row_elements' );

//
// Header primary row
//

if ( ! function_exists( 'kenta_artistic_blog_header_primary_row_elements' ) ) {
	function kenta_artistic_blog_header_primary_row_elements() {
		return [
			'desktop' => [
				[
					'elements' => [ 'logo' ],
					'settings' => [ 'width' => '100%', 'justify-content' => 'center' ]
				],
			],
			'mobile'  => [
				[
					'elements' => [ 'logo' ],
					'settings' => [ 'width' => '100%', 'justify-content' => 'center' ]
				],
			],
		];
	}
}
add_filter( 'kenta_header_primary_row_default_value', 'kenta_artistic_blog_header_primary_row_elements' );

if ( ! function_exists( 'kenta_artistic_blog_header_primary_row_height' ) ) {
	function kenta_artistic_blog_header_primary_row_height() {
		return '285px';
	}
}
add_filter( 'kenta_header_primary_navbar_row_min_height_default_value', 'kenta_artistic_blog_header_primary_row_height' );

if ( ! function_exists( 'kenta_artistic_blog_header_primary_row_background' ) ) {
	function kenta_artistic_blog_header_primary_row_background() {
		return [
			'type'  => 'image',
			'color' => 'var(--kenta-base-color)',
			'image' => [
				'size'   => 'cover',
				'repeat' => 'no-repeat',
				'source' => [
					'x'   => 0.5,
					'y'   => 0.5,
					'url' => kenta_artistic_blog_asset_url( 'images/background.jpg' ),
				]
			]
		];
	}
}
add_filter( 'kenta_header_primary_navbar_row_background_default_value', 'kenta_artistic_blog_header_primary_row_background' );

//
// Header bottom row
//
if ( ! function_exists( 'kenta_artistic_blog_header_bottom_row_elements' ) ) {
	function kenta_artistic_blog_header_bottom_row_elements() {
		return [
			'desktop' => [
				[
					'elements' => [ 'menu-1' ],
					'settings' => [ 'width' => '70%', 'justify-content' => 'flex-start' ]
				],
				[
					'elements' => [ 'socials', 'theme-switch', 'search' ],
					'settings' => [ 'width' => '30%', 'justify-content' => 'flex-end' ]
				],
			],
			'mobile'  => [
				[
					'elements' => [ 'trigger' ],
					'settings' => [ 'width' => '20%', 'justify-content' => 'flex-start' ]
				],
				[
					'elements' => [ 'socials' ],
					'settings' => [ 'width' => '60%', 'justify-content' => 'center' ]
				],
				[
					'elements' => [ 'theme-switch', 'search' ],
					'settings' => [ 'width' => '20%', 'justify-content' => 'flex-end' ]
				],
			],
		];
	}
}
add_filter( 'kenta_header_bottom_row_default_value', 'kenta_artistic_blog_header_bottom_row_elements' );

if ( ! function_exists( 'kenta_artistic_blog_header_bottom_row_height' ) ) {
	function kenta_artistic_blog_header_bottom_row_height() {
		return '58px';
	}
}
add_filter( 'kenta_header_bottom_row_row_min_height_default_value', 'kenta_artistic_blog_header_bottom_row_height' );

if ( ! function_exists( 'kenta_artistic_blog_header_bottom_row_border_top' ) ) {
	function kenta_artistic_blog_header_bottom_row_border_top() {
		return [
			'width' => 3,
			'style' => 'solid',
			'color' => 'var(--kenta-primary-color)',
		];
	}
}
add_filter( 'kenta_header_bottom_row_row_border_top_default_value', 'kenta_artistic_blog_header_bottom_row_border_top' );

if ( ! function_exists( 'kenta_artistic_blog_header_bottom_row_border_bottom' ) ) {
	function kenta_artistic_blog_header_bottom_row_border_bottom() {
		return [
			'width' => 2,
			'style' => 'solid',
			'color' => 'var(--kenta-base-300)',
		];
	}
}
add_filter( 'kenta_header_bottom_row_row_border_bottom_default_value', 'kenta_artistic_blog_header_bottom_row_border_bottom' );

//
// Particles effect
//
add_filter( 'kenta_header_primary_navbar_row_enable_particles_default_value', 'kenta_artistic_blog_return_yes' );

if ( ! function_exists( 'kenta_artistic_blog_header_primary_navbar_particle_preset' ) ) {
	function kenta_artistic_blog_header_primary_navbar_particle_preset() {
		return 'gather';
	}
}
add_filter( 'kenta_header_primary_navbar_row_particle_preset_default_value', 'kenta_artistic_blog_header_primary_navbar_particle_preset' );

if ( ! function_exists( 'kenta_artistic_blog_header_primary_navbar_particle_detect_on' ) ) {
	function kenta_artistic_blog_header_primary_navbar_particle_detect_on() {
		return 'window';
	}
}
add_filter( 'kenta_header_primary_navbar_row_particle_detect_on_default_value', 'kenta_artistic_blog_header_primary_navbar_particle_detect_on' );

if ( ! function_exists( 'kenta_artistic_blog_header_primary_navbar_particle_color' ) ) {
	function kenta_artistic_blog_header_primary_navbar_particle_color() {
		return array(
			'particle' => '#ffffff',
			'line'     => '#ffffff',
		);
	}
}
add_filter( 'kenta_header_primary_navbar_row_particle_color_default_value', 'kenta_artistic_blog_header_primary_navbar_particle_color' );

// logo element
if ( ! function_exists( 'kenta_artistic_blog_header_logo_title_color' ) ) {
	function kenta_artistic_blog_header_logo_title_color() {
		return [
			'initial' => '#ffffff',
			'hover'   => '#ffffff',
		];
	}
}
add_filter( 'kenta_header_el_logo_site_title_color_default_value', 'kenta_artistic_blog_header_logo_title_color' );

if ( ! function_exists( 'kenta_artistic_blog_header_logo_tagline_color' ) ) {
	function kenta_artistic_blog_header_logo_tagline_color() {
		return [
			'initial' => '#ffffff',
		];
	}
}
add_filter( 'kenta_header_el_logo_site_tagline_color_default_value', 'kenta_artistic_blog_header_logo_tagline_color' );

if ( ! function_exists( 'kenta_artistic_blog_header_logo_content_alignment' ) ) {
	function kenta_artistic_blog_header_logo_content_alignment() {
		return 'center';
	}
}
add_filter( 'kenta_header_el_logo_content_alignment_default_value', 'kenta_artistic_blog_header_logo_content_alignment' );

if ( ! function_exists( 'kenta_artistic_blog_header_logo_position') ) {
	function kenta_artistic_blog_header_logo_position() {
		return 'top';
	}
}
add_filter( 'kenta_header_el_logo_position_default_value', 'kenta_artistic_blog_header_logo_position' );

add_filter( 'kenta_header_el_logo_enable_site_tagline_default_value', 'kenta_artistic_blog_return_yes' );

// Socials element
if ( ! function_exists( 'kenta_artistic_blog_header_socials_icons_color_type' ) ) {
	function kenta_artistic_blog_header_socials_icons_color_type() {
		return 'custom';
	}
}
add_filter( 'kenta_header_el_socials_icons_color_type_default_value', 'kenta_artistic_blog_header_socials_icons_color_type' );

//
// Theme switch element
add_filter( 'kenta_default_dark_scheme_default_value', 'kenta_artistic_blog_return_yes' );

//
// Footer bottom row
//
if ( ! function_exists( 'kenta_artistic_blog_footer_bottom_row_border_top' ) ) {
	function kenta_artistic_blog_footer_bottom_row_border_top() {
		return [
			'width' => 3,
			'style' => 'solid',
			'color' => 'var(--kenta-primary-color)',
		];
	}
}
add_filter( 'kenta_footer_bottom_row_border_top_default_value', 'kenta_artistic_blog_footer_bottom_row_border_top' );

//
// Sticky header
//
add_filter( 'kenta_sticky_header_default_value', 'kenta_artistic_blog_return_yes' );

if ( ! function_exists( 'kenta_artistic_blog_sticky_rows' ) ) {
	function kenta_artistic_blog_sticky_rows() {
		return 'bottom-row';
	}
}
add_filter( 'kenta_sticky_header_rows_default_value', 'kenta_artistic_blog_sticky_rows' );


