<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Keeway_Lite
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function keeway_lite_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'keeway_lite_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function keeway_lite_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'keeway_lite_pingback_header' );

function keeway_lite_blog_banner(){ 

?>

<div class="main_banner_area <?php if(get_header_image() ){ echo esc_attr('banner_image');}else{ echo esc_attr('banner_bg_color');}?>" <?php if(get_header_image() ){ ?> style="background: url(<?php header_image(); ?>)no-repeat;background-size:cover;  background-position: top top; background-attachment:scroll;" <?php } ?> >
	<div class="container">
		<div class="bannar_padding text-center" data-wow-duration="1s" data-wow-delay="0.3s" data-wow-offset="0">
			<h2 class="title_blog"><?php echo esc_html( get_bloginfo( 'name', 'display' ) ); ?></h2>
			<p><?php echo esc_html(get_bloginfo( 'description', 'display' ));?></p>
		</div>
	</div>
</div>

<?php }


function keeway_lite_archive_banner(){ 

?>

<div class="main_banner_area <?php if(get_header_image() ){ echo esc_attr('banner_image');}else{ echo esc_attr('banner_bg_color');}?>" <?php if(get_header_image() ){ ?> style="background: url(<?php header_image(); ?>)no-repeat;background-size:cover;  background-position: top top; background-attachment:scroll;" <?php } ?> >
	<div class="container">
		<div class="bannar_padding text-center" data-wow-duration="1s" data-wow-delay="0.3s" data-wow-offset="0">
			<h2 class="title_blog"><?php the_archive_title(); ?></h2>
			<p><?php echo esc_html(get_bloginfo( 'description', 'display' ));?></p>
		</div>
	</div>
</div>

<?php }


function keeway_lite_single_banner(){ 

?>

<div class="main_banner_area <?php if(get_header_image() ){ echo esc_attr('banner_image');}else{ echo esc_attr('banner_bg_color');}?>" <?php if(get_header_image() ){ ?> style="background: url(<?php header_image(); ?>)no-repeat;background-size:cover;  background-position: top top; background-attachment:scroll;" <?php } ?> >
	<div class="container">
		<div class="bannar_padding text-center" data-wow-duration="1s" data-wow-delay="0.3s" data-wow-offset="0">
			<h2 class="title_blog"><?php the_title(); ?></h2>
			<p><?php echo esc_html(get_bloginfo( 'description', 'display' ));?></p>
		</div>
	</div>
</div>

<?php }


function keeway_lite_404_banner(){ 


?>

<div class="main_banner_area <?php if(get_header_image() ){ echo esc_attr('banner_image');}else{ echo esc_attr('banner_bg_color');}?>" <?php if(get_header_image() ){ ?> style="background: url(<?php header_image(); ?>)no-repeat;background-size:cover;  background-position: top top; background-attachment:scroll;" <?php } ?> >
	<div class="container">
		<div class="bannar_padding text-center" data-wow-duration="1s" data-wow-delay="0.3s" data-wow-offset="0">
			<h2 class="title_blog"><?php esc_html_e('404' , 'keeway-lite');?></h2>
			<p><?php echo esc_html(get_bloginfo( 'description', 'display' ));?></p>
		</div>
	</div>
</div>

<?php }


function keeway_lite_search_banner(){ 

?>

<div class="main_banner_area <?php if(get_header_image() ){ echo esc_attr('banner_image');}else{ echo esc_attr('banner_bg_color');}?>" <?php if(get_header_image() ){ ?> style="background: url(<?php header_image(); ?>)no-repeat;background-size:cover;  background-position: top top; background-attachment:scroll;" <?php } ?> >
	<div class="container">
		<div class="bannar_padding text-center" data-wow-duration="1s" data-wow-delay="0.3s" data-wow-offset="0">
			<h2 class="title_blog"><?php
				/* translators: %s: search query. */
				printf( esc_html__( 'Search Results for: %s', 'keeway-lite' ), '<span>' . get_search_query() . '</span>' );
				?>
				</h2>
			<p><?php echo esc_html(get_bloginfo( 'description', 'display' ));?></p>
		</div>
	</div>
</div>

<?php }


// Social Share Links
function keeway_lite_social_share_button(){
	// Get the current page URL
    $url = get_permalink();

    // Get the current page title
    $title = urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8'));

		// Social sharing URLs  
        $facebook = 'https://www.facebook.com/sharer/sharer.php?u=' . $url;
        $twitter =  'https://twitter.com/intent/tweet?url=' . $url . '&text=' . $title;
        $linkedIn = 'https://www.linkedin.com/sharing/share-offsite/?url=' . $url . '&title=' . $title;
        $pinterest = 'https://pinterest.com/pin/create/button/?url=' . $url . '&description=' . $title;
    
?>

	<div class="social_share_button">
		<span class="pull-left"><?php esc_html_e('Share This Post' , 'keeway-lite');?></span>
		<a href="<?php echo esc_url($facebook);?>" target="_blank" class="white"><i class="fa fa-facebook"></i></a>
		<a href="<?php echo esc_url($twitter);?>" target="_blank" class="white">
			<svg width="11" height="12" viewBox="0 0 11 12" fill="none"
				xmlns="http://www.w3.org/2000/svg">
				<path
					d="M6.55735 5.16157L10.5183 0.65625H9.57971L6.14039 4.56816L3.39341 0.65625H0.225098L4.37906 6.57174L0.225098 11.2963H1.16378L4.79579 7.16516L7.6968 11.2963H10.8651L6.55712 5.16157H6.55735ZM5.2717 6.62386L4.85082 6.03481L1.502 1.34768H2.94375L5.64629 5.13034L6.06717 5.71939L9.58015 10.6363H8.13839L5.2717 6.62409V6.62386Z"
					fill="white" />
			</svg>		
		</a>
		<a href="<?php echo esc_url($pinterest);?>" onclick="event.preventDefault();javascript:void( (function() {var e=document.createElement('script' );e.setAttribute('type','text/javascript' );e.setAttribute('charset','UTF-8' );e.setAttribute('src','//assets.pinterest.com/js/pinmarklet.js?r='+Math.random()*99999999);document.body.appendChild(e)})());" title="Pinterest" rel="nofollow noopener"><i class="fa fa-pinterest"></i></a>
		<a href="<?php echo esc_url($linkedIn);?>" target="_blank" class="white"><i class="fa fa-linkedin"></i></a>

</div>

<?php		
}