<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * Used for both singular and index.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @author  ClimaxThemes
 * @package Kata
 * @since   1.0.0
 */

// Don't load directly.
if (!defined('ABSPATH')) {
    exit;
}

?>

<section class="no-results not-found">
    <header class="page-header">
        <h1 class="page-title">
            <?php
            if (is_404()) {
                esc_html_e('404 Not Found', 'kata');
            } else {
                esc_html_e('Nothing Found', 'kata');
            }
            ?>
        </h1>
    </header><!-- .page-header -->

    <div class="page-content">
        <?php
        if (is_home() && current_user_can('publish_posts')) :

            printf(
                '<p>' . wp_kses(
                /* translators: 1: link to WP admin new post page. */
                    __('Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'kata'),
                    array(
                        'a' => array(
                            'href' => array(),
                        ),
                    )
                ) . '</p>',
                esc_url(admin_url('post-new.php'))
            );

        elseif (is_search()) : ?>
            <p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'kata'); ?></p>
            <div class="search-form-wrap kata-widget">
                <?php get_search_form(true); ?>
            </div>
        <?php
        elseif (is_404()) : ?>
            <p><?php esc_html_e('We couldn’t find the page your looking for.', 'kata'); ?></p>
            <div class="search-form-wrap kata-widget">
                <?php get_search_form(true); ?>
            </div>
        <?php
        else : ?>
            <p><?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'kata'); ?></p>
            <div class="search-form-wrap kata-widget">
                <?php get_search_form(true); ?>
            </div>
        <?php endif; ?>
    </div><!-- .page-content -->
</section><!-- .no-results -->
