<div class="widget kopa-list-posts-widget">
    <?php $single_cat_title = single_cat_title( '', false ); ?>
    <header class="widget-header">
        <?php if ( !empty($single_cat_title) ) : ?>
        <h3 class="widget-title"><?php echo single_cat_title( '', false ); ?></h3>
        <?php endif; ?>
        <i class="fa fa-plus-square-o"></i>
    </header>

    <div class="widget-content">
        <ul class="list-unstyled clearfix">
            <?php if ( have_posts() ) : ?>
            <?php while ( have_posts() ) : the_post(); ?>
                <?php
                $post_format = get_post_format();
                $post_link = get_permalink();
                $post_title = get_the_title();
                if ( false === $post_format ) {
                    $post_format = 'standard';
                }
                switch($post_format){
                    case 'gallery':
                        $fa_icon = 'fa-picture-o';
                        break;
                    case 'video':
                        $fa_icon = 'fa-picture-o';
                        break;
                    case 'audio':
                        $fa_icon = 'fa-headphones';
                        break;
                    default:
                        $fa_icon = 'fa-pencil';
                        break;
                }
                ?>

                <li class="item-outer" id="post-<?php the_ID(); ?>">
                    <div <?php post_class('item'); ?>>
                        <div class="item-inner  clearfix<?php if (!has_post_thumbnail()) echo ' no-thumb-blog';?>">
                            <div class="post-thumb pull-left">

                                <?php if ( has_post_thumbnail()) : ?>
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="img-responsive"><?php the_post_thumbnail('kopa-size-16'); ?></a>
                                <?php endif; ?>


                                <div class="kopa-date-box">
                                    <?php if ( empty($post_title) ) : ?>
                                        <a href="<?php the_permalink(); ?>" title="<?php esc_attr_e('View post detail', 'karo-light'); ?>">
                                    <?php endif; ?>
                                        <i class="fa <?php echo esc_attr( $fa_icon ); ?>"></i>
                                        <span class="kopa-mon"><?php karo_light_the_date_custom(get_the_ID(), 'M'); ?></span>
                                        <span class="kopa-day"><?php karo_light_the_date_custom(get_the_ID(), 'd');; ?></span>
                                        <span class="kopa-yea"><?php karo_light_the_date_custom(get_the_ID(), 'Y');; ?></span>
                                    <?php if ( empty($post_title) ) : ?>
                                        </a>
                                    <?php endif; ?>
                                </div>

                            </div>
                            <!-- post thumb -->
                            <div class="item-content item-right">

                                <h4 class="post-title">
                                    <?php
                                        if (!empty($post_title)) {
                                            echo '<a href="'. esc_url(get_permalink()) .'" title="'. esc_attr($post_title) .'">'. $post_title .'</a>';
                                        } else {
                                            echo '<a href="'. esc_url(get_permalink()) .'" title="'. esc_attr__('View post detail', 'karo-light') .'">'. esc_attr__('Post No Title', 'karo-light') .'</a>';
                                        }
                                    ?>
                                </h4>

                                <div class="kopa-metadata-border">
                                    <?php if ( comments_open() ) : ?>
                                        <?php comments_popup_link(__('<i class="fa fa-comment"></i> 0', 'karo-light'), esc_attr__('<i class="fa fa-comment"></i> 1', 'karo-light'), esc_attr__('<i class="fa fa-comment"></i> %', 'karo-light')); ?>
                                    <?php endif; ?>
                                </div>
                                <!-- metadata -->
                                <?php the_excerpt(); ?>

                            </div>
                            <!-- item content -->
                        </div>
                        <!-- item inner -->
                    </div>
                    <!-- item -->
                </li>
                <?php endwhile; ?>
            <?php else: ?>
            <li class="item-outer">
                <div class="item-inner  clearfix"><?php esc_attr_e('Nothing found', 'karo-light');?></div>
            </li>
            <?php endif; ?>
        </ul>
    </div>

    <?php get_template_part('templates/pagination'); ?>
</div>


