<article id="post-<?php the_ID(); ?>" <?php post_class('single-post-content'); ?>>
    <h1 class="entry-title"><?php the_title(); ?></h1>
    <div class="clearfix">
        <aside class="pull-left">
            <div class="entry-meta">
                <span class="kopa-user"><i class="fa fa-user"></i><?php esc_attr_e('By ', 'karo-light');?><?php the_author_posts_link(); ?></span>
                <?php if (comments_open()) : ?>
                <span><i class="fa fa-comment"></i> <?php comments_popup_link(__('0', 'karo-light'), esc_attr__('1', 'karo-light'), esc_attr__('%', 'karo-light')); ?></span>
                <?php endif; ?>
            </div>
            <!-- entry meta -->
            <div class="clearfix">
                <?php
                $category = get_the_category( get_the_ID() );
                if ( !empty($category[0]->cat_name)):
                    ?>
                    <h4 class="post-cat"><a href="<?php echo get_category_link( $category[0]->term_id ); ?>"><?php echo esc_attr( $category[0]->cat_name ); ?></a></h4>
                    <?php endif; ?>
                <span class="kopa-date"><?php the_time(get_option('date_format')); ?></span>
            </div>

            <?php the_tags( '<div class="tags-link"><span>' . esc_attr__( 'Tags: ', 'karo-light' ) . ' </span>', ', ', '</div>' ); ?>

        </aside>
        <div class="item-right article-content">
            <?php if ( has_post_thumbnail() && get_theme_mod('karo_light_options_featured_image_status', 'show') == 'show' ){ ?>
                <div class="post-thumb">
                    <?php the_post_thumbnail('large'); ?>
                </div>
                <?php }
            ?>
            <!-- post thumb -->
            <div class="entry-content">
                <?php the_content(); ?>
            </div>
            <!-- entry-content -->

            <?php
            $args = array(
                'before'           => '<div class="kopa-post-pagination"><span>' . esc_attr__( 'Pages:&nbsp; &nbsp;', 'karo-light' ) . '</span><span class="page-container">',
                'after'            => '</span></div>',
                'link_before'      => '',
                'link_after'       => '',
                'next_or_number'   => 'number',
                'separator'        => ' ',
                'nextpagelink'     => esc_attr__( 'Next page', 'karo-light' ),
                'previouspagelink' => esc_attr__( 'Previous page', 'karo-light' ),
                'pagelink'         => '%',
                'echo'             => 1
            );
            wp_link_pages($args);
            ?><!-- pagination in post -->
        </div>
        <!-- item right -->
    </div>
    <!-- clearfix -->
</article>

<?php karo_light_about_author(); ?>
<!-- kopa author -->

<?php karo_light_get_next_previous(); ?>
<!-- kopa navigation -->