/*
 * Custom js (for karo theme)
 * http://kopatheme.com
 * Copyright (c) 2014 Kopatheme
 *
 * Licensed under the GPL license:
 *  http://www.gnu.org/licenses/gpl.html
 */
/**
 *   1- Main menu
 *   2- Tabs
 *   3- Slider
 *   4- Masonry
 *   5- Carousel
 *   6- Back to top
 *   7- jQuery for css
 *   8- Search box
 *   9- Breadking
 *   10- Flickr
 *   11- Gallery widget
 *   12- Browser resize
 *-----------------------------------------------------------------
 **/

"use strict";
var kopa_variable = {
    "url": {
        "template_directory_uri": kopa_front_variable.url.template_directory_uri
    }
};

jQuery(document).ready(function () {
    // 1. Main menu
    if ( jQuery('#kopa-main-menu').length > 0 ){
        Modernizr.load([{
            load: [kopa_variable.url.template_directory_uri + '/js/superfish.js'],
            complete: function () {
                jQuery('#kopa-main-menu').superfish({
                    delay:500
                    // cssArrows:  false
                });
            }
        }]);
    }

    // 1.1 Mobile menu
    Modernizr.load([{
        load: [kopa_variable.url.template_directory_uri  + '/js/navgoco.js'],
        complete: function () {
            if ( jQuery(".kopa-menu.mobile-menu").length > 0 ){
                jQuery(".kopa-menu.mobile-menu").navgoco({accordion: true});
            }

            if ( jQuery('.mobile-menu-icon').length > 0 ){
                jQuery('.mobile-menu-icon').click(function(){
                    jQuery(".kopa-menu.mobile-menu").slideToggle( "slow" );
                });
            }
        }
    }]);

    // 2. Tabs
    if (jQuery('.kopa-tab-widget .kopa-tabs').length > 0) {
        if ( jQuery(".kopa-tabs").length > 0 ){
            jQuery(".kopa-tabs").tabs();
        }
    }

    if (jQuery('.kopa-list-post-tabs-widget .kopa-tabs').length > 0) {

        Modernizr.load([{
            load: [kopa_variable.url.template_directory_uri + '/js/imagesloaded.js'],
            complete: function () {
                var $container_ms = jQuery('.kopa-list-post-tabs-widget .masonry-content');
                $container_ms.imagesLoaded(function () {
                    $container_ms.masonry({
                        itemSelector: ".item-outer",
                        columnWidth: ".item-outer"
                    });
                });
                if ( jQuery(".kopa-tabs").length > 0 ){
                    jQuery(".kopa-tabs").tabs({
                        create: function (event, ui) {
                            jQuery(".kopa-list-post-tabs-widget .ui-tabs-panel").each(function (index) {
                                jQuery(this).find(".item-outer").each(function (index) {
                                    jQuery(this).addClass('item' + index);
                                });

                            });

                            jQuery(".kopa-tabs").find('.ui-tabs-nav .ui-tabs-anchor').click(function () {
                                $container_ms.masonry();
                            });
                        }
                    });
                }
            }
        }]);
    }

    // 3. Masonry
    if (jQuery('.kopa-list-posts-widget.style-2').length > 0) {
        Modernizr.load([{
            load: [kopa_variable.url.template_directory_uri + '/js/imagesloaded.js'],
            complete: function () {
                var $container_ms = jQuery('.kopa-list-posts-widget .widget-content');
                $container_ms.imagesLoaded(function () {
                    $container_ms.masonry({
                        itemSelector: ".item-outer",
                        columnWidth: ".item-outer"
                    });
                });
            }
        }]);
    }

    // 4. Carousel

    if (jQuery('.kopa-galler-post').length > 0) {
        Modernizr.load([{
            load: kopa_variable.url.template_directory_uri + '/js/owl.carousel.js',
            complete: function () {
                jQuery('.kopa-galler-post').owlCarousel({
                    singleItem: true
                });
            }
        }]);
    }

    if (jQuery('.kopa-thumb-big-carousel-widget .owl-carousel').length > 0) {

        jQuery('.kopa-thumb-big-carousel-widget .owl-carousel').each(function(){
            var $this = jQuery(this);
            var data_autoPlay = $this.data('autoplay');
            var data_slideSpeed = $this.data('slidespeed');
            console.log(data_autoPlay);
            console.log(data_slideSpeed);
            Modernizr.load([{
                load: kopa_variable.url.template_directory_uri + '/js/owl.carousel.js',
                complete: function () {
                    $this.owlCarousel({
                        singleItem: true,
                        slideSpeed: data_slideSpeed,
                        autoPlay: false,
                        stopOnHover: true,
                        navigation: true,
                        navigationText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>']
                    });
                }
            }]);

        });

    }

    if (jQuery('.kopa-list-posts-carousel-4-widget').length > 0) {
        Modernizr.load([{
            load: kopa_variable.url.template_directory_uri + '/js/owl.carousel.js',
            complete: function () {
                jQuery('.kopa-list-posts-carousel-4-widget .owl-carousel').owlCarousel({
                    items: 3,
                    itemsDesktop: [1180, 3],
                    itemsDesktopSmall: [980, 3],
                    itemsTablet: [767, 2],
                    slideSpeed: 700
                });
            }
        }]);
    }

    if (jQuery('.kopa-single-gallery-widget').length > 0) {
        Modernizr.load([{
            load: kopa_variable.url.template_directory_uri + '/js/owl.carousel.js',
            complete: function () {
                var sync1 = jQuery(".kopa-single-gallery-widget .sync1");
                var sync2 = jQuery(".kopa-single-gallery-widget .sync2");

                sync1.owlCarousel({
                    singleItem: true,
                    pagination: false,
                    navigation: true,
                    navigationText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                    slideSpeed: 1000,
                    afterAction: syncPosition,
                    responsiveRefreshRate: 200
                });


                sync2.owlCarousel({
                    items: 4,
                    itemsDesktop: [1199, 4],
                    itemsDesktopSmall: [979, 4],
                    itemsTablet: [768, 4],
                    itemsTabletSmall: [639, 4],
                    itemsMobile: [599, 4],
                    pagination: false,
                    responsiveRefreshRate: 100,
                    afterInit: function (el) {
                        el.find(".owl-item").eq(0).addClass("synced");
                    }
                });



                function syncPosition(el) {
                    var current = this.currentItem;
                    sync2.find(".owl-item").removeClass("synced").eq(current).addClass("synced")
                    if (sync2.data("owlCarousel") !== undefined) {
                        center(current)
                    }
                }

                sync2.on("click", ".owl-item", function (e) {
                    e.preventDefault();
                    var number = jQuery(this).data("owlItem");
                    sync1.trigger("owl.goTo", number);
                });

                function center(number) {
                    var sync2visible = sync2.data("owlCarousel").owl.visibleItems;
                    var num = number;
                    var found = false;
                    for (var i in sync2visible) {
                        if (num === sync2visible[i]) {
                            var found = true;
                        }
                    }

                    if (found === false) {
                        if (num > sync2visible[sync2visible.length - 1]) {
                            sync2.trigger("owl.goTo", num - sync2visible.length + 2)
                        } else {
                            if (num - 1 === -1) {
                                num = 0;
                            }
                            sync2.trigger("owl.goTo", num);
                        }
                    } else if (num === sync2visible[sync2visible.length - 1]) {
                        sync2.trigger("owl.goTo", sync2visible[1])
                    } else if (num === sync2visible[0]) {
                        sync2.trigger("owl.goTo", num - 1)
                    }

                }
            }
        }]);
    }

    // 5. Back to top
    jQuery(".back-to-top").hide();
    jQuery(window).scroll(function () {
        if (jQuery(this).scrollTop() > 100) {
            jQuery('.back-to-top').fadeIn();
        } else {
            jQuery('.back-to-top').fadeOut();
        }
    });

    jQuery('.back-to-top').click(function (event) {
        jQuery('body,html').animate({
            scrollTop: 0
        }, 800);
        event.preventDefault();
    })

    // 6. jQuery for css
    if (jQuery(".kopa-grid-posts-widget").length > 0) {
        jQuery(".kopa-grid-posts-widget .item").each(function (index) {
            jQuery(this).addClass('item' + index);
        });
    }

    if (jQuery(".kopa-list-item-carousel-widget").length > 0) {
        hover_effect();
    }

    if (jQuery(".kopa-media-widget").length > 0) {
        jQuery(".kopa-media-widget").each(function(){
            var $this = jQuery(this);
            $this.find(".item-post").each(function (index) {
                jQuery(this).addClass('item' + index);
            });
        });

    }

    if (jQuery(".kopa-list-posts-masonry-widget").length > 0) {
        jQuery(".kopa-list-posts-masonry-widget .item-outer").each(function (index) {
            jQuery(this).addClass('item' + index);
        });
    }
    if (jQuery(".kopa-list-posts-2-widget").length > 0) {
        jQuery(".kopa-list-posts-2-widget .item").each(function (index) {
            jQuery(this).addClass('item' + index);
        });
        jQuery(".kopa-list-posts-2-widget").each(function (index) {
            jQuery(this).find(".item").each(function (index) {
                jQuery(this).addClass('item' + index);
            });
        });
    }
    if (jQuery(".kopa-list-post-small-thumb-widget").length > 0) {
        jQuery(".kopa-list-post-small-thumb-widget .widget-content > ul > li:even").addClass('even');
    }

    // 7. Search box
    if (jQuery('.kopa-head-line').length > 0) {
        var $search = jQuery('.kopa-search-box .search-form');
        $search.find('span').click(function () {
            $search.find("input[type='text']").stop(true).animate({
                padding: '6px 12px',
                width: '200px'
            }, 500);
            $search.stop(true).animate({
                width: '236px'
            }, 500);
            $search.find('span').css('display', 'none');
            $search.find('button').css('display', 'block');
        });
    }

    // 8.Breadking
    if (jQuery('.ticker-1').length > 0) {
        Modernizr.load([{
            load: kopa_variable.url.template_directory_uri + '/js/caroufredsel.js',
            complete: function () {
                var _scroll = {
                    delay: 1000,
                    easing: 'linear',
                    items: 1,
                    duration: 0.07,
                    timeoutDuration: 0,
                    pauseOnHover: 'immediate'
                };
                jQuery('.ticker-1').carouFredSel({
                    width: 1000,
                    align: false,
                    items: {
                        width: 'variable',
                        height: 35,
                        visible: 1
                    },
                    scroll: _scroll
                });
            }
        }]);
    }
    // 9. Flickr
    if (jQuery('.flickr-wrap').length > 0) {
        Modernizr.load([{
            load: [kopa_variable.url.template_directory_uri + '/js/jflickrfeed.js', kopa_variable.url.template_directory_uri + '/js/imgliquid.js'],
            complete: function () {
                jQuery('.flickr-wrap').each(function () {
                    var $this = jQuery(this);
                    var limit = $this.data('limit');
                    var id = $this.data('id');

                    $this.jflickrfeed({
                        limit: limit,
                        qstrings: {
                            id: id
                        },
                        itemTemplate: '<li class="flickr-badge-image">' + '<a target="blank" href="{{link}}" title="{{title}}" class="imgLiquid">' + '<img src="{{image_m}}" alt="{{title}}"  />' + '</a>' + '</li>'
                    }, function (data) {
                        $this.find('.imgLiquid').imgLiquid();
                    });
                });
            }
        }]);
    }

    // 10. Gallery widget
    if (jQuery('.kopa-gallery-widget').length > 0) {
        Modernizr.load([{
            load: kopa_variable.url.template_directory_uri + '/js/imgliquid.js',
            complete: function () {
                jQuery('.kopa-gallery-widget .imgLiquid').imgLiquid();
            }
        }]);
    }
});

// 11. Browser resize
Modernizr.load([{
    load: kopa_variable.url.template_directory_uri + '/js/debouncedresize.js',
    complete: function () {
        jQuery(window).bind("debouncedresize", function () {
            hover_effect();
        });
    }
}]);

function hover_effect() {
    var window_width = jQuery(window).width();
    if (window_width > 1030) {
        jQuery('.kopa-list-item-carousel-widget .item-content').css('top', '307px');
        jQuery('.kopa-list-item-carousel-widget .item').hover(function () {
            jQuery(this).addClass('focus');
            jQuery(this).find('.item-content').stop(true).animate({
                top: '0'
            }, 500);
        }, function () {
            jQuery(this).removeClass('focus');
            jQuery(this).find('.item-content').stop(true).animate({
                top: '307px'
            }, 500);
        });
    } else if (window_width <= 1030 && window_width > 980) {
        jQuery('.kopa-list-item-carousel-widget .item-content').css('top', '250px');
        jQuery('.kopa-list-item-carousel-widget .item').hover(function () {
            jQuery(this).addClass('focus');
            jQuery(this).find('.item-content').stop(true).animate({
                top: '0'
            }, 500);
        }, function () {
            jQuery(this).removeClass('focus');
            jQuery(this).find('.item-content').stop(true).animate({
                top: '250px'
            }, 500);
        });
    } else if (window_width < 1023) {
        jQuery('.kopa-list-item-carousel-widget .item-content').css({
            top: 'auto',
            bottom: '0'
        });
        jQuery('.kopa-list-item-carousel-widget .item').hover(function () {
            jQuery(this).addClass('focus');
            jQuery(this).find('.item-content').stop(true).animate({
                top: 'auto'
            }, 500);
        }, function () {
            jQuery(this).removeClass('focus');
            jQuery(this).find('.item-content').stop(true).animate({
                top: 'auto'
            }, 500);
        });
    }
}

Modernizr.load([{
    load: kopa_variable.url.template_directory_uri + '/js/debouncedresize.js',
    complete: function () {
        jQuery(window).bind("debouncedresize", function () {
            console.log(jQuery(window).outerWidth());
            if (jQuery(window).outerWidth()>980) {
                jQuery("#kopa-mobile-menu").css('display','none');
            };
        });
    }
}]);