<?php

add_action( 'widgets_init', array('Kopa_Widget_Video', 'register_widget'));
	
class Kopa_Widget_Video extends Kopa_Widget {

	public $kpb_group = 'post';
	
	public static function register_widget(){
       register_widget('Kopa_Widget_Video');
    }
    
	public function __construct() {
		$this->widget_cssclass    = 'kopa-media-widget';
		$this->widget_description = esc_html__( 'Video list widget', 'karo-light' );
		$this->widget_id          = 'kopa_widget_video';
		$this->widget_name        = esc_html__( 'Kopa Widget List Video', 'karo-light' );
		$this->settings 		  = karo_light_get_post_widget_args();		

		parent::__construct();
	}

	public function widget( $args, $instance ) {	
		extract( $args );
		
		$instance = wp_parse_args((array) $instance, $this->get_default_instance());
		
		extract( $instance );

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);	
		
		echo wp_kses_post( $before_widget );

		$query = karo_light_get_post_widget_query($instance);
		
		$tax_query = array(
				'taxonomy' => 'post_format',
				'field'    => 'slug',
				'terms'    => array( 'post-format-video' ),
			);
		$query['tax_query'] = array($tax_query);

		$result_set = new WP_Query( $query );
		?>	
			<div class="widget kopa-media-widget">
	            <header class="widget-header">
	                <h3 class="widget-title"><?php echo esc_attr( $title ); ?></h3>
	                <i class="fa fa-plus-square-o"></i>
	            </header>

	            <div class="widget-content">
	                <?php if($result_set->have_posts()) : while ( $result_set->have_posts() ) : $result_set->the_post(); ?>
	                    <div class="item-post">
	                        <h4 class="post-title"><a href="<?php the_permalink(); ?>"><i class="fa fa-youtube-play"></i><?php the_title(); ?></a></h4>
	                    </div>
	                    <!-- item-post -->
	                <?php endwhile; endif; ?>
	            </div>
	        </div>
    	<?php
		wp_reset_postdata();

		echo wp_kses_post( $after_widget );
	}

}