<?php

add_action( 'widgets_init', array('Kopa_Widget_List_Gallery', 'register_widget'));
	
class Kopa_Widget_List_Gallery extends Kopa_Widget {

	public $kpb_group = 'post';
	
	public static function register_widget(){
       register_widget('Kopa_Widget_List_Gallery');
    }
    
	public function __construct() {
		$this->widget_cssclass    = 'kopa-gallery-widget';
		$this->widget_description = esc_html__( 'Show list posts (gallery format) of categories.', 'karo-light' );
		$this->widget_id          = 'kp-list-gallery-widget';
		$this->widget_name        = esc_html__( 'Kopa Widget List Galleries', 'karo-light' );
		$this->settings 		  = karo_light_get_post_widget_args();		

		parent::__construct();
	}

	public function widget( $args, $instance ) {	
		extract( $args );
		
		$instance = wp_parse_args((array) $instance, $this->get_default_instance());
		
		extract( $instance );

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);	
		
		echo wp_kses_post( $before_widget );

		$query = karo_light_get_post_widget_query($instance);
		$tax_query = array(
				'taxonomy' => 'post_format',
				'field'    => 'slug',
				'terms'    => array( 'post-format-gallery' ),
			);
		$query['tax_query'] = array($tax_query);

		$result_set = new WP_Query( $query );
		?>	
			<div class="widget kopa-gallery-widget">
	            <header class="widget-header">
	                <h3 class="widget-title"><?php echo esc_attr( $title ); ?></h3>
	                <i class="fa fa-plus-square-o"></i>
	            </header>
	            <div class="widget-content">
	                <?php if($result_set->have_posts()) : while ( $result_set->have_posts() ) : $result_set->the_post(); ?>
	                <?php if ( has_post_thumbnail() ) : ?>
	                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="imgLiquid"><?php the_post_thumbnail('kopa-size-15'); ?></a>
	                    <?php endif; ?>
	                <?php endwhile; endif; ?>
	            </div>
	        </div>
    	<?php
		wp_reset_postdata();

		echo wp_kses_post( $after_widget );
	}

}