<?php

add_action( 'widgets_init', array('Kopa_Widget_Flickr', 'register_widget'));

class Kopa_Widget_Flickr extends Kopa_Widget {

	public $kpb_group = 'Ads';
	public $lines = array();

	public static function register_widget(){
		register_widget('Kopa_Widget_Flickr');
	}

	public function __construct() {
		$this->widget_cssclass    = 'kopa-flickr-widget';
		$this->widget_description = esc_html__( 'Display list images of user from Flickr API.', 'karo-light' );
		$this->widget_id          = 'kopa_widget_flickr';
		$this->widget_name        = esc_html__( 'Kopa Widget Flickr', 'karo-light' );
		
		$this->settings           = array(	
			'title'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Title:', 'karo-light')
			),		
			'id'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'ID:', 'karo-light')
			),			
			'limit'  => array(
				'type'  => 'number',
				'std'   => '5',
				'label' => esc_html__( 'Limit:', 'karo-light' )
			)
		);

		parent::__construct();
	}

	public function widget( $args, $instance ) {	

		extract( $args );

		$instance = wp_parse_args((array) $instance, $this->get_default_instance());

		extract( $instance );

		$out = '<div class="widget-content">';
        $out .= sprintf('<div class="flickr-wrap clearfix" data-user="%s" data-limit="%s">', $id, $limit);
        $out .= '<ul class="clearfix list-unstyled"></ul>';
        $out .= '</div></div>';
        echo wp_kses_post( $before_widget );
        if (!empty($title)) { ?>

        <header class="widget-header">
            <h3 class="widget-title"><?php echo esc_attr( $title );?></h3>
            <i class="fa fa-plus-square-o"></i>
        </header>

        <?php }
        echo apply_filters('kopa_flickr_widget', $out);
        echo wp_kses_post( $after_widget );

	}

}