<?php

add_action( 'widgets_init', array('Kopa_Widget_Feedburner_Subscribe', 'register_widget'));

class Kopa_Widget_Feedburner_Subscribe extends Kopa_Widget {

	public $kpb_group = 'Ads';
	public $lines = array();

	public static function register_widget(){
		register_widget('Kopa_Widget_Feedburner_Subscribe');
	}

	public function __construct() {
		$this->widget_cssclass    = 'kopa-newletter-widget';
		$this->widget_description = esc_html__( 'Display Feedburner subscription form.', 'karo-light' );
		$this->widget_id          = 'kopa_widget_feedburner_subscribe';
		$this->widget_name        = esc_html__( 'Kopa Feedburner Subscribe', 'karo-light' );
		
		$this->settings           = array(	
			'title'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Title:', 'karo-light')
			),	
			'feedburner_id'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Feedburner ID:', 'karo-light')
			),		
			'submit_btn_text'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Submit Button Text:', 'karo-light')
			),			
			'placeholder'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Placeholder:', 'karo-light' )
			),			
			'description'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Description:', 'karo-light' )
			)
		);

		parent::__construct();
	}

	public function widget( $args, $instance ) {	

		extract( $args );

		$instance = wp_parse_args((array) $instance, $this->get_default_instance());

		extract( $instance );

		$submit_btn_text = ! empty( $instance['submit_btn_text'] ) ? $instance['submit_btn_text'] : esc_attr__( 'Signup', 'karo-light' );
        $placeholder = ! empty( $instance['placeholder'] ) ? $instance['placeholder'] : esc_attr__( 'Enter your email address ...', 'karo-light' );

        echo wp_kses_post( $before_widget );
        ?>
    	    <div class="widget-content">
		        <form action="http://feedburner.google.com/fb/a/mailverify" method="post" class="form-news-letter" target="popupwindow" onsubmit="window.open('http://feedburner.google.com/fb/a/mailverify?uri=<?php echo esc_attr( $feedburner_id ); ?>', 'popupwindow', 'scrollbars=yes,width=550,height=520'); return true;">
		            <input type="hidden" value="<?php echo esc_attr( $feedburner_id ); ?>" name="uri">
		            <input type="text" onfocus="if(this.value==this.defaultValue)this.value='';" onblur="if(this.value=='')this.value=this.defaultValue;" name="email" value="<?php echo esc_attr( $placeholder ); ?>" class="email" size="40">
		            <button type="submit" class="fa fa-envelope"></button>
		            <div id="newsletter-response"></div>
		            <p><?php echo esc_attr( $description ); ?></p>
		        </form>
		    </div>
        <?php 
        echo wp_kses_post( $after_widget );

	}

}