<?php

add_action( 'widgets_init', array('Kopa_Widget_Articles_List', 'register_widget'));
	
class Kopa_Widget_Articles_List extends Kopa_Widget {

	public $kpb_group = 'post';
	
	public static function register_widget(){
       register_widget('Kopa_Widget_Articles_List');
    }
    
	public function __construct() {
		$this->widget_cssclass    = 'kp-article-list-widget';
		$this->widget_description = esc_html__( 'Article list widget.', 'karo-light' );
		$this->widget_id          = 'kopa_widget_article_list';
		$this->widget_name        = esc_html__( 'Kopa Widget Article List', 'karo-light' );
		$this->settings 		  = karo_light_get_post_widget_args();		

		parent::__construct();
	}

	public function widget( $args, $instance ) {	
		extract( $args );
		
		$instance = wp_parse_args((array) $instance, $this->get_default_instance());
		
		extract( $instance );

		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);	
		
		echo wp_kses_post( $before_widget );
		
		$query = karo_light_get_post_widget_query($instance);
		
		$result_set = new WP_Query( $query );
		?>	
			<div class="widget kopa-list-posts-thumb-medium-widget">
		        <header class="widget-header">
		            <h3 class="widget-title"><?php echo esc_attr( $title ); ?></h3>
		            <i class="fa fa-plus-square-o"></i>
		        </header>
		        <div class="widget-content">
		            <?php $i=0;?>
		            <?php while ( $result_set->have_posts() ) :
		                $result_set->the_post();
		                $post_title = get_the_title();
		            ?>
		            <div class="item-post<?php if($i%2==0) echo ' clearleft';?>">
		                <a href="<?php the_permalink(); ?>" title="<?php the_title();?>" class="post-thumb img-responsive">
		                    <?php
		                        $post_thumbnail = get_the_post_thumbnail(get_the_ID(), 'kopa-size-13');
		                        if ( empty($post_thumbnail) ){
		                            $post_thumbnail = get_template_directory_uri().'/images/no-thumbnail.jpg';
		                            echo '<img src="'. $post_thumbnail .'" alt="' . get_the_title(get_the_ID()) .'" title="' . get_the_title(get_the_ID()) .'" />';
		                        }else{
		                            echo wp_kses_post( $post_thumbnail );
		                        }
		                    ?>
		                    <div class="mask2"></div>
		                </a>
		                <?php if (!empty($post_title)):?>
		                <div class="item-content">
		                    <h4 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title();?></a></h4>
		                </div>
		                <?php endif; ?>
		                <!-- item-content -->
		            </div>
		            <!-- item-post -->
		            <?php $i++;?>
		            <?php endwhile; ?>
		        </div>
		    </div>
    	<?php
		wp_reset_postdata();

		echo wp_kses_post( $after_widget );
	}

}