<?php

add_action( 'widgets_init', array('Kopa_Widget_Article_Single', 'register_widget'));
	
class Kopa_Widget_Article_Single extends Kopa_Widget {

	public $kpb_group = 'post';
	
	public static function register_widget(){
       register_widget('Kopa_Widget_Article_Single');
    }
    
	public function __construct() {
		$this->widget_cssclass    = 'kopa-single-post-widget';
		$this->widget_description = esc_html__( 'Display first article of blog by specific conditions.', 'karo-light' );
		$this->widget_id          = 'kopa_widget_article_single';
		$this->widget_name        = esc_html__( 'Kopa Widget Article Single', 'karo-light' );
		$this->settings 		  = karo_light_get_post_widget_args();		

		parent::__construct();
	}

	public function widget( $args, $instance ) {	
		extract( $args );
		
		$instance = wp_parse_args((array) $instance, $this->get_default_instance());
		
		extract( $instance );
		
		echo wp_kses_post( $before_widget );
		
		$query = karo_light_get_post_widget_query($instance);
		
		$result_set = new WP_Query( $query );
				
		if ( $result_set->have_posts() ) :			
			while ( $result_set->have_posts() ) : $result_set->the_post(); ?>

		        <div class="widget-content">
		            <div class="item">
		                <div class="post-thumb">
		                    <?php if ( has_post_thumbnail() ) : ?>
		                    <a href="<?php the_permalink(); ?>" class="img-responsive" title="<?php the_title();?>"><?php the_post_thumbnail('kopa-size-01'); ?></a>
		                    <?php endif; ?>
		                </div>
		                <!-- post thumb -->
		                <div class="kopa-metadata">
		                    <span class="kopa-date"><?php the_time( get_option('date_format') ); ?></span>
		                </div>
		                <!-- metadata -->
		                <div class="item-content">
		                    <h4 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title();?></a></h4>
		                    <div class="post-content">
		                        <?php the_excerpt(); ?>
		                    </div>
		                </div>
		            </div>
		            <!-- item -->
		        </div>

        	<?php 
        	endwhile;
		endif;

		wp_reset_postdata();

		echo wp_kses_post( $after_widget );
	}

}