<?php

add_action( 'widgets_init', array('Kopa_Widget_Advertising', 'register_widget'));

class Kopa_Widget_Advertising extends Kopa_Widget {

	public $kpb_group = 'Ads';
	public $lines = array();

	public static function register_widget(){
		register_widget('Kopa_Widget_Advertising');
	}

	public function __construct() {
		$this->widget_cssclass    = 'kopa-ads-widget';
		$this->widget_description = esc_html__( 'A widget that displays an advertising image.', 'karo-light' );
		$this->widget_id          = 'kopa_widget_advertising';
		$this->widget_name        = esc_html__( 'Kopa Advertising Widget', 'karo-light' );
		
		$this->settings           = array(	
			'title'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'Title:', 'karo-light')
			),		
			'url'  => array(
				'type'  => 'text',
				'std'   => '',
				'label' => esc_html__( 'URL:', 'karo-light')
			),
			'target'  => array(
				'type'  => 'select',
				'std'   => '_blank',
				'label' => esc_html__( 'Target:', 'karo-light'),
				'options' => array(
					'_self'  => esc_html__('Open in current tab', 'karo-light'),
					'_blank' => esc_html__('Open in new tab', 'karo-light')
				)
			),				
			'image'  => array(
				'type'  => 'upload',
				'std'   => '',
				'mimes' => 'image',
				'label' => esc_html__( 'Upload your image:', 'karo-light' )
			)
		);

		parent::__construct();
	}

	public function widget( $args, $instance ) {	

		extract( $args );

		$instance = wp_parse_args((array) $instance, $this->get_default_instance());

		extract( $instance );

		echo wp_kses_post( $before_widget );

		if ( !empty( $title ) ) { echo wp_kses_post( $before_title . $title . $after_title ); } ?>

		    <div class="widget-content">
				<a href="<?php echo esc_url( $url ); ?>" target="<?php echo esc_attr( $target ); ?>">
					<img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
				</a>
		    </div>
       	
		<?php
		echo  wp_kses_post( $after_widget );

	}

}