<?php

add_filter( 'kopa_sidebar_default', 'karo_light_set_sidebar_default' );

function karo_light_set_sidebar_default( $options ) {
    $options['sidebar_hide']      = array(
        'name' => esc_html__( '-- None --', 'karo-light' ),
    );
    $options['right_sidebar_for_blog']      = array(
        'name' => esc_html__( 'Right sidebar for blog', 'karo-light' ),
    );
    $options['footer_1']      = array(
        'name' => esc_html__( 'Footer 1', 'karo-light' ),
    );
    $options['footer_2']      = array(
        'name' => esc_html__( 'Footer 2', 'karo-light'),
    );
    $options['footer_3']      = array(
        'name' => esc_html__( 'Footer 3', 'karo-light'),
    );
    $options['footer_4']      = array(
        'name' => esc_html__( 'Footer 4', 'karo-light'),
    );
    $options['page_full_width_content_sidebar']      = array(
        'name' => esc_html__( 'Page full width content sidebar', 'karo-light' ),
    );
    $options['page_left_content_sidebar']      = array(
        'name' => esc_html__( 'Page left content sidebar', 'karo-light' ),
    );
    $options['page_right_content_sidebar']      = array(
        'name' => esc_html__( 'Page right content sidebar', 'karo-light' ),
    );
    $options['page_middle_content_sidebar']      = array(
        'name' => esc_html__( 'Page middle content sidebar', 'karo-light' ),
    );

	return  apply_filters( 'karo_light_set_sidebar_default', $options );
}

add_filter( 'kopa_sidebar_default_attributes', 'karo_light_set_sidebar_default_attributes' );

function karo_light_set_sidebar_default_attributes($wrap) {
	$wrap['before_widget'] = '<div id="%1$s" class="widget %2$s">';
	$wrap['after_widget']  = '</div>';
	$wrap['before_title']  = '<h2 class="widget-title"><span></span>';
	$wrap['after_title']   = '</h2>';

	return $wrap;
}

function karo_light_set_sidebar($sidebar, $position){
    global $karo_light_current_layout;

    if(!isset($karo_light_current_layout) || empty($karo_light_current_layout)){
        $karo_light_current_layout = forceful_lite_get_template_setting();
    }

    if(isset($karo_light_current_layout['sidebars'][$position])){
        $sidebar = $karo_light_current_layout['sidebars'][$position];
    }

    return $sidebar;
}

add_action( 'widgets_init', 'karo_light_widgets_init' );
function karo_light_widgets_init(){
   /**
    * Creates a sidebar
    * @param string|array  Builds Sidebar based off of 'name' and 'id' values.
    */
    $args = array(
        'name'          => esc_html__( 'Sidebar Extra', 'karo-light' ),
        'id'            => 'sidebar_extra',
        'description'   => '',
        'class'         => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title"><span></span>',
        'after_title'   => '</h2>'
    );

    register_sidebar( $args );
}
