<?php

add_filter( 'kopa_layout_manager_settings', 'karo_light_register_layouts');

function karo_light_get_positions(){
	return apply_filters('karo_light_get_positions', array(
		'position_1'  => esc_html__( 'WIDGET AREA 1', 'karo-light' ),
		'position_2'  => esc_html__( 'WIDGET AREA 2', 'karo-light' ),
		'position_3'  => esc_html__( 'WIDGET AREA 3', 'karo-light' ),
		'position_4'  => esc_html__( 'WIDGET AREA 4', 'karo-light' ),
		'position_5'  => esc_html__( 'WIDGET AREA 5', 'karo-light' ),
		'position_6'  => esc_html__( 'WIDGET AREA 6', 'karo-light' ),
		'position_7'  => esc_html__( 'WIDGET AREA 7', 'karo-light' ),
		'position_8'  => esc_html__( 'WIDGET AREA 8', 'karo-light' ),
		'position_9'  => esc_html__( 'WIDGET AREA 9', 'karo-light' )
	));
}

function karo_light_get_sidebars(){
	return apply_filters('karo_light_get_sidebars', array(
		'position_1'  => 'right_sidebar_for_blog',
		'position_2'  => 'footer_1',
		'position_3'  => 'footer_2',
		'position_4'  => 'footer_3',
		'position_5'  => 'footer_4',
		'position_6'  => 'page_full_width_content_sidebar',
		'position_7'  => 'page_left_content_sidebar',
		'position_8'  => 'page_right_content_sidebar',
		'position_9'  => 'page_middle_content_sidebar'
	));
}

function karo_light_register_layouts( $options ) {
	$positions = karo_light_get_positions();
	$sidebars  = karo_light_get_sidebars();

	$blog_sidebar = array(
		'title'     => esc_html__( 'Blog 1', 'karo-light' ),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/blog-1.png',
		'positions' => array(
			'position_1',
            'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);

	$media_page_sidebar = array(
		'title'     => esc_html__( 'Media Page', 'karo-light' ),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/media-page.png',
		'positions' => array(
			'position_7',
            'position_8',
            'position_9',
            'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);

	$media_page_sidebar = array(
		'title'     => esc_html__( 'Media Page', 'karo-light' ),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/media-page.png',
		'positions' => array(
			'position_7',
            'position_8',
            'position_9',
            'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);

	$fullwidth_page_sidebar = array(
		'title'     => esc_html__( 'Fullwidth Page', 'karo-light' ),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/fullwidth-page.png',
		'positions' => array(
			'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);
	
	$sidebar_page_sidebar = array(
		'title'     => esc_html__( 'Page With Sidebar', 'karo-light' ),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/sidebar-page.png',
		'positions' => array(
			'position_1',
            'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);

	$single_sidebar = array(
		'title'     => esc_html__( 'Single', 'karo-light' ),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/single.png',
		'positions' => array(
			'position_1',
            'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);

	$error_404 = array(
		'title'     => esc_html__('404 Page', 'karo-light'),
		'preview'   => get_template_directory_uri() . '/inc/assets/images/layouts/error-404.png',
		'positions' => array(
			'position_2',
            'position_3',
            'position_4',
            'position_5'
		)
	);

	#1: Blog
	$options['blog-layout']['positions'] = $positions;
	$options['blog-layout']['layouts'] = array(
		'blog-1'   => $blog_sidebar
	);
	$options['blog-layout']['default'] = array(
		'layout_id' => 'blog-1',
		'sidebars'  => array(
			'blog-1'   => $sidebars
		)
	);

	#2: Single
	$options['post-layout']['positions'] = $positions;
	$options['post-layout']['layouts'] = array(
		'single'   => $single_sidebar
	);
	$options['post-layout']['default'] = array(
		'layout_id' => 'single',
		'sidebars'  => array(
			'single'   => $sidebars
		)
	);

	#3: Page
	$options['page-layout']['positions'] = $positions;
    $options['page-layout']['layouts'] = array(
		'media-page'     => $media_page_sidebar,
		'fullwidth-page' => $fullwidth_page_sidebar,
		'sidebar-page'   => $sidebar_page_sidebar,
    );
    $options['page-layout']['default'] = array(
		'layout_id' => 'sidebar-page',
		'sidebars'  => array(
			'media-page'     => $sidebars,
			'fullwidth-page' => $sidebars,
			'sidebar-page'   => $sidebars,
        )
    );

    #4: Front Page
    $options['frontpage-layout']['positions'] = $positions;
    $options['frontpage-layout']['layouts'] = array(
        'sidebar-page' => $sidebar_page_sidebar
    );
    $options['frontpage-layout']['default'] = array(
		'layout_id' => 'sidebar-page',
		'sidebars'  => array(
            'sidebar-page' => $sidebars
        )
    );

	#5: Search Page
    $options['search-layout']['positions'] = $positions;
    $options['search-layout']['layouts'] = array(
        'blog-1'   => $blog_sidebar
    );

    $options['search-layout']['default'] = array(
		'layout_id' => 'blog-1',
		'sidebars'  => array(
            'blog-1'   => $sidebars
        )
	);

	#6: Error 404
    $options['error404-layout']['positions'] = $positions;
    $options['error404-layout']['layouts'] = array(
        'error-404' => $error_404
    );

    $options['error404-layout']['default'] = array(
		'layout_id' => 'error-404',
		'sidebars'  => array(
            'error-404' => $sidebars
        )
    );

	return $options;
}
