<?php
if ( class_exists('Kopa_Framework') ){
    add_filter( 'kopa_current_tab_default', 'karo_light_set_default_tab');
    add_filter( 'kopa_settings_theme_options_enable', '__return_false' );
}

function karo_light_set_default_tab($key) {
    return 'sidebar-manager'; // layout-manager, backup-manager
}

add_action('after_setup_theme', 'karo_light_after_setup_theme');

function karo_light_after_setup_theme() {
    add_theme_support('post-formats', array('gallery', 'audio', 'video'));
    add_theme_support('post-thumbnails');
    add_theme_support( 'title-tag' );
    add_theme_support('loop-pagination');
    add_theme_support('automatic-feed-links');
    add_theme_support('editor_style');
    add_editor_style('editor-style.css');
    load_theme_textdomain('karo-light', get_template_directory() . '/languages');


    register_nav_menus(array(
        'top-nav'    => esc_attr__('Top Menu', 'karo-light'),
        'main-nav'   => esc_attr__('Main Menu', 'karo-light'),
        'footer-nav' => esc_attr__('Footer Menu', 'karo-light')
    ));

    if (!is_admin()) {
        add_action('wp_enqueue_scripts', 'karo_light_front_enqueue_scripts');
        add_filter('body_class', 'karo_light_body_class');
        add_filter('get_the_excerpt','karo_light_excerpt');
    }
    $sizes = array(
        'kopa-size-01'    => array(799, 440, true, esc_attr__('kopa size 799 x 440 (Kopatheme)', 'karo-light')),
        'kopa-size-02'    => array(799, 514, true, esc_attr__('kopa size 799 x 514 (Kopatheme)', 'karo-light')),
        'kopa-size-13'    => array(185, 202, true, esc_attr__('kopa size 185 x 202 (Kopatheme)', 'karo-light')),
        'kopa-size-14'    => array(83, 70, true, esc_attr__('kopa size 83 x 70 (Kopatheme)', 'karo-light')),
        'kopa-size-15'    => array(118, 118, true, esc_attr__('kopa size 118 x 118 (Kopatheme)', 'karo-light')),
        'kopa-size-28'    => array(594, 342, true, esc_attr__('kopa size 594 x 342 (Kopatheme)', 'karo-light')),
        'kopa-size-29'    => array(185, 78, true, esc_attr__('kopa size 185 x 78 (Kopatheme)', 'karo-light')),
        'kopa-size-30'    => array(281, 208, true, esc_attr__('kopa size 281 x 208 (Kopatheme)', 'karo-light')),
        'kopa-size-31'    => array(231, 134, true, esc_attr__('kopa size 231 x 134 (Kopatheme)', 'karo-light')) ,
        'kopa-size-32'    => array(252, 140, true, esc_attr__('kopa size 252 x 140 (Kopatheme)', 'karo-light'))
    );

    apply_filters('karo_light_get_image_sizes', $sizes);

    foreach ($sizes as $slug => $details) {
        add_image_size($slug, $details[0], $details[1], $details[2]);
    }

    global $content_width;
    if (!isset($content_width))
        $content_width = 806;
}

function karo_light_front_enqueue_scripts() {
    if (!is_admin()) {
        global $wp_styles, $is_IE;

        $dir = get_template_directory_uri();
        /* STYLESHEETs */
        wp_enqueue_style('kopa-google-font', 'http://fonts.googleapis.com/css?family=Oswald:400,300,700', array(), NULL);
        wp_enqueue_style('kopa-font-awesome', $dir . '/css/font-awesome.css');
        wp_enqueue_style('kopa-owl.carousel', $dir . '/css/owl.carousel.css');
        wp_enqueue_style('kopa-jquery-ui', $dir . '/css/jquery-ui.css');
        wp_enqueue_style('kopa-reset', $dir . '/css/reset.css');
        wp_enqueue_style('kopa-grid', $dir . '/css/grid.css');
        wp_enqueue_style('kopa-superfish', $dir . '/css/superfish.css');
        wp_enqueue_style('kopa-bxslider', $dir . '/css/bxslider.css');
        wp_enqueue_style('kopa-navgoco', $dir . '/css/navgoco.css');
        wp_enqueue_style('kopa-extra', $dir . '/css/extra.css');
        wp_enqueue_style('kopa-style', get_stylesheet_uri());
        wp_enqueue_style('kopa-responsive', $dir . '/css/responsive.css');

        if ($is_IE) {
            wp_register_style('kopa-ie', $dir . '/css/ie.css', array(), NULL);
            $wp_styles->add_data('kopa-ie', 'conditional', 'lt IE 9');
            wp_enqueue_style('kopa-ie');
        }
        /* JAVASCRIPTs */
        wp_enqueue_script('modernizr.custom', $dir . '/js/modernizr.custom.js', array('jquery'), null);
        wp_localize_script('jquery', 'kopa_front_variable', karo_light_front_localize_script());
        wp_enqueue_script('jquery-masonry');
        wp_enqueue_script('hoverIntent');
        wp_enqueue_script( 'jquery-ui-tabs' );

        wp_enqueue_script('kopa-custom-js', $dir . '/js/custom.js', array('jquery'), null, true);
        if (is_single() || is_page()) {
            wp_enqueue_script('comment-reply');
        }
    }
}

function karo_light_front_localize_script() {
    $kopa_variable = array(
        'ajax' => array(
            'url' => admin_url('admin-ajax.php')
        ),
        'template' => array(
            'post_id' => (is_singular()) ? get_queried_object_id() : 0
        ),
        'url' => array(
            'template_directory_uri' => get_template_directory_uri(),
        )
    );
    return $kopa_variable;
}

function karo_light_get_template_setting($default = null) {
    if(function_exists('kopa_get_template_setting')){
        return kopa_get_template_setting();
    }

    return $default;
}

function karo_light_breadcrumb() {
    // get show/hide option
    $karo_light_breadcrumb_status = get_theme_mod('karo_light_options_breadcrumb_status', 'show');

    if ( $karo_light_breadcrumb_status != 'show' ) {
        return;
    }

    if (is_main_query()) {
        global $post, $wp_query;

        $prefix = '&nbsp;/&nbsp;';
        $current_class = 'current-page';
        $description = '';
        $breadcrumb_before = '<div class="kopa-breadcrumb">';
        $breadcrumb_after = '</div>';
        $breadcrumb_home = '<span class="kopa-brf">'.__('You are here: ', 'karo-light') .'</span> <span itemscope itemtype="http://data-vocabulary.org/Breadcrumb"><a itemprop="url" href="' . home_url() . '"><span itemprop="title">' . esc_attr__('Home', 'karo-light') . '</span></a></span>';
        $breadcrumb = '';
        ?>

    <?php
        if (is_home()) {
            $breadcrumb.= $breadcrumb_home;
            if ( get_option( 'page_for_posts' ) ) {
                $breadcrumb.= $prefix . sprintf('<span itemscope itemtype="http://data-vocabulary.org/Breadcrumb" class="%1$s">%2$s</span>', $current_class, get_the_title(get_option('page_for_posts')));
            } else {
                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, esc_attr__('Blog', 'karo-light'));
            }
        } else if (is_post_type_archive('product') && get_option('woocommerce_shop_page_id')) {
            $breadcrumb.= $breadcrumb_home;
            $breadcrumb.= $prefix . sprintf('<span itemscope itemtype="http://data-vocabulary.org/Breadcrumb" class="%1$s">%2$s</span>', $current_class, get_the_title(get_option('woocommerce_shop_page_id')));
        } else if (is_tag()) {
            $breadcrumb.= $breadcrumb_home;

            $term = get_term(get_queried_object_id(), 'post_tag');
            $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, $term->name);
        } else if (is_category()) {
            $breadcrumb.= $breadcrumb_home;

            $category_id = get_queried_object_id();
            $terms_link = explode(',', substr(get_category_parents(get_queried_object_id(), TRUE, ','), 0, (strlen(',') * -1)));
            $n = count($terms_link);
            if ($n > 1) {
                for ($i = 0; $i < ($n - 1); $i++) {
                    $breadcrumb.= $prefix . $terms_link[$i];
                }
            }
            $breadcrumb.= $prefix . sprintf('<span class="%1$s" itemprop="title">%2$s</span>', $current_class, get_the_category_by_ID(get_queried_object_id()));

        } else if (is_single()) {
            $breadcrumb.= $breadcrumb_home;

            if ( get_post_type() === 'product' ) :

                $breadcrumb .= $prefix . '<a href="'.get_page_link( get_option('woocommerce_shop_page_id') ).'">'.get_the_title( get_option('woocommerce_shop_page_id') ).'</a>';

                if ($terms = get_the_terms( $post->ID, 'product_cat' )) :
                    $term = apply_filters( 'jigoshop_product_cat_breadcrumb_terms', current($terms), $terms);
                    $parents = array();
                    $parent = $term->parent;
                    while ($parent):
                        $parents[] = $parent;
                        $new_parent = get_term_by( 'id', $parent, 'product_cat');
                        $parent = $new_parent->parent;
                    endwhile;
                    if(!empty($parents)):
                        $parents = array_reverse($parents);
                        foreach ($parents as $parent):
                            $item = get_term_by( 'id', $parent, 'product_cat');
                            $breadcrumb .= $prefix . '<a href="' . get_term_link( $item->slug, 'product_cat' ) . '">' . $item->name . '</a>';
                        endforeach;
                    endif;
                    $breadcrumb .= $prefix . '<a href="' . get_term_link( $term->slug, 'product_cat' ) . '">' . $term->name . '</a>';
                endif;

                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, get_the_title());

            else :

                $categories = get_the_category(get_queried_object_id());
                if ($categories) {
                    foreach ($categories as $category) {
                        $breadcrumb.= $prefix . sprintf('<a href="%1$s">%2$s</a>', get_category_link($category->term_id), $category->name);
                    }
                }

                $post_id = get_queried_object_id();
                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, get_the_title($post_id));

            endif;

        } else if (is_page()) {
            if (!is_front_page()) {
                $post_id = get_queried_object_id();
                $breadcrumb.= $breadcrumb_home;
                $post_ancestors = get_post_ancestors($post);
                if ($post_ancestors) {
                    $post_ancestors = array_reverse($post_ancestors);
                    foreach ($post_ancestors as $crumb)
                        $breadcrumb.= $prefix . sprintf('<a href="%1$s">%2$s</a>', get_permalink($crumb), get_the_title($crumb));
                }
                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, get_the_title(get_queried_object_id()));
            }
        } else if (is_year() || is_month() || is_day()) {
            $breadcrumb.= $breadcrumb_home;

            $date = array('y' => NULL, 'm' => NULL, 'd' => NULL);

            $date['y'] = get_the_time('Y');
            $date['m'] = get_the_time('m');
            $date['d'] = get_the_time('j');

            if (is_year()) {
                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, $date['y']);
            }

            if (is_month()) {
                $breadcrumb.= $prefix . sprintf('<a href="%1$s">%2$s</a>', get_year_link($date['y']), $date['y']);
                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, date_i18n('F', $date['m']));
            }

            if (is_day()) {
                $breadcrumb.= $prefix . sprintf('<a href="%1$s">%2$s</a>', get_year_link($date['y']), $date['y']);
                $breadcrumb.= $prefix . sprintf('<a href="%1$s">%2$s</a>', get_month_link($date['y'], $date['m']), date_i18n('F', $date['m']));
                $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, $date['d']);
            }

        } else if (is_search()) {
            $breadcrumb.= $breadcrumb_home;

            $s = get_search_query();
            $c = $wp_query->found_posts;

            $description = sprintf(__('<span class="%1$s">Your search for "%2$s"', 'karo-light'), $current_class, $s);
            $breadcrumb .= $prefix . $description;
        } else if (is_author()) {
            $breadcrumb.= $breadcrumb_home;
            $author_id = get_queried_object_id();
            $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</a>', $current_class, sprintf(__('Posts created by %1$s', 'karo-light'), get_the_author_meta('display_name', $author_id)));
        } else if (is_404()) {
            $breadcrumb.= $breadcrumb_home;
            $breadcrumb.= $prefix . sprintf('<span class="%1$s">%2$s</span>', $current_class, esc_attr__('Error 404', 'karo-light'));
        }

        if ($breadcrumb)
            echo apply_filters('kopa_breadcrumb', $breadcrumb_before . $breadcrumb . $breadcrumb_after);
    }
}

function kopa_content_get_gallery_attachment_ids($content) {
    $gallery = kopa_content_get_gallery($content);

    if (isset($gallery[0])) {
        $gallery = $gallery[0];
    } else {
        return '';
    }

    if (isset($gallery['shortcode'])) {
        $shortcode = $gallery['shortcode'];
    } else {
        return '';
    }

    // get gallery string ids
    preg_match_all('/ids=\"(?:\d+,*)+\"/', $shortcode, $gallery_string_ids);
    if (isset($gallery_string_ids[0][0])) {
        $gallery_string_ids = $gallery_string_ids[0][0];
    } else {
        return '';
    }

    // get array of image id
    preg_match_all('/\d+/', $gallery_string_ids, $gallery_ids);
    if (isset($gallery_ids[0])) {
        $gallery_ids = $gallery_ids[0];
    } else {
        return '';
    }

    return $gallery_ids;
}

function karo_light_body_class($class) {
    $kopa_setting = kopa_light_get_template_setting();
    if ($kopa_setting['layout_id'] == 'blog-left-sidebar') {
        $class[] = 'kp-right-sidebar';
    } elseif ($kopa_setting['layout_id'] == 'blog-right-sidebar') {
        $class[] = '';
    } elseif ($kopa_setting['layout_id'] == 'blog-no-sidebar' || $kopa_setting['layout_id'] == '404-page') {
        $class[] = 'kp-no-sidebar';
    }
    if (is_singular()) {
        if (get_post_format() == '') {
            $class[] = 'kp-single-standard';
        } elseif (get_post_format()) {
            $class[] = 'kp-single-' . get_post_format();
        }
    }
    return $class;
}

function karo_light_about_author() {
    if ('show' != get_theme_mod('karo_light_options_post_about_author_status', 'show')) {
        return;
    }
    ?>

    <div class="kopa-author">
        <div class="widget-content clearfix" itemscope itemtype="http://data-vocabulary.org/Person">
            <div class="author-thumb img-responsive pull-left">
                <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 94 ); ?></a>
            </div>
            <div class="item-right">
                <h4 class="author-title"><span itemprop="name"><?php the_author_posts_link(); ?></span></h4>
                <p><?php the_author_meta( 'description' ); ?></p>
            </div>
        </div>
    </div>
    <!-- about-author -->
    <?php
}

function karo_light_excerpt($content){
    if(get_the_title()==''){
        return $content.' ... <a href="'.  get_permalink().'">'. esc_attr__('Read more',  'karo-light').' </a>';
    }
    else{
        return $content;
    }
}

function kopa_light_get_template_setting($default = null) {
    if(function_exists('kopa_get_template_setting')){
        return kopa_get_template_setting();
    }

    return $default;
}

function kopa_light_get_headline(){
    $limit = (int) get_theme_mod('karo_light_options_header_headline_limit', 5);
    if ($limit) {
        $prefix = get_theme_mod('karo_light_options_header_headline_title', 'HEADLINE');
        $cats = (array)get_theme_mod('karo_light_options_header_headline_category');
        $cats = implode(',', $cats);

        if( !empty($cats) ){
            $posts = new WP_Query('cat='.$cats.'&posts_per_page='.$limit);
        }else{
            $posts = new WP_Query( 'posts_per_page='.$limit);
        }
        ?>
        <div class="kopa-list-news-carousel-widget">
            <h3 class="widget-title"><?php echo esc_attr( $prefix ); ?></h3>
            <div class="kp-headline clearfix">
                <?php
                if ($posts->have_posts()) { ?>
                    <div class="kp-headline-wrapper clearfix">
                        <div class="kp-headline clearfix">
                            <dl class="ticker-1 clearfix">
                                <dt style="display: none;">ticket title</dt>
                                <?php
                                while ($posts->have_posts()) {
                                    $posts->the_post();
                                    $post_url = get_permalink();
                                    $post_title = get_the_title();
                                    ?>
                                    <dd><a href="<?php echo esc_url( $post_url ); ?>" title="<?php echo get_the_title(); ?>"><?php echo esc_attr( $post_title ); ?></a></dd>
                                    <?php
                                }
                                wp_reset_query();
                                ?>
                            </dl>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    <?php
    }
}

/*
 * get slider
 */
function karo_light_slider(){
    $limit = (int) get_theme_mod('karo_light_options_slider_limit', 5);
    if ($limit) {
        $cats =  get_theme_mod('karo_light_options_slider_category');

        if ( !empty($cats)){
            $cats = (array)get_theme_mod('karo_light_options_slider_category');
            $cats = implode(',', $cats);
        }

        if( !empty($cats) ){
            $posts = new WP_Query('cat='.$cats.'&posts_per_page='.$limit.'&ignore_sticky_posts=1');
        }else{
            $posts = new WP_Query( 'posts_per_page='.$limit.'&ignore_sticky_posts=1');
        }
        ?>
            <div class="widget-area-20">
                <div class="widget kopa-thumb-big-carousel-widget">
                    <div class="widget-content">
                        <div class="owl-carousel" data-autoplay="true" data-slidespeed="700">
                            <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>
                            <div class="item">

                                <div class="post-thumb img-responsive">
                                    <?php
                                        if ( has_post_thumbnail()) {
                                            the_post_thumbnail( 'kopa-size-02' );
                                        } else {
                                            echo '<img src="'. get_template_directory_uri() .'/images/slider_no_thumb.gif" alt="' . esc_attr__('No thumbnail post', 'karo-light') . '" />';
                                        }
                                    ?>

                                </div>

                                <!-- post- thumb -->
                                <div class="item-content">
                                    <?php
                                    $kopa_cats1 = get_the_category(get_the_ID());
                                    if (!empty($kopa_cats1)) :
                                        $count = 0;
                                        ?>
                                        <h4 class="post-cat">
                                            <?php foreach ( $kopa_cats1 as $k => $v) : ?>
                                            <?php if ( $count < 6 && !empty($v->name) ) : ?>
                                                <a href="<?php echo get_category_link($v->term_id); ?>" title="<?php echo esc_attr( $v->name ); ?>"><?php echo esc_attr( $v->name ); ?></a>
                                                <?php $count++; ?>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </h4>

                                        <?php endif; ?>

                                    <div class="kopa-metadata">
                                        <?php
                                            $post_title = get_the_title();
                                            if ( empty($post_title) ) {
                                                echo '<a href="'. esc_url(get_permalink()) .'" title="' . esc_attr__('View post detail', 'karo-light') . '">';
                                            }
                                        ?>
                                        <span class="kopa-date"> <?php the_time(get_option('date_format')); ?></span>
                                        <?php
                                            if ( empty($post_title) ) {
                                                echo '<a href="'. esc_url(get_permalink()) .'">';
                                            }
                                        ?>
                                    </div>
                                    <!-- metadata -->
                                    <h4 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>
                                </div>
                            </div>
                            <!-- item -->
                            <?php endwhile; wp_reset_query();?>
                        </div>
                    </div>
                </div>
            </div>
    <?php
    }
}

/*
 * Kopa get category of post id
 */
function kopa_get_categories($id, $many_categories = false) {
    $categories = get_the_category($id);
    if ( empty($categories) ){
        return false;
    }

    if ( $many_categories ) {
        $obj_ret = $categories;
    } else {
        $obj_ret = $categories[0];
    }
    return $obj_ret;
}

function karo_light_related_articles() {
    if (is_single()) {
        $get_by = get_theme_mod('karo_light_options_post_related_get_by', 'post_tag');
        if ('hide' != $get_by) {
            $limit = (int) get_theme_mod('karo_light_options_post_related_limit', 4);
            if ($limit > 0) {
                global $post;
                $taxs = array();
                if ('category' == $get_by) {
                    $cats = get_the_category(($post->ID));
                    if ($cats) {
                        $ids = array();
                        foreach ($cats as $cat) {
                            $ids[] = $cat->term_id;
                        }
                        $taxs [] = array(
                            'taxonomy' => 'category',
                            'field' => 'id',
                            'terms' => $ids
                        );
                    }
                } else {
                    $tags = get_the_tags($post->ID);
                    if ($tags) {
                        $ids = array();
                        foreach ($tags as $tag) {
                            $ids[] = $tag->term_id;
                        }
                        $taxs [] = array(
                            'taxonomy' => 'post_tag',
                            'field' => 'id',
                            'terms' => $ids
                        );
                    }
                }

                if ($taxs) {
                    $related_args = array(
                        'tax_query' => $taxs,
                        'post__not_in' => array($post->ID),
                        'posts_per_page' => $limit
                    );
                    $related_posts = new WP_Query( $related_args );
                    if ( $related_posts->have_posts() ) { ?>

                    <div class="widget kopa-list-posts-carousel-4-widget">
                        <header class="widget-header">
                            <h3 class="widget-title"><?php esc_attr_e('RELATED ARTICLES', 'karo-light'); ?></h3>
                            <i class="fa fa-plus-square-o"></i>
                        </header>
                        <div class="widget-content">
                            <div class="owl-carousel">
                                <?php while ( $related_posts->have_posts() ) : $related_posts->the_post(); $post_title = get_the_title(); ?>
                                <div class="item">
                                    <div class="post-thumb<?php if ( !has_post_thumbnail()) echo ' no-post-thumb'; ?>">
                                        <?php if ( has_post_thumbnail()) : ?>
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="img-responsive">
                                            <?php the_post_thumbnail('kopa-size-32'); ?>
                                        </a>
                                        <?php endif; ?>

                                        <footer>
                                            <?php
                                            $related_categories = get_the_category(get_the_ID());
                                            $related_category = null;
                                            if( !empty($related_categories) ) {
                                                $related_category = $related_categories[0];
                                            }
                                            ?>
                                            <h4 class="post-cat"><a href="<?php echo get_category_link( $related_category->term_id ); ?>"><?php echo esc_attr( $related_category->name ); ?></a></h4>
                                            <?php if ( !empty($post_title) ) : ?>
                                                <span class="kopa-date"><?php the_time(get_option('date_format')); ?></span>
                                            <?php else : ?>
                                                <span class="kopa-date"><a href="<?php the_permalink(); ?>" title="<?php esc_attr_e('View post detail', 'karo-light');?>"><?php the_time(get_option('date_format')); ?></a></span>
                                            <?php endif; ?>
                                        </footer>
                                    </div>
                                    <!-- post-thumb -->
                                    <div class="item-content">
                                        <?php

                                        if ( !empty($post_title)) :
                                            ?>
                                            <h4 class="post-title">
                                                <a href="<?php the_permalink(); ?>" title="<?php the_title();?>"><?php the_title(); ?></a>
                                            </h4>
                                            <?php endif; ?>

                                        <div class="kopa-metadata-border">
                                            <?php if ( comments_open() ): ?>
                                            <?php comments_popup_link(__('<i class="fa fa-comment"></i> 0', 'karo-light'), esc_attr__('<i class="fa fa-comment"></i> 1', 'karo-light'), esc_attr__('<i class="fa fa-comment"></i> %', 'karo-light'));?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <!-- item content -->
                                </div>
                                <!-- item -->
                                <?php endwhile; ?>
                            </div>
                        </div>
                    </div>

                    <?php
                    } // endif
                    wp_reset_postdata();
                }
            }
        }
    }
}

function karo_light_the_date_custom ($post_id = 0, $format = 'Y') {
    $date = date_create(get_post_field( 'post_date', $post_id));
    if ( 'dM' === $format){
        echo esc_attr( $date->format('d').' '.$date->format('M') );
    }else{
        echo esc_attr( $date->format($format) );
    }
}

function karo_light_get_next_previous(){
    $prev_post = get_previous_post();
    $next_post = get_next_post();

    if ( get_next_post() || get_previous_post() ) :?>
        <ul class="pager-page list-unstyled clearfix">
            <?php if (!empty( $prev_post )):
            $categories = get_the_category($prev_post->ID);
            $category = null;
            if( !empty($categories) ) {
                $category = $categories[0];
            }
            ?>
                <li class="prev-post pull-left">
                    <h4 class="prev"><i class="fa fa-angle-double-left"></i><a href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php echo esc_attr__('Previous Article', 'karo-light');?></a></h4>
                    <?php if ( !empty($prev_post->post_title)) : ?>
                    <h4 class="post-title"><a href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php echo esc_attr( $prev_post->post_title ); ?></a></h4>
                    <?php endif; ?>
                    <span class="kopa-date"><?php echo get_the_time( get_option('date_format'), $prev_post->ID ); ?></span>
                    <a href="<?php echo get_category_link( $category->term_id ); ?>" class="post-cat"><?php echo esc_attr( $category->name ); ?></a>
                </li>
            <?php endif; ?>

            <?php if (!empty($next_post)) :
            $categories_next = get_the_category($next_post->ID);
            $category_next = null;
            if ( !empty($categories_next) ) {
                $category_next = $categories_next[0];
            }
            ?>
                <li class="next-post pull-right">
                    <h4 class="next"><a href="<?php echo get_permalink( $next_post->ID ); ?>"><?php echo esc_attr__('Next Article', 'karo-light');?></a><i class="fa fa-angle-double-right"></i></h4>
                    <?php if (!empty($next_post->post_title)) : ?>
                    <h4 class="post-title"><a href="<?php echo get_permalink( $next_post->ID ); ?>" title="<?php echo esc_attr( $next_post->post_title ); ?>"><?php echo esc_attr( $next_post->post_title ); ?></a></h4>
                    <?php endif; ?>

                    <?php
                    if (!empty($next_post->post_title)){ ?>
                        <span class="kopa-date"><?php echo get_the_time( get_option('date_format'), $next_post->ID ); ?></span>
                        <?php } else{?>
                        <span class="kopa-date"><a href="<?php echo get_permalink( $next_post->ID ); ?>" title="<?php esc_attr_e('Post no title', 'karo-light');?>"><?php echo get_the_time( get_option('date_format'), $next_post->ID ); ?></a></span>
                        <?php }
                    ?>
                    <a href="<?php echo get_category_link( $category_next->term_id ); ?>" class="post-cat"><?php echo esc_attr( $category_next->name ); ?></a>
                </li>
            <?php endif; ?>
        </ul>
    <?php endif;
}