<?php

add_action('after_setup_theme', 'karo_light_init');

function karo_light_init(){
	add_filter('kopa_customization_init_options', 'karo_light_init_options');
}

function karo_light_init_options($options){

	$all_cats = get_categories();
	$categories = array('' => esc_html__('Latest Posts', 'karo-light'));
	foreach ( $all_cats as $cat ) {
		$categories[ $cat->term_id ] = $cat->name;
	}

	#Sections
	$options['sections'][] = array(
    'id'    => 'karo_light_section_general_setting',
    'title' => esc_html__('General Setting', 'karo-light'));

    $options['sections'][] = array(
    'id'    => 'karo_light_section_slider',
    'title' => esc_html__('Slider', 'karo-light'));

    $options['sections'][] = array(
    'id'    => 'karo_light_section_single_post',
    'title' => esc_html__('Single Post', 'karo-light'));

    $options['sections'][] = array(
    'id'    => 'karo_light_section_social_links',
    'title' => esc_html__('Social Links', 'karo-light'));

	#GENERAL SETTING
	#1. Logo
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_logo',
		'label'       => esc_html__('Logo:', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#2. Top banner
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_top_banner',
		'label'       => esc_html__('Top Banner', 'karo-light'),
		'default'     => '',
		'description' => esc_html__('Paste your Adsense, BSA or other ad code here to show ads on top banner.', 'karo-light'),
		'type'        => 'textarea',
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#3. Top banner link
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_top_banner_link',
		'label'       => esc_html__('Top Banner URL', 'karo-light'),
		'default'     => '',
		'description' => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#4. Top banner target
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_top_banner_target',
		'label'       => esc_html__('Top Banner Target', 'karo-light'),
		'default'     => '_blank',
		'description' => '',
		'type'        => 'radio',
		'choices'     => array(
			'_blank' => esc_html__('Open in new tab', 'karo-light'),
			'_self' => esc_html__('Open in current tab', 'karo-light')
		),
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#5. Headlite title
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_header_headline_title',
		'label'       => esc_html__('Header Headline - Title', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#6. Headlite categories
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_header_headline_category',
		'label'       => esc_html__('Header Headline - Category', 'karo-light'),
		'default'     => '',
		'description' => esc_html__('Choose category to display posts in headline', 'karo-light'),
		'type'        => 'select',
		'choices'     => $categories,
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#7. Headlite limit
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_header_headline_limit',
		'label'       => esc_html__('Header Headline - Number Of Posts', 'karo-light'),
		'default'     => '5',
		'description' => esc_html__('Choose category to display posts in headline', 'karo-light'),
		'type'        => 'text',
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#8. Breadcrumbs
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_breadcrumb_status',
		'label'       => esc_html__('Breadcrumb', 'karo-light'),
		'default'     => 'show',
		'description' => esc_html__('Show/Hide Breadcrumb', 'karo-light'),
		'type'        => 'radio',
		'choices'     => array(
			'show' => esc_html__('Show', 'karo-light'),
			'hide' => esc_html__('Hide', 'karo-light')
		),
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');
	#9. Footer
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_footer',
		'label'       => esc_html__('Footer', 'karo-light'),
		'default'     => '',
		'description' => esc_html__('Enter the content you want to display in your left footer (e.g. copyright text).', 'karo-light'),
		'type'        => 'textarea',
		'section'     => 'karo_light_section_general_setting',
		'transport'   => 'refresh');

	#SLIDER
	#1. Slider categories
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_slider_category',
		'label'       => esc_html__('Slider - Category', 'karo-light'),
		'default'     => '',
		'description' => esc_html__('Choose category to display posts in slider', 'karo-light'),
		'type'        => 'select',
		'choices'     => $categories,
		'section'     => 'karo_light_section_slider',
		'transport'   => 'refresh');
	#2. Sldier limit
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_slider_limit',
		'label'       => esc_html__('Slider - Number Of Posts', 'karo-light'),
		'default'     => '5',
		'description' => esc_html__('Choose category to display posts in slider', 'karo-light'),
		'type'        => 'text',
		'section'     => 'karo_light_section_slider',
		'transport'   => 'refresh');

	#SINGLE POST
	#1. Featured post thumbnail
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_featured_image_status',
		'label'       => esc_html__('Featured Post Thumbnail', 'karo-light'),
		'description' => esc_html__('Show/Hide featured post thumbnail', 'karo-light'),
		'default'     => 'show',
		'choices'     => array(
			'show' => esc_html__('Show', 'karo-light'),
			'hide' => esc_html__('Hide', 'karo-light')
		),
		'type'        => 'radio',
		'section'     => 'karo_light_section_single_post',
		'transport'   => 'refresh');
	#2. About author
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_post_about_author_status',
		'label'       => esc_html__('About Author', 'karo-light'),
		'description' => esc_html__('Show/Hide about author', 'karo-light'),
		'default'     => 'show',
		'choices'     => array(
			'show' => esc_html__('Show', 'karo-light'),
			'hide' => esc_html__('Hide', 'karo-light')
		),
		'type'        => 'radio',
		'section'     => 'karo_light_section_single_post',
		'transport'   => 'refresh');
	#3. Get by
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_post_related_get_by',
		'label'       => esc_html__('Related Posts', 'karo-light'),
		'default'     => 'category',
		'description' => esc_html__('GET BY', 'karo-light'),
		'type'        => 'select',
		'choices'     => array(
			'hide'     => esc_html__('-- Hide --', 'karo-light'),
			'post_tag' => esc_html__('Tags', 'karo-light'),
			'category' => esc_html__('Category', 'karo-light')
		),
		'section'     => 'karo_light_section_single_post',
		'transport'   => 'refresh');
	#4. Related Posts - Limit
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_post_related_limit',
		'label'       => esc_html__('Related Posts', 'karo-light'),
		'default'     => 5,
		'description' => esc_html__('LIMIT', 'karo-light'),
		'type'        => 'text',
		'section'     => 'karo_light_section_single_post',
		'transport'   => 'refresh');

	#SOCIAL LINKS
	#1. RSS URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_rss_url',
		'label'       => esc_html__('RSS URL', 'karo-light'),
		'default'     => '',
		'description' => esc_attr__('Display the RSS feed button with the default RSS feed or enter a custom feed below.<code>Enter "HIDE" if you want to hide it</code>', 'karo-light'),
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#2. FACEBOOK URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_facebook_url',
		'label'       => esc_html__('FACEBOOK URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#3. TWITTER URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_twitter_url',
		'label'       => esc_html__('TWITTER URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#4. GOOGLE + URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_google_plus_url',
		'label'       => esc_html__('GOOGLE PLUS URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#5. SKYPE
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_skype',
		'label'       => esc_html__('SKYPE', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#6. DRIBBBLE URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_dribbble_url',
		'label'       => esc_html__('DRIBBBLE URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#7. TUMBLR URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_tumblr_url',
		'label'       => esc_html__('TUMBLR URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#8. PINTEREST URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_pinterest_url',
		'label'       => esc_html__('PINTEREST URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#9. LINKEDIN URL
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_linkedin_url',
		'label'       => esc_html__('LINKEDIN URL', 'karo-light'),
		'default'     => '',
		'type'        => 'text',
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');
	#10. Target
	$options['settings'][] = array(
		'settings'    => 'karo_light_options_social_links_target',
		'label'       => esc_html__('Target', 'karo-light'),
		'default'     => '_self',
		'type'        => 'select',
		'choices'     => array(
			'_blank' => esc_html__('Open window in new tab', 'karo-light'),
			'_self'  => esc_html__('Open window in current tab', 'karo-light')
		),
		'section'     => 'karo_light_section_social_links',
		'transport'   => 'refresh');

	return apply_filters( 'karo_light_init_options', $options );
}